/*
 * Decompiled with CFR 0.152.
 */
package com.cx.restclient.common;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

public abstract class ShragaUtils {
    public static final String INCLUDES_LIST = "includes";
    public static final String EXCLUDES_LIST = "excludes";

    public static Map<String, List<String>> generateIncludesExcludesPatternLists(String folderExclusions, String filterPattern, Logger log) {
        folderExclusions = ShragaUtils.removeSpaceAndNewLine(folderExclusions);
        filterPattern = ShragaUtils.removeSpaceAndNewLine(filterPattern);
        String excludeFoldersPattern = ShragaUtils.processExcludeFolders(folderExclusions, log);
        String combinedPatterns = "";
        combinedPatterns = StringUtils.isEmpty((CharSequence)filterPattern) && StringUtils.isEmpty((CharSequence)excludeFoldersPattern) ? "" : (!StringUtils.isEmpty((CharSequence)filterPattern) && StringUtils.isEmpty((CharSequence)excludeFoldersPattern) ? filterPattern : (StringUtils.isEmpty((CharSequence)filterPattern) && !StringUtils.isEmpty((CharSequence)excludeFoldersPattern) ? excludeFoldersPattern : filterPattern + "," + excludeFoldersPattern));
        return ShragaUtils.convertPatternsToLists(combinedPatterns);
    }

    public static String removeSpaceAndNewLine(String str) {
        if (str != null) {
            String[] strings;
            str = str.replace("\\s", "").replace("\n", "").replace("\r", "").replace("\t", "");
            StringBuilder sb = new StringBuilder();
            for (String s : strings = str.split(",")) {
                sb.append(s.trim());
                sb.append(",");
            }
            str = sb.toString();
            str = StringUtils.removeEnd((String)str, (String)",");
        }
        return str;
    }

    public static String processExcludeFolders(String folderExclusions, Logger log) {
        String[] patterns;
        if (StringUtils.isEmpty((CharSequence)folderExclusions)) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        for (String p : patterns = StringUtils.split((String)folderExclusions, (String)",\n")) {
            if ((p = p.trim()).length() <= 0) continue;
            result.append("!**/");
            result.append(p);
            result.append("/**,");
        }
        log.info("These files/folders will be skipped: '" + result.toString() + "'");
        return result.toString();
    }

    public static Map<String, List<String>> convertPatternsToLists(String filterPatterns) {
        String[] filters;
        filterPatterns = StringUtils.defaultString((String)filterPatterns);
        ArrayList<String> inclusions = new ArrayList<String>();
        ArrayList<String> exclusions = new ArrayList<String>();
        for (String filter : filters = filterPatterns.replace("\n", "").replace("\r", "").split("\\s*,\\s*")) {
            if (!StringUtils.isNotEmpty((CharSequence)filter)) continue;
            if (!filter.startsWith("!")) {
                inclusions.add(filter.trim());
                continue;
            }
            if (filter.length() <= 1) continue;
            filter = filter.substring(1);
            exclusions.add(filter.trim());
        }
        HashMap<String, List<String>> ret = new HashMap<String, List<String>>();
        ret.put(INCLUDES_LIST, inclusions);
        ret.put(EXCLUDES_LIST, exclusions);
        return ret;
    }

    public static String formatDate(String date, String fromFormat, String toFormat) {
        SimpleDateFormat fromDate = new SimpleDateFormat(fromFormat);
        SimpleDateFormat toDate = new SimpleDateFormat(toFormat);
        String ret = "";
        try {
            ret = toDate.format(fromDate.parse(date));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    public static String getTimestampSince(long startTimeSec) {
        long elapsedSec = System.currentTimeMillis() / 1000L - startTimeSec;
        long hours = elapsedSec / 3600L;
        long minutes = elapsedSec % 3600L / 60L;
        long seconds = elapsedSec % 60L;
        String hoursStr = hours < 10L ? "0" + hours : Long.toString(hours);
        String minutesStr = minutes < 10L ? "0" + minutes : Long.toString(minutes);
        String secondsStr = seconds < 10L ? "0" + seconds : Long.toString(seconds);
        return String.format("%s:%s:%s", hoursStr, minutesStr, secondsStr);
    }
}

