/*
 * Decompiled with CFR 0.152.
 */
package com.cx.restclient.ast.dto.sca;

import com.cx.restclient.ast.dto.sca.report.AstScaSummaryResults;
import com.cx.restclient.ast.dto.sca.report.Finding;
import com.cx.restclient.ast.dto.sca.report.Package;
import com.cx.restclient.ast.dto.sca.report.PolicyEvaluation;
import com.cx.restclient.dto.Results;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;

public class AstScaResults
extends Results
implements Serializable {
    private String scanId;
    private String reportId;
    private byte[] rawXMLReport;
    private String scaPDFLink;
    private byte[] PDFReport;
    private String pdfFileName;
    private AstScaSummaryResults summary;
    private String webReportLink;
    private List<Finding> findings;
    private List<Package> packages;
    private boolean scaResultReady;
    private int nonVulnerableLibraries;
    private int vulnerableAndOutdated;
    private List<PolicyEvaluation> policyEvaluations;
    private boolean policyViolated;
    private boolean breakTheBuild;

    public String getScaPDFLink() {
        return this.scaPDFLink;
    }

    public void setScaPDFLink(String scaPDFLink) {
        this.scaPDFLink = scaPDFLink;
    }

    public byte[] getRawXMLReport() {
        return this.rawXMLReport;
    }

    public void setRawXMLReport(byte[] rawXMLReport) {
        this.rawXMLReport = rawXMLReport;
    }

    public byte[] getPDFReport() {
        return this.PDFReport;
    }

    public void setPDFReport(byte[] pDFReport) {
        this.PDFReport = pDFReport;
    }

    public String getPdfFileName() {
        return this.pdfFileName;
    }

    public void setPdfFileName(String pdfFileName) {
        this.pdfFileName = pdfFileName;
    }

    public String getScanId() {
        return this.scanId;
    }

    public void setScanId(String scanId) {
        this.scanId = scanId;
    }

    public String getReportId() {
        return this.reportId;
    }

    public void setReportId(String reportId) {
        this.reportId = reportId;
    }

    public AstScaSummaryResults getSummary() {
        return this.summary;
    }

    public void setSummary(AstScaSummaryResults summary) {
        this.summary = summary;
    }

    public String getWebReportLink() {
        return this.webReportLink;
    }

    public void setWebReportLink(String webReportLink) {
        this.webReportLink = webReportLink;
    }

    public List<Finding> getFindings() {
        return this.findings;
    }

    public void setFindings(List<Finding> findings) {
        this.findings = findings;
    }

    public List<Package> getPackages() {
        return this.packages;
    }

    public void setPackages(List<Package> packages) {
        this.packages = packages;
    }

    public boolean isScaResultReady() {
        return this.scaResultReady;
    }

    public void setScaResultReady(boolean scaResultReady) {
        this.scaResultReady = scaResultReady;
    }

    public int getNonVulnerableLibraries() {
        return this.nonVulnerableLibraries;
    }

    public void setNonVulnerableLibraries(int nonVulnerableLibraries) {
        this.nonVulnerableLibraries = nonVulnerableLibraries;
    }

    public int getVulnerableAndOutdated() {
        return this.vulnerableAndOutdated;
    }

    public void setVulnerableAndOutdated(int vulnerableAndOutdated) {
        this.vulnerableAndOutdated = vulnerableAndOutdated;
    }

    public List<PolicyEvaluation> getPolicyEvaluations() {
        return this.policyEvaluations;
    }

    public void setPolicyEvaluations(List<PolicyEvaluation> policyEvaluations) {
        this.policyEvaluations = policyEvaluations;
    }

    public boolean isPolicyViolated() {
        return this.policyViolated;
    }

    public void setPolicyViolated(boolean policyViolated) {
        this.policyViolated = policyViolated;
    }

    public boolean isBreakTheBuild() {
        return this.breakTheBuild;
    }

    public void setBreakTheBuild(boolean breakTheBuild) {
        this.breakTheBuild = breakTheBuild;
    }

    public void calculateVulnerableAndOutdatedPackages() {
        if (this.packages != null) {
            for (Package pckg : this.packages) {
                int sum = pckg.getCriticalVulnerabilityCount() + pckg.getHighVulnerabilityCount() + pckg.getMediumVulnerabilityCount() + pckg.getLowVulnerabilityCount();
                if (sum == 0) {
                    ++this.nonVulnerableLibraries;
                    continue;
                }
                if (sum <= 0 || !pckg.isOutdated()) continue;
                ++this.vulnerableAndOutdated;
            }
        }
    }

    public static AstScaResultsBuilder builder() {
        return new AstScaResultsBuilder();
    }

    public AstScaResults() {
    }

    public AstScaResults(String scanId, String reportId, byte[] rawXMLReport, String scaPDFLink, byte[] PDFReport, String pdfFileName, AstScaSummaryResults summary, String webReportLink, List<Finding> findings, List<Package> packages, boolean scaResultReady, int nonVulnerableLibraries, int vulnerableAndOutdated, List<PolicyEvaluation> policyEvaluations, boolean policyViolated, boolean breakTheBuild) {
        this.scanId = scanId;
        this.reportId = reportId;
        this.rawXMLReport = rawXMLReport;
        this.scaPDFLink = scaPDFLink;
        this.PDFReport = PDFReport;
        this.pdfFileName = pdfFileName;
        this.summary = summary;
        this.webReportLink = webReportLink;
        this.findings = findings;
        this.packages = packages;
        this.scaResultReady = scaResultReady;
        this.nonVulnerableLibraries = nonVulnerableLibraries;
        this.vulnerableAndOutdated = vulnerableAndOutdated;
        this.policyEvaluations = policyEvaluations;
        this.policyViolated = policyViolated;
        this.breakTheBuild = breakTheBuild;
    }

    public static class AstScaResultsBuilder {
        private String scanId;
        private String reportId;
        private byte[] rawXMLReport;
        private String scaPDFLink;
        private byte[] PDFReport;
        private String pdfFileName;
        private AstScaSummaryResults summary;
        private String webReportLink;
        private List<Finding> findings;
        private List<Package> packages;
        private boolean scaResultReady;
        private int nonVulnerableLibraries;
        private int vulnerableAndOutdated;
        private List<PolicyEvaluation> policyEvaluations;
        private boolean policyViolated;
        private boolean breakTheBuild;

        AstScaResultsBuilder() {
        }

        public AstScaResultsBuilder scanId(String scanId) {
            this.scanId = scanId;
            return this;
        }

        public AstScaResultsBuilder reportId(String reportId) {
            this.reportId = reportId;
            return this;
        }

        public AstScaResultsBuilder rawXMLReport(byte[] rawXMLReport) {
            this.rawXMLReport = rawXMLReport;
            return this;
        }

        public AstScaResultsBuilder scaPDFLink(String scaPDFLink) {
            this.scaPDFLink = scaPDFLink;
            return this;
        }

        public AstScaResultsBuilder PDFReport(byte[] PDFReport) {
            this.PDFReport = PDFReport;
            return this;
        }

        public AstScaResultsBuilder pdfFileName(String pdfFileName) {
            this.pdfFileName = pdfFileName;
            return this;
        }

        public AstScaResultsBuilder summary(AstScaSummaryResults summary) {
            this.summary = summary;
            return this;
        }

        public AstScaResultsBuilder webReportLink(String webReportLink) {
            this.webReportLink = webReportLink;
            return this;
        }

        public AstScaResultsBuilder findings(List<Finding> findings) {
            this.findings = findings;
            return this;
        }

        public AstScaResultsBuilder packages(List<Package> packages) {
            this.packages = packages;
            return this;
        }

        public AstScaResultsBuilder scaResultReady(boolean scaResultReady) {
            this.scaResultReady = scaResultReady;
            return this;
        }

        public AstScaResultsBuilder nonVulnerableLibraries(int nonVulnerableLibraries) {
            this.nonVulnerableLibraries = nonVulnerableLibraries;
            return this;
        }

        public AstScaResultsBuilder vulnerableAndOutdated(int vulnerableAndOutdated) {
            this.vulnerableAndOutdated = vulnerableAndOutdated;
            return this;
        }

        public AstScaResultsBuilder policyEvaluations(List<PolicyEvaluation> policyEvaluations) {
            this.policyEvaluations = policyEvaluations;
            return this;
        }

        public AstScaResultsBuilder policyViolated(boolean policyViolated) {
            this.policyViolated = policyViolated;
            return this;
        }

        public AstScaResultsBuilder breakTheBuild(boolean breakTheBuild) {
            this.breakTheBuild = breakTheBuild;
            return this;
        }

        public AstScaResults build() {
            return new AstScaResults(this.scanId, this.reportId, this.rawXMLReport, this.scaPDFLink, this.PDFReport, this.pdfFileName, this.summary, this.webReportLink, this.findings, this.packages, this.scaResultReady, this.nonVulnerableLibraries, this.vulnerableAndOutdated, this.policyEvaluations, this.policyViolated, this.breakTheBuild);
        }

        public String toString() {
            return "AstScaResults.AstScaResultsBuilder(scanId=" + this.scanId + ", reportId=" + this.reportId + ", rawXMLReport=" + Arrays.toString(this.rawXMLReport) + ", scaPDFLink=" + this.scaPDFLink + ", PDFReport=" + Arrays.toString(this.PDFReport) + ", pdfFileName=" + this.pdfFileName + ", summary=" + this.summary + ", webReportLink=" + this.webReportLink + ", findings=" + this.findings + ", packages=" + this.packages + ", scaResultReady=" + this.scaResultReady + ", nonVulnerableLibraries=" + this.nonVulnerableLibraries + ", vulnerableAndOutdated=" + this.vulnerableAndOutdated + ", policyEvaluations=" + this.policyEvaluations + ", policyViolated=" + this.policyViolated + ", breakTheBuild=" + this.breakTheBuild + ")";
        }
    }
}

