/*
 * Decompiled with CFR 0.152.
 */
package com.cx.restclient.ast;

import com.cx.restclient.configuration.CxScanConfig;
import com.cx.restclient.exception.CxClientException;
import com.cx.restclient.httpClient.CxHttpClient;
import com.cx.restclient.osa.dto.ClientType;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientTypeResolver {
    private static final Logger log = LoggerFactory.getLogger(ClientTypeResolver.class);
    private static final String WELL_KNOWN_CONFIG_PATH = "identity/.well-known/openid-configuration";
    private static final String SCOPES_JSON_PROP = "scopes_supported";
    private static final Set<String> scopesForCloudAuth = new HashSet<String>(Arrays.asList("sca_api", "offline_access"));
    private static final Set<String> scopesForOnPremAuth = new HashSet<String>(Arrays.asList("sast_rest_api", "cxarm_api"));
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private CxHttpClient httpClient;
    private CxScanConfig config;

    public ClientTypeResolver(CxScanConfig config) {
        this.config = config;
    }

    public ClientType determineClientType(String accessControlServerBaseUrl) {
        JsonNode response = this.getConfigResponse(accessControlServerBaseUrl);
        Set<String> supportedScopes = ClientTypeResolver.getSupportedScopes(response);
        Set<String> scopesToUse = this.getScopesForAuth(supportedScopes);
        String clientSecret = scopesToUse.equals(scopesForOnPremAuth) ? ClientType.RESOURCE_OWNER.getClientSecret() : "";
        String scopesForRequest = String.join((CharSequence)" ", scopesToUse);
        return ClientType.builder().clientId(ClientType.RESOURCE_OWNER.getClientId()).scopes(scopesForRequest).clientSecret(clientSecret).build();
    }

    private Set<String> getScopesForAuth(Set<String> supportedScopes) {
        Set<String> result;
        if (supportedScopes.containsAll(scopesForCloudAuth)) {
            result = scopesForCloudAuth;
        } else if (supportedScopes.containsAll(scopesForOnPremAuth)) {
            result = scopesForOnPremAuth;
        } else {
            String message = String.format("Access control server doesn't support the necessary scopes (either %s or %s). It only supports the following scopes: %s.", scopesForCloudAuth, scopesForOnPremAuth, supportedScopes);
            throw new CxClientException(message);
        }
        log.debug(String.format("Using scopes: %s", result));
        return result;
    }

    private JsonNode getConfigResponse(String accessControlServerBaseUrl) {
        try {
            String res = this.getHttpClient(accessControlServerBaseUrl).getRequest(WELL_KNOWN_CONFIG_PATH, "application/json;v=1.0", String.class, 200, "Get openId configuration", false);
            return objectMapper.readTree(res);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new CxClientException("Error getting OpenID config response.", e);
        }
    }

    private CxHttpClient getHttpClient(String acBaseUrl) {
        if (this.httpClient == null) {
            this.httpClient = new CxHttpClient(StringUtils.appendIfMissing((String)acBaseUrl, (CharSequence)"/", (CharSequence[])new CharSequence[0]), this.config.getCxOrigin(), this.config.getCxOriginUrl(), this.config.isDisableCertificateValidation(), this.config.isUseSSOLogin(), this.config.getRefreshToken(), this.config.isScaProxy(), this.config.getScaProxyConfig(), log, this.config.getNTLM(), this.config.getPluginVersion());
        }
        return this.httpClient;
    }

    private static Set<String> getSupportedScopes(JsonNode response) {
        Set result = null;
        if (response != null) {
            TypeReference<Set<String>> typeRef = new TypeReference<Set<String>>(){};
            result = (Set)objectMapper.convertValue((Object)response.get(SCOPES_JSON_PROP), (TypeReference)typeRef);
        }
        return Optional.ofNullable(result).orElse(new HashSet());
    }
}

