/*
 * Decompiled with CFR 0.152.
 */
package com.cx.restclient.ast;

import com.cx.restclient.ast.AstClient;
import com.cx.restclient.ast.dto.common.ScanInfoResponse;
import com.cx.restclient.ast.dto.common.ScanStatus;
import com.cx.restclient.common.ShragaUtils;
import com.cx.restclient.configuration.CxScanConfig;
import com.cx.restclient.exception.CxClientException;
import com.cx.restclient.httpClient.CxHttpClient;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.awaitility.Awaitility;
import org.awaitility.core.ConditionTimeoutException;
import org.slf4j.Logger;

public class AstWaiter {
    private final CxHttpClient httpClient;
    private final CxScanConfig config;
    private final String scannerDisplayName;
    private long startTimestampSec;
    private final Logger log;

    public void waitForScanToFinish(String scanId) {
        this.startTimestampSec = System.currentTimeMillis() / 1000L;
        Duration timeout = AstWaiter.getTimeout(this.config);
        Duration pollInterval = AstWaiter.getPollInterval(this.config);
        int maxErrorCount = AstWaiter.getMaxErrorCount(this.config);
        AtomicInteger errorCounter = new AtomicInteger();
        try {
            String urlPath = String.format(AstClient.GET_SCAN, URLEncoder.encode(scanId, AstClient.ENCODING));
            Awaitility.await().atMost(timeout).pollDelay(Duration.ZERO).pollInterval(pollInterval).until(() -> this.scanIsCompleted(urlPath, errorCounter, maxErrorCount));
        }
        catch (ConditionTimeoutException e) {
            String message = String.format("Failed to perform %s scan. The scan has been automatically aborted: reached the user-specified timeout (%d minutes).", this.scannerDisplayName, timeout.toMinutes());
            throw new ConditionTimeoutException(message);
        }
        catch (UnsupportedEncodingException e) {
            this.log.error("Unexpected error.", (Throwable)e);
        }
    }

    private static Duration getTimeout(CxScanConfig config) {
        Integer rawTimeout = config.getOsaScanTimeoutInMinutes();
        if (config.isAstScaEnabled()) {
            rawTimeout = config.getSCAScanTimeoutInMinutes();
        }
        int DEFAULT_TIMEOUT = 60;
        rawTimeout = rawTimeout != null && rawTimeout > 0 ? rawTimeout : 60;
        return Duration.ofMinutes(rawTimeout.intValue());
    }

    private static Duration getPollInterval(CxScanConfig config) {
        int rawPollInterval = (Integer)ObjectUtils.defaultIfNull((Object)config.getOsaProgressInterval(), (Object)20);
        return Duration.ofSeconds(rawPollInterval);
    }

    private static int getMaxErrorCount(CxScanConfig config) {
        return (Integer)ObjectUtils.defaultIfNull((Object)config.getConnectionRetries(), (Object)3);
    }

    private boolean scanIsCompleted(String path, AtomicInteger errorCounter, int maxErrorCount) {
        ScanInfoResponse response = null;
        String errorMessage = null;
        try {
            String failedMessage = this.scannerDisplayName + " scan";
            response = this.httpClient.getRequest(path, "application/json", ScanInfoResponse.class, 200, failedMessage, false);
        }
        catch (Exception e) {
            errorMessage = e.getMessage();
        }
        boolean completedSuccessfully = false;
        if (response == null) {
            this.countError(errorCounter, maxErrorCount, errorMessage);
        } else {
            ScanStatus status = this.extractScanStatusFrom(response);
            completedSuccessfully = this.handleScanStatus(status);
        }
        return completedSuccessfully;
    }

    private boolean handleScanStatus(ScanStatus status) {
        boolean completedSuccessfully = false;
        if (status == ScanStatus.COMPLETED) {
            completedSuccessfully = true;
        } else {
            if (status == ScanStatus.FAILED) {
                throw new CxClientException(String.format("Scan status is %s, aborting.", new Object[]{status}));
            }
            if (status == null) {
                this.log.warn("Unknown status.");
            }
        }
        return completedSuccessfully;
    }

    private void countError(AtomicInteger errorCounter, int maxErrorCount, String message) {
        int currentErrorCount = errorCounter.incrementAndGet();
        int triesLeft = maxErrorCount - currentErrorCount;
        if (triesLeft < 0) {
            String fullMessage = String.format("Maximum number of errors was reached (%d), aborting.", maxErrorCount);
            throw new CxClientException(fullMessage);
        }
        String note = triesLeft == 0 ? "last attempt" : String.format("tries left: %d", triesLeft);
        this.log.info(String.format("Failed to get status from %s with the message: %s. Retrying (%s)", this.scannerDisplayName, message, note));
    }

    private ScanStatus extractScanStatusFrom(ScanInfoResponse response) {
        String rawStatus = response.getStatus();
        String elapsedTimestamp = ShragaUtils.getTimestampSince(this.startTimestampSec);
        this.log.info(String.format("Waiting for %s scan results. Elapsed time: %s. Status: %s.", this.scannerDisplayName, elapsedTimestamp, rawStatus));
        return (ScanStatus)EnumUtils.getEnumIgnoreCase(ScanStatus.class, (String)rawStatus);
    }

    public AstWaiter(CxHttpClient httpClient, CxScanConfig config, String scannerDisplayName, Logger log) {
        this.httpClient = httpClient;
        this.config = config;
        this.scannerDisplayName = scannerDisplayName;
        this.log = log;
    }
}

