/*
 * Decompiled with CFR 0.152.
 */
package com.cx.restclient;

import com.cx.restclient.common.Scanner;
import com.cx.restclient.common.ShragaUtils;
import com.cx.restclient.common.Waiter;
import com.cx.restclient.configuration.CxScanConfig;
import com.cx.restclient.cxArm.dto.CxProviders;
import com.cx.restclient.cxArm.utils.CxARMUtils;
import com.cx.restclient.dto.CxVersion;
import com.cx.restclient.dto.PathFilter;
import com.cx.restclient.dto.RemoteSourceRequest;
import com.cx.restclient.dto.RemoteSourceTypes;
import com.cx.restclient.dto.Results;
import com.cx.restclient.dto.Status;
import com.cx.restclient.exception.CxClientException;
import com.cx.restclient.exception.CxHTTPClientException;
import com.cx.restclient.httpClient.utils.HttpClientHelper;
import com.cx.restclient.sast.dto.CreateReportRequest;
import com.cx.restclient.sast.dto.CreateReportResponse;
import com.cx.restclient.sast.dto.CreateScanRequest;
import com.cx.restclient.sast.dto.CurrentStatus;
import com.cx.restclient.sast.dto.CxARMStatus;
import com.cx.restclient.sast.dto.CxARMStatusEnum;
import com.cx.restclient.sast.dto.CxID;
import com.cx.restclient.sast.dto.CxXMLResults;
import com.cx.restclient.sast.dto.ExcludeSettingsRequest;
import com.cx.restclient.sast.dto.LastScanResponse;
import com.cx.restclient.sast.dto.Project;
import com.cx.restclient.sast.dto.ProjectLevelCustomFields;
import com.cx.restclient.sast.dto.ProjectPutRequest;
import com.cx.restclient.sast.dto.QueueStatus;
import com.cx.restclient.sast.dto.ReportStatus;
import com.cx.restclient.sast.dto.ReportStatusEnum;
import com.cx.restclient.sast.dto.ReportType;
import com.cx.restclient.sast.dto.ResponseQueueScanStatus;
import com.cx.restclient.sast.dto.ResponseSastScanStatus;
import com.cx.restclient.sast.dto.SASTResults;
import com.cx.restclient.sast.dto.SASTStatisticsResponse;
import com.cx.restclient.sast.dto.ScanSettingRequest;
import com.cx.restclient.sast.dto.ScanSettingResponse;
import com.cx.restclient.sast.dto.ScanWithSettingsResponse;
import com.cx.restclient.sast.dto.UpdateScanStatusRequest;
import com.cx.restclient.sast.utils.LegacyClient;
import com.cx.restclient.sast.utils.SASTUtils;
import com.cx.restclient.sast.utils.State;
import com.cx.restclient.sast.utils.zip.CxZipUtils;
import com.google.gson.Gson;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import org.apache.http.HttpEntity;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.awaitility.core.ConditionTimeoutException;
import org.json.JSONObject;
import org.slf4j.Logger;

public class CxSASTClient
extends LegacyClient
implements Scanner {
    public static final String JENKINS = "jenkins";
    private int reportTimeoutSec = 5000;
    private int cxARMTimeoutSec = 1000;
    private Waiter<ResponseQueueScanStatus> sastWaiter;
    private static final String SCAN_ID_PATH_PARAM = "{scanId}";
    private static final String PROJECT_ID_PATH_PARAM = "{projectId}";
    private static final String SCAN_WITH_SETTINGS_URL = "sast/scanWithSettings";
    private static final String ENGINE_CONFIGURATION_ID_DEFAULT = "0";
    private long scanId;
    private SASTResults sastResults = new SASTResults();
    private static final String SWAGGER_LOCATION = "help/swagger/docs/v1.1";
    private static final String ZIPPED_SOURCE = "zippedSource";
    private static final String SAST_SCAN = "SAST scan status";
    private static final String MSG_AVOID_DUPLICATE_PROJECT_SCANS = "\nAvoid duplicate project scans in queue\n";
    private String language = "en-US";
    private Waiter<ReportStatus> reportWaiter = new Waiter<ReportStatus>("Scan report", 10, 3){

        @Override
        public ReportStatus getStatus(String id) throws IOException {
            return this.getReportStatus(id);
        }

        @Override
        public void printProgress(ReportStatus reportStatus) {
            this.printReportProgress(reportStatus, this.getStartTimeSec());
        }

        @Override
        public ReportStatus resolveStatus(ReportStatus reportStatus) {
            return this.resolveReportStatus(reportStatus);
        }

        private ReportStatus getReportStatus(String reportId) throws CxClientException, IOException {
            ReportStatus reportStatus = CxSASTClient.this.httpClient.getRequest("reports/sastScan/{reportId}/status".replace("{reportId}", reportId), "application/json;v=1.0", ReportStatus.class, 200, " report status", false);
            reportStatus.setBaseId(reportId);
            String currentStatus = reportStatus.getStatus().getValue();
            if (currentStatus.equals(ReportStatusEnum.INPROCESS.value())) {
                reportStatus.setBaseStatus(Status.IN_PROGRESS);
            } else if (currentStatus.equals(ReportStatusEnum.FAILED.value())) {
                reportStatus.setBaseStatus(Status.FAILED);
            } else {
                reportStatus.setBaseStatus(Status.SUCCEEDED);
            }
            return reportStatus;
        }

        private ReportStatus resolveReportStatus(ReportStatus reportStatus) throws CxClientException {
            if (reportStatus != null) {
                if (Status.SUCCEEDED == reportStatus.getBaseStatus()) {
                    return reportStatus;
                }
                throw new CxClientException("Generation of scan report [id=" + reportStatus.getBaseId() + "] failed.");
            }
            throw new CxClientException("Generation of scan report failed.");
        }

        private void printReportProgress(ReportStatus reportStatus, long startTime) {
            String reportType = reportStatus.getContentType().replace("application/", "");
            log.info("Waiting for server to generate " + reportType + " report. " + (startTime + (long)CxSASTClient.this.reportTimeoutSec - System.currentTimeMillis() / 1000L) + " seconds left to timeout");
        }
    };
    private Waiter<CxARMStatus> cxARMWaiter = new Waiter<CxARMStatus>("CxARM policy violations", 20, 3){

        @Override
        public CxARMStatus getStatus(String id) throws IOException {
            return this.getCxARMStatus(id);
        }

        @Override
        public void printProgress(CxARMStatus cxARMStatus) {
            this.printCxARMProgress(this.getStartTimeSec());
        }

        @Override
        public CxARMStatus resolveStatus(CxARMStatus cxARMStatus) {
            return this.resolveCxARMStatus(cxARMStatus);
        }

        private CxARMStatus getCxARMStatus(String projectId) throws CxClientException, IOException {
            CxARMStatus cxARMStatus = CxSASTClient.this.httpClient.getRequest("sast/projects/{projectId}/publisher/policyFindings/status".replace(CxSASTClient.PROJECT_ID_PATH_PARAM, projectId), "application/json;v=1.0", CxARMStatus.class, 200, " cxARM status", false);
            cxARMStatus.setBaseId(projectId);
            String currentStatus = cxARMStatus.getStatus();
            if (currentStatus.equals(CxARMStatusEnum.IN_PROGRESS.value())) {
                cxARMStatus.setBaseStatus(Status.IN_PROGRESS);
            } else if (currentStatus.equals(CxARMStatusEnum.FAILED.value())) {
                cxARMStatus.setBaseStatus(Status.FAILED);
            } else if (currentStatus.equals(CxARMStatusEnum.FINISHED.value())) {
                cxARMStatus.setBaseStatus(Status.SUCCEEDED);
            } else {
                cxARMStatus.setBaseStatus(Status.FAILED);
            }
            return cxARMStatus;
        }

        private void printCxARMProgress(long startTime) {
            log.info("Waiting for server to retrieve policy violations. " + (startTime + (long)CxSASTClient.this.cxARMTimeoutSec - System.currentTimeMillis() / 1000L) + " seconds left to timeout");
        }

        private CxARMStatus resolveCxARMStatus(CxARMStatus cxARMStatus) throws CxClientException {
            if (cxARMStatus != null) {
                if (Status.SUCCEEDED == cxARMStatus.getBaseStatus()) {
                    return cxARMStatus;
                }
                throw new CxClientException("Getting policy violations of project [id=" + cxARMStatus.getBaseId() + "] failed.");
            }
            throw new CxClientException("Getting policy violations of project failed.");
        }
    };

    public CxSASTClient(CxScanConfig config, Logger log) throws MalformedURLException {
        super(config, log);
        int interval = config.getProgressInterval() != null ? config.getProgressInterval() : 20;
        int retry = config.getConnectionRetries() != null ? config.getConnectionRetries() : 3;
        this.sastWaiter = new Waiter<ResponseQueueScanStatus>("CxSAST scan", interval, retry){

            @Override
            public ResponseQueueScanStatus getStatus(String id) throws IOException {
                ResponseQueueScanStatus statusResponse = null;
                try {
                    statusResponse = CxSASTClient.this.getSASTScanStatus(id);
                }
                catch (CxHTTPClientException e) {
                    try {
                        ResponseSastScanStatus statusResponseTemp = CxSASTClient.this.getSASTScanOutOfQueueStatus(id);
                        statusResponse = statusResponseTemp.convertResponseSastScanStatusToResponseQueueScanStatus(statusResponseTemp);
                    }
                    catch (MalformedURLException exception) {
                        throw new MalformedURLException("Failed with next error: " + exception);
                    }
                }
                return statusResponse;
            }

            @Override
            public void printProgress(ResponseQueueScanStatus scanStatus) {
                CxSASTClient.this.printSASTProgress(scanStatus, this.getStartTimeSec());
            }

            @Override
            public ResponseQueueScanStatus resolveStatus(ResponseQueueScanStatus scanStatus) {
                return CxSASTClient.this.resolveSASTStatus(scanStatus);
            }
        };
    }

    @Override
    public Results init() {
        SASTResults initSastResults = new SASTResults();
        try {
            this.initiate();
            this.language = this.httpClient.getLanguageFromAccessToken();
            initSastResults.setSastLanguage(this.language);
        }
        catch (CxClientException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            this.setState(State.FAILED);
            initSastResults.setException(e);
        }
        return initSastResults;
    }

    private void createSASTScan(long projectId) {
        block4: {
            boolean dupScanFound = false;
            try {
                this.log.info("-----------------------------------Create CxSAST Scan:------------------------------------");
                if (this.config.isAvoidDuplicateProjectScans() != null && this.config.isAvoidDuplicateProjectScans().booleanValue() && this.projectHasQueuedScans(projectId)) {
                    throw new CxClientException(MSG_AVOID_DUPLICATE_PROJECT_SCANS);
                }
                this.scanId = this.config.getRemoteType() == null ? this.createLocalSASTScan(projectId) : this.createRemoteSourceScan(projectId);
                if (this.config.getProjectLevelCustomFields() != null) {
                    this.updateProjectCustomFields();
                }
                this.sastResults.setSastLanguage(this.language);
                this.sastResults.setScanId(this.scanId);
                this.log.info("SAST scan created successfully: Scan ID is {}", (Object)this.scanId);
                this.sastResults.setSastScanLink(this.config.getUrl(), this.scanId, projectId);
            }
            catch (Exception e) {
                this.setState(State.FAILED);
                if (this.errorToBeSuppressed(e)) break block4;
                this.sastResults.setException(new CxClientException(e));
            }
        }
    }

    private long createLocalSASTScan(long projectId) throws IOException {
        if (this.isScanWithSettingsSupported()) {
            PathFilter filter = new PathFilter(this.config.getSastFolderExclusions(), this.config.getSastFilterPattern(), this.log);
            byte[] zipFile = CxZipUtils.getZippedSources(this.config, filter, this.config.getSourceDir(), this.log, "cxsast");
            ScanWithSettingsResponse response = this.scanWithSettings(zipFile, projectId, false);
            return response.getId();
        }
        this.configureScanSettings(projectId);
        PathFilter filter = new PathFilter(this.config.getSastFolderExclusions(), this.config.getSastFilterPattern(), this.log);
        byte[] zipFile = CxZipUtils.getZippedSources(this.config, filter, this.config.getSourceDir(), this.log, "cxsast");
        this.uploadZipFile(zipFile, projectId);
        return this.createScan(projectId);
    }

    private long createRemoteSourceScan(long projectId) throws IOException {
        StringEntity entity;
        this.excludeProjectSettings(projectId);
        RemoteSourceRequest req = new RemoteSourceRequest(this.config);
        RemoteSourceTypes type = req.getType();
        boolean isSSH = false;
        String apiVersion = this.getContentTypeAndApiVersion(this.config, "projects/%s/sourceCode/remoteSettings/%s/%s");
        switch (type) {
            case SVN: {
                MultipartEntityBuilder builder;
                if (req.getPrivateKey() != null && req.getPrivateKey().length > 1) {
                    isSSH = true;
                    builder = MultipartEntityBuilder.create();
                    builder.addBinaryBody("privateKey", req.getPrivateKey(), ContentType.APPLICATION_JSON, null).addTextBody("absoluteUrl", req.getUri().getAbsoluteUrl()).addTextBody("port", String.valueOf(req.getUri().getPort())).addTextBody("paths", this.config.getSourceDir());
                    entity = builder.build();
                    break;
                }
                entity = new StringEntity(HttpClientHelper.convertToJson(req), ContentType.APPLICATION_JSON);
                break;
            }
            case TFS: {
                entity = new StringEntity(HttpClientHelper.convertToJson(req), ContentType.APPLICATION_JSON);
                break;
            }
            case PERFORCE: {
                if (this.config.getPerforceMode() != null) {
                    req.setBrowseMode("Workspace");
                } else {
                    req.setBrowseMode("Depot");
                }
                entity = new StringEntity(HttpClientHelper.convertToJson(req), StandardCharsets.UTF_8);
                break;
            }
            case SHARED: {
                entity = new StringEntity(new Gson().toJson((Object)req), StandardCharsets.UTF_8);
                break;
            }
            case GIT: {
                if (req.getPrivateKey() == null || req.getPrivateKey().length < 1) {
                    HashMap<String, String> content = new HashMap<String, String>();
                    content.put("url", req.getUri().getAbsoluteUrl());
                    content.put("branch", this.config.getRemoteSrcBranch());
                    entity = new StringEntity(new JSONObject(content).toString(), StandardCharsets.UTF_8);
                    break;
                }
                isSSH = true;
                MultipartEntityBuilder builder = MultipartEntityBuilder.create();
                builder.addTextBody("url", req.getUri().getAbsoluteUrl(), ContentType.APPLICATION_JSON);
                builder.addTextBody("branch", this.config.getRemoteSrcBranch(), ContentType.APPLICATION_JSON);
                builder.addBinaryBody("privateKey", req.getPrivateKey(), ContentType.MULTIPART_FORM_DATA, null);
                entity = builder.build();
                break;
            }
            default: {
                this.log.error("todo");
                entity = new StringEntity("", StandardCharsets.UTF_8);
            }
        }
        if (this.isScanWithSettingsSupported()) {
            this.createRemoteSourceRequest(projectId, apiVersion, (HttpEntity)entity, type.value(), isSSH);
            ScanWithSettingsResponse response = this.scanWithSettings(null, projectId, true);
            return response.getId();
        }
        this.configureScanSettings(projectId);
        this.createRemoteSourceRequest(projectId, apiVersion, (HttpEntity)entity, type.value(), isSSH);
        return this.createScan(projectId);
    }

    public String getContentTypeAndApiVersion(CxScanConfig config, String apiName) {
        String[] versionComponents;
        CxVersion cxVersion = config.getCxVersion();
        String sastVersion = cxVersion.getVersion();
        String apiVersion = "application/json;v=1.0";
        if (sastVersion != null && !sastVersion.isEmpty() && (versionComponents = sastVersion.split("\\.")).length >= 2) {
            String currentVersion = versionComponents[0] + "." + versionComponents[1];
            float currentVersionFloat = Float.parseFloat(currentVersion);
            if (currentVersionFloat >= Float.parseFloat("9.7")) {
                if (apiName.equalsIgnoreCase("sast/scans/{scanId}/resultsStatistics")) {
                    apiVersion = "application/json;v=6.0";
                }
            } else if (currentVersionFloat >= Float.parseFloat("9.4")) {
                String customFields;
                apiVersion = "projects/{id}/dataRetentionSettings".equalsIgnoreCase(apiName) && config.isEnableDataRetention() ? "application/json;v=1.1" : (SCAN_WITH_SETTINGS_URL.equalsIgnoreCase(apiName) ? ((customFields = config.getCustomFields()) != null && !customFields.isEmpty() ? "application/json;v=1.2" : (config.getPostScanActionId() != null ? "application/json;v=1.2" : "application/json;v=1.0")) : "application/json;v=1.0");
            } else if ((double)currentVersionFloat >= 9.2 && (double)currentVersionFloat <= 9.3) {
                apiVersion = "application/json;v=1.0";
            }
        }
        return apiVersion;
    }

    private void configureScanSettings(long projectId) throws IOException {
        ScanSettingResponse scanSettingResponse = this.getScanSetting(projectId);
        ScanSettingRequest scanSettingRequest = new ScanSettingRequest();
        scanSettingRequest.setEngineConfigurationId(scanSettingResponse.getEngineConfiguration().getId());
        scanSettingRequest.setProjectId(projectId);
        scanSettingRequest.setPresetId(this.config.getPresetId().intValue());
        if (this.config.getEngineConfigurationId() != null) {
            scanSettingRequest.setEngineConfigurationId(this.config.getEngineConfigurationId().intValue());
        }
        this.defineScanSetting(scanSettingRequest);
    }

    private boolean errorToBeSuppressed(Exception error) {
        String additionalMessage = "Build status will be marked successfull as this error is benign. Results from last scan will be displayed, if available.";
        boolean suppressed = false;
        this.log.error(error.getMessage());
        if (error instanceof ConditionTimeoutException && this.config.getContinueBuild().booleanValue()) {
            suppressed = true;
        } else if (this.config.isIgnoreBenignErrors()) {
            if (error.getMessage().contains("source folder is empty,") || this.sastResults.getException() != null && this.sastResults.getException().getMessage().contains("No files to zip")) {
                suppressed = true;
            } else if (error.getMessage().contains("No files to zip")) {
                suppressed = true;
            } else if (error.getMessage().equalsIgnoreCase(MSG_AVOID_DUPLICATE_PROJECT_SCANS)) {
                suppressed = true;
            }
        }
        if (suppressed) {
            this.log.info("Build status will be marked successfull as this error is benign. Results from last scan will be displayed, if available.");
            try {
                this.sastResults = this.getLatestScanResults();
                if (super.isIsNewProject() && this.sastResults.getSastScanLink() == null) {
                    String message = String.format("The project %s is a new project. Hence there is no last scan report to be shown.", this.config.getProjectName());
                    this.log.info(message);
                }
            }
            catch (Exception okayToNotHaveResults) {
                this.sastResults = null;
            }
            if (this.sastResults == null) {
                this.sastResults = new SASTResults();
            }
            this.sastResults.setException(null);
            this.setState(State.SKIPPED);
        }
        return suppressed;
    }

    @Override
    public Results waitForScanResults() {
        block14: {
            try {
                block13: {
                    this.log.info("------------------------------------Get CxSAST Results:-----------------------------------");
                    this.log.info("Waiting for CxSAST scan to finish.");
                    try {
                        this.sastWaiter.waitForTaskToFinish(Long.toString(this.scanId), this.config.getSastScanTimeoutInMinutes() * 60, this.log);
                        this.log.info("Retrieving SAST scan results");
                        this.sastResults = this.retrieveSASTResults(this.scanId, this.projectId);
                    }
                    catch (ConditionTimeoutException e) {
                        if (!this.errorToBeSuppressed((Exception)((Object)e))) {
                            throw new Exception(e.getMessage());
                        }
                    }
                    catch (CxClientException | IOException e) {
                        if (this.errorToBeSuppressed(e)) break block13;
                        throw new Exception(e.getMessage());
                    }
                }
                if (this.config.getEnablePolicyViolations()) {
                    this.resolveSASTViolation(this.sastResults, this.projectId);
                }
                if (this.sastResults.getSastScanLink() != null) {
                    SASTUtils.printSASTResultsToConsole(this.config, this.sastResults, this.config.getEnablePolicyViolations(), this.log);
                }
                if (!this.config.getReports().isEmpty()) {
                    for (Map.Entry<ReportType, String> report : this.config.getReports().entrySet()) {
                        if (report == null) continue;
                        this.log.info("Generating " + report.getKey().value() + " report");
                        byte[] scanReport = this.getScanReport(this.sastResults.getScanId(), report.getKey(), "application/pdf;v=1.0");
                        SASTUtils.writeReport(scanReport, report.getValue(), this.log);
                        if (!report.getKey().value().equals("PDF")) continue;
                        this.sastResults.setPDFReport(scanReport);
                        this.sastResults.setPdfFileName(report.getValue());
                    }
                } else if (this.config.getGeneratePDFReport().booleanValue()) {
                    this.log.info("Generating PDF report");
                    byte[] pdfReport = this.getScanReport(this.sastResults.getScanId(), ReportType.PDF, "application/pdf;v=1.0");
                    this.sastResults.setPDFReport(pdfReport);
                    if (this.config.getReportsDir() == null) {
                        this.config.setReportsDir(new File(System.getProperty("user.dir")));
                    }
                    String now = new SimpleDateFormat("dd_MM_yyyy-HH_mm_ss").format(new Date());
                    String pdfFileName = "CxSASTReport_" + now + ".pdf";
                    String pdfLink = SASTUtils.writePDFReport(pdfReport, this.config.getReportsDir(), pdfFileName, this.log, "PDF");
                    this.sastResults.setSastPDFLink(pdfLink);
                    this.sastResults.setPdfFileName(pdfFileName);
                }
            }
            catch (Exception e) {
                if (this.errorToBeSuppressed(e)) break block14;
                this.sastResults.setException(new CxClientException(e));
            }
        }
        return this.sastResults;
    }

    private void resolveSASTViolation(SASTResults sastResults, long projectId) {
        try {
            this.cxARMWaiter.waitForTaskToFinish(Long.toString(projectId), this.cxARMTimeoutSec, this.log);
            CxARMUtils.getProjectViolatedPolicies(this.httpClient, this.config.getCxARMUrl(), projectId, CxProviders.SAST.value()).forEach(sastResults::addPolicy);
        }
        catch (Exception ex) {
            throw new CxClientException("CxARM is not available. Policy violations for SAST cannot be calculated: " + ex.getMessage());
        }
    }

    private SASTResults retrieveSASTResults(long scanId, long projectId) throws IOException {
        SASTStatisticsResponse statisticsResults = this.getScanStatistics(scanId);
        this.sastResults.setResults(scanId, statisticsResults, this.config.getUrl(), projectId);
        if (this.config.getGenerateXmlReport() == null || this.config.getGenerateXmlReport().booleanValue()) {
            byte[] cxReport = this.getScanReport(this.sastResults.getScanId(), ReportType.XML, "application/xml;v=1.0");
            CxXMLResults reportObj = SASTUtils.convertToXMLResult(cxReport);
            this.sastResults.setScanDetailedReport(reportObj, this.config);
            this.sastResults.setRawXMLReport(cxReport);
        }
        this.sastResults.setSastResultsReady(true);
        return this.sastResults;
    }

    @Override
    public SASTResults getLatestScanResults() {
        this.sastResults = new SASTResults();
        this.sastResults.setSastLanguage(this.language);
        try {
            this.log.info("---------------------------------Get Last CxSAST Results:--------------------------------");
            List<LastScanResponse> scanList = this.getLatestSASTStatus(this.projectId);
            for (LastScanResponse s : scanList) {
                if (!CurrentStatus.FINISHED.value().equals(s.getStatus().getName())) continue;
                return this.retrieveSASTResults(s.getId(), this.projectId);
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage());
            this.sastResults.setException(new CxClientException(e));
        }
        return this.sastResults;
    }

    public void cancelSASTScan() throws IOException {
        UpdateScanStatusRequest request = new UpdateScanStatusRequest(CurrentStatus.CANCELED);
        String json = HttpClientHelper.convertToJson(request);
        StringEntity entity = new StringEntity(json, StandardCharsets.UTF_8);
        this.httpClient.patchRequest("sast/scansQueue/{scanId}".replace(SCAN_ID_PATH_PARAM, Long.toString(this.scanId)), "application/json;v=1.0", (HttpEntity)entity, 200, "cancel SAST scan");
        this.log.info("SAST Scan canceled. (scanId: " + this.scanId + ")");
    }

    private boolean projectHasQueuedScans(long projectId) throws IOException {
        List<ResponseQueueScanStatus> queuedScans = this.getQueueScans(projectId);
        for (ResponseQueueScanStatus scan : queuedScans) {
            if (!this.isStatusToAvoid(scan.getStage().getValue()) || scan.getProject().getId() != projectId) continue;
            return true;
        }
        return false;
    }

    private boolean isStatusToAvoid(String status) {
        QueueStatus qStatus = QueueStatus.valueOf(status);
        switch (qStatus) {
            case New: 
            case PreScan: 
            case SourcePullingAndDeployment: 
            case Queued: 
            case Scanning: 
            case PostScan: {
                return true;
            }
        }
        return false;
    }

    public ScanSettingResponse getScanSetting(long projectId) throws IOException {
        return this.httpClient.getRequest("/sast/scanSettings/{projectId}".replace(PROJECT_ID_PATH_PARAM, Long.toString(projectId)), "application/json;v=1.0", ScanSettingResponse.class, 200, "Scan setting", false);
    }

    private void defineScanSetting(ScanSettingRequest scanSetting) throws IOException {
        StringEntity entity = new StringEntity(HttpClientHelper.convertToJson(scanSetting), StandardCharsets.UTF_8);
        this.httpClient.putRequest("sast/pluginsScanSettings", "application/json;v=1.0", (HttpEntity)entity, CxID.class, 200, "define scan setting");
    }

    private void excludeProjectSettings(long projectId) throws IOException {
        String excludeFoldersPattern = Arrays.stream(this.config.getSastFolderExclusions().split(",")).map(String::trim).collect(Collectors.joining(","));
        String excludeFilesPattern = Arrays.stream(this.config.getSastFilterPattern().split(",")).map(String::trim).map(file -> file.replace("!**/", "")).collect(Collectors.joining(","));
        ExcludeSettingsRequest excludeSettingsRequest = new ExcludeSettingsRequest(excludeFoldersPattern, excludeFilesPattern);
        StringEntity entity = new StringEntity(HttpClientHelper.convertToJson(excludeSettingsRequest), StandardCharsets.UTF_8);
        this.log.info("Exclude folders pattern: " + excludeFoldersPattern);
        this.log.info("Exclude files pattern: " + excludeFilesPattern);
        this.httpClient.putRequest(String.format("projects/%s/sourceCode/excludeSettings", projectId), "application/json;v=1.0", (HttpEntity)entity, null, 200, "exclude project's settings");
    }

    private void uploadZipFile(byte[] zipFile, long projectId) throws CxClientException, IOException {
        this.log.info("Uploading zip file");
        try (ByteArrayInputStream is = new ByteArrayInputStream(zipFile);){
            InputStreamBody streamBody = new InputStreamBody((InputStream)is, ContentType.APPLICATION_OCTET_STREAM, ZIPPED_SOURCE);
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
            builder.addPart(ZIPPED_SOURCE, (ContentBody)streamBody);
            String apiVersion = this.getContentTypeAndApiVersion(this.config, "projects/{projectId}/sourceCode/attachments");
            HttpEntity entity = builder.build();
            this.httpClient.postRequest("projects/{projectId}/sourceCode/attachments".replace(PROJECT_ID_PATH_PARAM, Long.toString(projectId)), null, apiVersion, (HttpEntity)new BufferedHttpEntity(entity), null, 204, "upload ZIP file");
        }
    }

    private long createScan(long projectId) throws IOException {
        CreateScanRequest scanRequest = new CreateScanRequest(projectId, this.config.getIncremental(), this.config.getPublic(), this.config.getForceScan(), this.config.getScanComment() == null ? "" : this.config.getScanComment());
        this.log.info("Sending SAST scan request");
        StringEntity entity = new StringEntity(HttpClientHelper.convertToJson(scanRequest), StandardCharsets.UTF_8);
        CxID createScanResponse = this.httpClient.postRequest("sast/scans", "application/json;v=1.0", (HttpEntity)entity, CxID.class, 201, "create new SAST Scan");
        this.log.info(String.format("SAST Scan created successfully. Link to project state: " + this.config.getUrl() + "/CxWebClient/portal#/projectState/" + projectId + "/Summary", new Object[0]));
        return createScanResponse.getId();
    }

    private CxID createRemoteSourceRequest(long projectId, String apiVersion, HttpEntity entity, String sourceType, boolean isSSH) throws IOException {
        return this.httpClient.postRequest(String.format("projects/%s/sourceCode/remoteSettings/%s/%s", projectId, sourceType, isSSH ? "ssh" : ""), isSSH ? null : "application/json;v=1.0", apiVersion, entity, CxID.class, 204, "create " + sourceType + " remote source scan setting");
    }

    private SASTStatisticsResponse getScanStatistics(long scanId) throws IOException {
        String apiVersion = this.getContentTypeAndApiVersion(this.config, "sast/scans/{scanId}/resultsStatistics");
        return this.httpClient.getRequest("sast/scans/{scanId}/resultsStatistics".replace(SCAN_ID_PATH_PARAM, Long.toString(scanId)), apiVersion, SASTStatisticsResponse.class, 200, "SAST scan statistics", false);
    }

    public List<LastScanResponse> getLatestSASTStatus(long projectId) throws IOException {
        return (List)((Object)this.httpClient.getRequest("sast/scans?projectId={projectId}".replace(PROJECT_ID_PATH_PARAM, Long.toString(projectId)), "application/json;v=1.0", LastScanResponse.class, 200, "last SAST scan ID", true));
    }

    private List<ResponseQueueScanStatus> getQueueScans(long projectId) throws IOException {
        return (List)((Object)this.httpClient.getRequest("sast/scansQueue?projectId={projectId}".replace(PROJECT_ID_PATH_PARAM, Long.toString(projectId)), "application/json;v=1.0", ResponseQueueScanStatus.class, 200, "scans in the queue. (projectId: )" + projectId, true));
    }

    private CreateReportResponse createScanReport(CreateReportRequest reportRequest) throws IOException {
        StringEntity entity = new StringEntity(HttpClientHelper.convertToJson(reportRequest), StandardCharsets.UTF_8);
        return this.httpClient.postRequest("reports/sastScan/", "application/json;v=1.0", (HttpEntity)entity, CreateReportResponse.class, 202, "to create " + reportRequest.getReportType() + " scan report");
    }

    private byte[] getScanReport(long scanId, ReportType reportType, String contentType) throws IOException {
        CreateReportRequest reportRequest = new CreateReportRequest(scanId, reportType.name());
        CreateReportResponse createReportResponse = this.createScanReport(reportRequest);
        int reportId = createReportResponse.getReportId();
        this.reportWaiter.waitForTaskToFinish(Long.toString(reportId), this.reportTimeoutSec, this.log);
        return this.getReport(reportId, contentType);
    }

    private byte[] getReport(long reportId, String contentType) throws IOException {
        return this.httpClient.getRequest("reports/sastScan/{reportId}".replace("{reportId}", Long.toString(reportId)), contentType, byte[].class, 200, " scan report: " + reportId, false);
    }

    public ResponseQueueScanStatus getSASTScanStatus(String scanId) throws IOException {
        ResponseQueueScanStatus scanStatus = this.httpClient.getRequest("sast/scansQueue/{scanId}".replace(SCAN_ID_PATH_PARAM, scanId), "application/json;v=1.0", ResponseQueueScanStatus.class, 200, SAST_SCAN, false);
        String currentStatus = scanStatus.getStage().getValue();
        if (CurrentStatus.FAILED.value().equals(currentStatus) || CurrentStatus.CANCELED.value().equals(currentStatus) || CurrentStatus.DELETED.value().equals(currentStatus) || CurrentStatus.UNKNOWN.value().equals(currentStatus)) {
            scanStatus.setBaseStatus(Status.FAILED);
        } else if (CurrentStatus.FINISHED.value().equals(currentStatus)) {
            scanStatus.setBaseStatus(Status.SUCCEEDED);
        } else {
            scanStatus.setBaseStatus(Status.IN_PROGRESS);
        }
        return scanStatus;
    }

    public ResponseSastScanStatus getSASTScanOutOfQueueStatus(String scanId) throws IOException {
        ResponseSastScanStatus scanStatus = this.httpClient.getRequest("sast/scans/{scanId}".replace(SCAN_ID_PATH_PARAM, scanId), "application/json;v=1.0", ResponseSastScanStatus.class, 200, SAST_SCAN, false);
        String currentStatus = scanStatus.getStatus().getName();
        if (CurrentStatus.FAILED.value().equals(currentStatus) || CurrentStatus.CANCELED.value().equals(currentStatus) || CurrentStatus.DELETED.value().equals(currentStatus) || CurrentStatus.UNKNOWN.value().equals(currentStatus)) {
            scanStatus.setBaseStatus(Status.FAILED);
        } else if (CurrentStatus.FINISHED.value().equals(currentStatus)) {
            scanStatus.setBaseStatus(Status.SUCCEEDED);
        } else {
            scanStatus.setBaseStatus(Status.IN_PROGRESS);
        }
        return scanStatus;
    }

    private void printSASTProgress(ResponseQueueScanStatus scanStatus, long startTime) {
        String timestamp = ShragaUtils.getTimestampSince(startTime);
        String prefix = scanStatus.getTotalPercent() < 10 ? " " : "";
        this.log.info("Waiting for SAST scan results. Elapsed time: " + timestamp + ". " + prefix + scanStatus.getTotalPercent() + "% processed. Status: " + scanStatus.getStage().getValue() + ".");
    }

    private ResponseQueueScanStatus resolveSASTStatus(ResponseQueueScanStatus scanStatus) {
        if (scanStatus != null) {
            if (Status.SUCCEEDED == scanStatus.getBaseStatus()) {
                this.log.info("SAST scan finished successfully.");
                return scanStatus;
            }
            throw new CxClientException("SAST scan cannot be completed. status [" + scanStatus.getStage().getValue() + "]: " + scanStatus.getStageDetails());
        }
        throw new CxClientException("SAST scan cannot be completed.");
    }

    @Override
    public Results initiateScan() {
        this.sastResults = new SASTResults();
        this.sastResults.setSastLanguage(this.language);
        this.createSASTScan(this.projectId);
        return this.sastResults;
    }

    private boolean isScanWithSettingsSupported() {
        try {
            HashMap swaggerResponse = this.httpClient.getRequest(SWAGGER_LOCATION, "application/json", HashMap.class, 200, SAST_SCAN, false);
            return swaggerResponse.toString().contains("/sast/scanWithSettings");
        }
        catch (Exception e) {
            return true;
        }
    }

    public void updateProjectCustomFields() {
        try {
            this.log.info("Updating Project Custom Fields.");
            if (this.config != null) {
                String projectId = String.valueOf(this.projectId);
                String apiVersion = this.getContentTypeAndApiVersion(this.config, "projects/");
                String apiVersionCustomField = this.getContentTypeAndApiVersion(this.config, "customFields");
                String projectCustomFieldsString = this.config.getProjectLevelCustomFields();
                if (projectCustomFieldsString != null && !projectCustomFieldsString.isEmpty()) {
                    List fetchSASTProjectCustomFields = (List)((Object)this.httpClient.getRequest("customFields", apiVersionCustomField, ProjectLevelCustomFields.class, 200, SAST_SCAN, true));
                    ArrayList<ProjectLevelCustomFields> custObj = new ArrayList<ProjectLevelCustomFields>();
                    Map<String, String> projectCustomFieldMap = this.customFieldMap(projectCustomFieldsString);
                    Project getProjectRequest = this.httpClient.getRequest("projects/" + projectId, "application/json;v=2.0", Project.class, 200, SAST_SCAN, false);
                    ProjectPutRequest projectPutRequest = new ProjectPutRequest();
                    projectPutRequest.setName(getProjectRequest.getName());
                    Integer team = Integer.parseInt(getProjectRequest.getTeamId());
                    ArrayList<ProjectLevelCustomFields> tempCustomFields = getProjectRequest.getCustomFields();
                    Boolean validCustomFields = false;
                    for (int i = 0; i < fetchSASTProjectCustomFields.size(); ++i) {
                        if (!projectCustomFieldMap.containsKey(((ProjectLevelCustomFields)fetchSASTProjectCustomFields.get(i)).getName())) continue;
                        validCustomFields = true;
                        ProjectLevelCustomFields customProjectField = new ProjectLevelCustomFields(((ProjectLevelCustomFields)fetchSASTProjectCustomFields.get(i)).getId(), projectCustomFieldMap.get(((ProjectLevelCustomFields)fetchSASTProjectCustomFields.get(i)).getName()), ((ProjectLevelCustomFields)fetchSASTProjectCustomFields.get(i)).getName());
                        custObj.add(customProjectField);
                    }
                    if (!validCustomFields.booleanValue()) {
                        this.log.error("Project level custom fields not configured in SAST");
                    }
                    ArrayList<ProjectLevelCustomFields> additionalCustomFields = new ArrayList<ProjectLevelCustomFields>();
                    for (ProjectLevelCustomFields existingCustomField : tempCustomFields) {
                        String existingCustomFieldName = existingCustomField.getName();
                        boolean isIdExists = projectCustomFieldMap.containsKey(existingCustomFieldName);
                        if (isIdExists) continue;
                        additionalCustomFields.add(existingCustomField);
                    }
                    custObj.addAll(additionalCustomFields);
                    projectPutRequest.setOwningTeam(team);
                    if (!custObj.isEmpty()) {
                        projectPutRequest.setCustomFields(custObj);
                        String json = HttpClientHelper.convertToJson(projectPutRequest);
                        StringEntity entity = new StringEntity(json);
                        try {
                            this.httpClient.putRequest("projects/" + projectId, apiVersion, (HttpEntity)entity, null, 204, "define project level custom field");
                            this.log.info("Project Level-Custom Fields updated successfully.");
                        }
                        catch (CxHTTPClientException e) {
                            this.log.error("Error updating Project Level-Custom Fields: {}", (Object)e.getMessage());
                        }
                    }
                }
            }
        }
        catch (Exception ex) {
            throw new CxClientException("Failed to Update Project Level-Custom Fields: " + ex.getMessage());
        }
    }

    private Map<String, String> customFieldMap(String projectCustomField) {
        HashMap<String, String> customFieldMap = new HashMap<String, String>();
        StringTokenizer tokenizer = new StringTokenizer(projectCustomField, ",");
        this.log.info("Project custom field: {}", (Object)projectCustomField);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            String[] keyValue = token.split(":");
            customFieldMap.put(keyValue[0], keyValue[1]);
        }
        return customFieldMap;
    }

    private ScanWithSettingsResponse scanWithSettings(byte[] zipFile, long projectId, boolean isRemote) throws IOException {
        this.log.info("Uploading zip file");
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        if (!isRemote) {
            try (ByteArrayInputStream is = new ByteArrayInputStream(zipFile);){
                InputStreamBody streamBody = new InputStreamBody((InputStream)is, ContentType.APPLICATION_OCTET_STREAM, ZIPPED_SOURCE);
                builder.addPart(ZIPPED_SOURCE, (ContentBody)streamBody);
            }
        }
        builder.addTextBody("projectId", Long.toString(projectId), ContentType.APPLICATION_JSON);
        if (this.config.getIsOverrideProjectSetting()) {
            builder.addTextBody("overrideProjectSetting", this.config.getIsOverrideProjectSetting() + "", ContentType.APPLICATION_JSON);
        } else {
            builder.addTextBody("overrideProjectSetting", super.isIsNewProject() ? "true" : "false", ContentType.APPLICATION_JSON);
        }
        builder.addTextBody("isIncremental", this.config.getIncremental().toString(), ContentType.APPLICATION_JSON);
        builder.addTextBody("isPublic", this.config.getPublic().toString(), ContentType.APPLICATION_JSON);
        builder.addTextBody("forceScan", this.config.getForceScan().toString(), ContentType.APPLICATION_JSON);
        builder.addTextBody("presetId", this.config.getPresetId().toString(), ContentType.APPLICATION_JSON);
        builder.addTextBody("comment", this.config.getScanComment() == null ? "" : this.config.getScanComment(), ContentType.APPLICATION_JSON);
        builder.addTextBody("engineConfigurationId", this.config.getEngineConfigurationId() != null ? this.config.getEngineConfigurationId().toString() : ENGINE_CONFIGURATION_ID_DEFAULT, ContentType.APPLICATION_JSON);
        builder.addTextBody("postScanActionId", this.config.getPostScanActionId() != null && this.config.getPostScanActionId() != 0 ? this.config.getPostScanActionId().toString() : "", ContentType.APPLICATION_JSON);
        builder.addTextBody("customFields", this.config.getCustomFields() != null ? this.config.getCustomFields() : "", ContentType.APPLICATION_JSON);
        String apiVersion = this.getContentTypeAndApiVersion(this.config, SCAN_WITH_SETTINGS_URL);
        HttpEntity entity = builder.build();
        return this.httpClient.postRequest(SCAN_WITH_SETTINGS_URL, null, apiVersion, (HttpEntity)new BufferedHttpEntity(entity), ScanWithSettingsResponse.class, 201, "upload ZIP file");
    }
}

