/*
 * Decompiled with CFR 0.152.
 */
package com.cx.restclient;

import com.cx.restclient.CxOSAClient;
import com.cx.restclient.CxSASTClient;
import com.cx.restclient.ast.AstSastClient;
import com.cx.restclient.ast.AstScaClient;
import com.cx.restclient.ast.dto.sca.AstScaResults;
import com.cx.restclient.common.Scanner;
import com.cx.restclient.common.summary.SummaryUtils;
import com.cx.restclient.configuration.CxScanConfig;
import com.cx.restclient.configuration.PropertyFileLoader;
import com.cx.restclient.cxArm.utils.CxARMUtils;
import com.cx.restclient.dto.Results;
import com.cx.restclient.dto.ScanResults;
import com.cx.restclient.dto.ScannerType;
import com.cx.restclient.osa.dto.OSAResults;
import com.cx.restclient.sast.dto.SASTResults;
import com.cx.restclient.sast.utils.State;
import java.net.MalformedURLException;
import java.util.EnumMap;
import java.util.Map;
import org.slf4j.Logger;

public class CxClientDelegator
implements Scanner {
    private static final PropertyFileLoader properties = PropertyFileLoader.getDefaultInstance();
    private static final String PRINT_LINE = "-----------------------------------------------------------------------------------------";
    private Logger log;
    private CxScanConfig config;
    Map<ScannerType, Scanner> scannersMap = new EnumMap<ScannerType, Scanner>(ScannerType.class);

    public CxClientDelegator(CxScanConfig config, Logger log) throws MalformedURLException {
        this.config = config;
        this.log = log;
        if (config.isAstSastEnabled()) {
            this.scannersMap.put(ScannerType.AST_SAST, new AstSastClient(config, log));
        }
        if (config.isSastEnabled()) {
            this.scannersMap.put(ScannerType.SAST, new CxSASTClient(config, log));
        }
        if (config.isOsaEnabled()) {
            this.scannersMap.put(ScannerType.OSA, new CxOSAClient(config, log));
        }
        if (config.isAstScaEnabled()) {
            this.scannersMap.put(ScannerType.AST_SCA, new AstScaClient(config, log));
        }
    }

    public CxClientDelegator(String serverUrl, String username, String password, String origin, boolean disableCertificateValidation, Logger log) throws MalformedURLException {
        this(new CxScanConfig(serverUrl, username, password, origin, disableCertificateValidation), log);
    }

    @Override
    public ScanResults init() {
        this.log.info("Initializing Cx client [{}]", (Object)properties.get("version"));
        ScanResults scanResultsCombined = new ScanResults();
        this.scannersMap.forEach((key, scanner) -> {
            Results scanResults = scanner.init();
            scanResultsCombined.put((ScannerType)((Object)key), scanResults);
        });
        return scanResultsCombined;
    }

    @Override
    public ScanResults initiateScan() {
        ScanResults scanResultsCombined = new ScanResults();
        this.scannersMap.forEach((key, scanner) -> {
            if (scanner.getState() == State.SUCCESS) {
                Results scanResults = scanner.initiateScan();
                scanResultsCombined.put((ScannerType)((Object)key), scanResults);
            }
        });
        return scanResultsCombined;
    }

    @Override
    public ScanResults waitForScanResults() {
        ScanResults scanResultsCombined = new ScanResults();
        this.scannersMap.forEach((key, scanner) -> {
            if (scanner.getState() == State.SUCCESS) {
                Results scanResults = scanner.waitForScanResults();
                scanResultsCombined.put((ScannerType)((Object)key), scanResults);
            }
        });
        return scanResultsCombined;
    }

    @Override
    public ScanResults getLatestScanResults() {
        ScanResults scanResultsCombined = new ScanResults();
        this.scannersMap.forEach((key, scanner) -> {
            if (scanner.getState() == State.SUCCESS) {
                Results scanResults = scanner.getLatestScanResults();
                scanResultsCombined.put((ScannerType)((Object)key), scanResults);
            }
        });
        return scanResultsCombined;
    }

    public void printIsProjectViolated(ScanResults scanResults) {
        if (this.config.getEnablePolicyViolations()) {
            this.log.info(PRINT_LINE);
            this.log.info("Policy Management: SAST and OSA ");
            this.log.info("--------------------");
            OSAResults osaResults = (OSAResults)scanResults.get(ScannerType.OSA);
            SASTResults sastResults = (SASTResults)scanResults.get(ScannerType.SAST);
            boolean hasOsaViolations = osaResults != null && osaResults.getOsaPolicies() != null && !osaResults.getOsaPolicies().isEmpty();
            boolean hasSastPolicies = false;
            if (sastResults != null && sastResults.getSastPolicies() != null && !sastResults.getSastPolicies().isEmpty()) {
                hasSastPolicies = true;
            }
            if (!hasSastPolicies && !hasOsaViolations) {
                this.log.info("Project policy status for SAST and OSA : compliant");
                this.log.info(PRINT_LINE);
            } else {
                this.log.info("Project policy status for SAST and OSA : violated");
                if (hasSastPolicies) {
                    this.log.info("SAST violated policies names: {}", (Object)CxARMUtils.getPoliciesNames(sastResults.getSastPolicies()));
                }
                if (hasOsaViolations) {
                    this.log.info("OSA violated policies names: {}", (Object)CxARMUtils.getPoliciesNames(osaResults.getOsaPolicies()));
                }
                this.log.info(PRINT_LINE);
            }
        }
        if (this.config.getEnablePolicyViolationsSCA()) {
            this.log.info(PRINT_LINE);
            this.log.info("Policy Management: SCA ");
            this.log.info("--------------------");
            AstScaResults scaResults = (AstScaResults)scanResults.get(ScannerType.AST_SCA);
            boolean hasScaViolations = false;
            if (scaResults != null && scaResults.getPolicyEvaluations() != null && !scaResults.getPolicyEvaluations().isEmpty()) {
                hasScaViolations = true;
            }
            if (!hasScaViolations) {
                this.log.info("Project policy status for SCA : compliant");
                this.log.info(PRINT_LINE);
            } else {
                this.log.info("Project policy status for SCA : violated");
                if (hasScaViolations) {
                    this.log.info("SCA policies are violated.");
                }
                this.log.info(PRINT_LINE);
            }
        }
    }

    public String generateHTMLSummary(ScanResults combinedResults) throws Exception {
        return SummaryUtils.generateSummary((SASTResults)combinedResults.get(ScannerType.SAST), (OSAResults)combinedResults.get(ScannerType.OSA), (AstScaResults)combinedResults.get(ScannerType.AST_SCA), this.config);
    }

    public String generateHTMLSummary(SASTResults sastResults, OSAResults osaResults, AstScaResults scaResults) throws Exception {
        return SummaryUtils.generateSummary(sastResults, osaResults, scaResults, this.config);
    }

    public CxSASTClient getSastClient() {
        return (CxSASTClient)this.scannersMap.get((Object)ScannerType.SAST);
    }

    public CxOSAClient getOsaClient() {
        return (CxOSAClient)this.scannersMap.get((Object)ScannerType.OSA);
    }

    public AstScaClient getScaClient() {
        return (AstScaClient)this.scannersMap.get((Object)ScannerType.AST_SCA);
    }

    @Override
    public void close() {
        this.scannersMap.values().forEach(Scanner::close);
    }
}

