/*
 * Decompiled with CFR 0.152.
 */
package com.checkmarx.jenkins.credentials;

import com.checkmarx.jenkins.credentials.CheckmarxApiToken;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.impl.BaseStandardCredentials;
import hudson.Extension;
import hudson.util.Secret;
import lombok.NonNull;
import org.kohsuke.stapler.DataBoundConstructor;

public class DefaultCheckmarxApiToken
extends BaseStandardCredentials
implements CheckmarxApiToken {
    @NonNull
    private final String clientId;
    @NonNull
    private final Secret secret;

    @DataBoundConstructor
    public DefaultCheckmarxApiToken(CredentialsScope scope, String id, String description, @NonNull String clientId, @NonNull String secret) {
        super(scope, id, description);
        if (clientId == null) {
            throw new NullPointerException("clientId is marked non-null but is null");
        }
        if (secret == null) {
            throw new NullPointerException("secret is marked non-null but is null");
        }
        this.clientId = clientId;
        this.secret = Secret.fromString((String)secret);
    }

    @Override
    @NonNull
    public String getClientId() {
        return this.clientId;
    }

    @Override
    @NonNull
    public Secret getToken() {
        return this.secret;
    }

    @Extension
    public static class DefaultCheckmarxApiTokenDescriptor
    extends BaseStandardCredentials.BaseStandardCredentialsDescriptor {
        @NonNull
        public String getDisplayName() {
            return "Checkmarx Client Id and Client Secret";
        }
    }
}

