/*
 * Decompiled with CFR 0.152.
 */
package com.checkmarx.ast.wrapper;

import com.checkmarx.ast.asca.ScanResult;
import com.checkmarx.ast.codebashing.CodeBashing;
import com.checkmarx.ast.containersrealtime.ContainersRealtimeResults;
import com.checkmarx.ast.iacrealtime.IacRealtimeResults;
import com.checkmarx.ast.kicsRealtimeResults.KicsRealtimeResults;
import com.checkmarx.ast.learnMore.LearnMore;
import com.checkmarx.ast.mask.MaskResult;
import com.checkmarx.ast.ossrealtime.OssRealtimeResults;
import com.checkmarx.ast.predicate.CustomState;
import com.checkmarx.ast.predicate.Predicate;
import com.checkmarx.ast.project.Project;
import com.checkmarx.ast.remediation.KicsRemediation;
import com.checkmarx.ast.results.ReportFormat;
import com.checkmarx.ast.results.Results;
import com.checkmarx.ast.results.ResultsSummary;
import com.checkmarx.ast.results.result.Node;
import com.checkmarx.ast.scan.Scan;
import com.checkmarx.ast.secretsrealtime.SecretsRealtimeResults;
import com.checkmarx.ast.tenant.TenantSetting;
import com.checkmarx.ast.utils.JsonParser;
import com.checkmarx.ast.wrapper.CxConfig;
import com.checkmarx.ast.wrapper.CxException;
import com.checkmarx.ast.wrapper.Execution;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CxWrapper {
    private static final CollectionType BRANCHES_TYPE = TypeFactory.defaultInstance().constructCollectionType(List.class, String.class);
    @NonNull
    private final CxConfig cxConfig;
    @NonNull
    private final Logger logger;
    @NonNull
    private final String executable;

    public CxWrapper(CxConfig cxConfig) throws IOException {
        this(cxConfig, LoggerFactory.getLogger(CxWrapper.class));
    }

    public CxWrapper(@NonNull CxConfig cxConfig, @NonNull Logger logger) throws IOException {
        if (cxConfig == null) {
            throw new NullPointerException("cxConfig is marked non-null but is null");
        }
        if (logger == null) {
            throw new NullPointerException("logger is marked non-null but is null");
        }
        this.cxConfig = cxConfig;
        this.logger = logger;
        this.executable = StringUtils.isBlank((CharSequence)this.cxConfig.getPathToExecutable()) ? Execution.getTempBinary(logger) : this.cxConfig.getPathToExecutable();
        this.logger.info("Executable path: {} ", (Object)this.executable);
    }

    public String authValidate() throws IOException, InterruptedException, CxException {
        this.logger.info("Executing 'auth validate' command using the CLI.");
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("auth");
        arguments.add("validate");
        return Execution.executeCommand(this.withConfigArguments(arguments), this.logger, line -> line);
    }

    public Scan scanShow(@NonNull UUID scanId) throws IOException, InterruptedException, CxException {
        if (scanId == null) {
            throw new NullPointerException("scanId is marked non-null but is null");
        }
        this.logger.info("Retrieving the details for scan id: {}", (Object)scanId);
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("scan");
        arguments.add("show");
        arguments.add("--scan-id");
        arguments.add(scanId.toString());
        arguments.addAll(this.jsonArguments());
        return Execution.executeCommand(this.withConfigArguments(arguments), this.logger, Scan::fromLine);
    }

    public List<Scan> scanList() throws IOException, InterruptedException, CxException {
        return this.scanList("");
    }

    public List<Scan> scanList(String filter) throws IOException, InterruptedException, CxException {
        this.logger.info("Fetching the scan list using the filter: {}", (Object)filter);
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("scan");
        arguments.add("list");
        arguments.addAll(this.jsonArguments());
        arguments.addAll(this.filterArguments(filter));
        return Execution.executeCommand(this.withConfigArguments(arguments), this.logger, Scan::listFromLine);
    }

    public Scan scanCreate(@NonNull Map<String, String> params) throws IOException, InterruptedException, CxException {
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        return this.scanCreate(params, "");
    }

    public Scan scanCreate(@NonNull Map<String, String> params, String additionalParameters) throws IOException, InterruptedException, CxException {
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        this.logger.info("Executing 'scan create' command using the CLI.");
        List<String> arguments = this.buildScanCreateArguments(params, additionalParameters);
        return Execution.executeCommand(arguments, this.logger, Scan::fromLine);
    }

    public List<String> buildScanCreateArguments(@NonNull Map<String, String> params, String additionalParameters) {
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        return this.withConfigArguments(this.buildScanCreateArgumentsArray(params, additionalParameters));
    }

    private List<String> buildScanCreateArgumentsArray(@NonNull Map<String, String> params, String additionalParameters) {
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("scan");
        arguments.add("create");
        arguments.add("--scan-info-format");
        arguments.add("json");
        for (Map.Entry<String, String> param : params.entrySet()) {
            arguments.add(param.getKey());
            arguments.add(param.getValue());
        }
        arguments.addAll(CxConfig.parseAdditionalParameters(additionalParameters));
        return arguments;
    }

    public void scanCancel(String scanId) throws IOException, InterruptedException, CxException {
        this.logger.info("Executing 'scan cancel' command using the CLI.");
        List<String> arguments = this.buildScanCancelArguments(UUID.fromString(scanId));
        Execution.executeCommand(arguments, this.logger, line -> null);
    }

    public List<String> buildScanCancelArguments(@NonNull UUID scanId) {
        if (scanId == null) {
            throw new NullPointerException("scanId is marked non-null but is null");
        }
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("scan");
        arguments.add("cancel");
        arguments.add("--scan-id");
        arguments.add(scanId.toString());
        return this.withConfigArguments(arguments);
    }

    public List<Predicate> triageShow(@NonNull UUID projectId, String similarityId, String scanType) throws IOException, InterruptedException, CxException {
        if (projectId == null) {
            throw new NullPointerException("projectId is marked non-null but is null");
        }
        this.logger.info("Executing 'triage show' command using the CLI.");
        this.logger.info("Fetching the list of predicates for projectId {} , similarityId {} and scan-type {}.", new Object[]{projectId, similarityId, scanType});
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("triage");
        arguments.add("show");
        arguments.add("--project-id");
        arguments.add(projectId.toString());
        arguments.add("--similarity-id");
        arguments.add(similarityId);
        arguments.add("--scan-type");
        arguments.add(scanType);
        arguments.addAll(this.jsonArguments());
        return Execution.executeCommand(this.withConfigArguments(arguments), this.logger, Predicate::listFromLine, Predicate::validator);
    }

    public List<CustomState> triageGetStates(boolean all) throws IOException, InterruptedException, CxException {
        this.logger.info("Executing 'triage get-states' command using the CLI.");
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("triage");
        arguments.add("get-states");
        if (all) {
            arguments.add("--all");
        }
        return Execution.executeCommand(this.withConfigArguments(arguments), this.logger, CustomState::listFromLine);
    }

    public void triageUpdate(@NonNull UUID projectId, String similarityId, String scanType, String state, String comment, String severity) throws IOException, InterruptedException, CxException {
        if (projectId == null) {
            throw new NullPointerException("projectId is marked non-null but is null");
        }
        this.triageUpdate(projectId, similarityId, scanType, state, comment, severity, null);
    }

    public void triageUpdate(@NonNull UUID projectId, String similarityId, String scanType, String state, String comment, String severity, String customStateId) throws IOException, InterruptedException, CxException {
        if (projectId == null) {
            throw new NullPointerException("projectId is marked non-null but is null");
        }
        this.logger.info("Executing 'triage update' command using the CLI.");
        this.logger.info("Updating the similarityId {} with state {} with customStateId {} and severity {}.", new Object[]{similarityId, state, customStateId, severity});
        boolean emptyCustomStateId = customStateId == null || customStateId.isEmpty();
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("triage");
        arguments.add("update");
        arguments.add("--project-id");
        arguments.add(projectId.toString());
        arguments.add("--similarity-id");
        arguments.add(similarityId);
        arguments.add("--scan-type");
        arguments.add(scanType);
        arguments.add("--state");
        arguments.add(state);
        if (!emptyCustomStateId) {
            arguments.add("--custom-state-id");
            arguments.add(customStateId);
        }
        if (!StringUtils.isBlank((CharSequence)comment)) {
            arguments.add("--comment");
            arguments.add(comment);
        }
        arguments.add("--severity");
        arguments.add(severity);
        Execution.executeCommand(this.withConfigArguments(arguments), this.logger, line -> null);
    }

    public Project projectShow(@NonNull UUID projectId) throws IOException, InterruptedException, CxException {
        if (projectId == null) {
            throw new NullPointerException("projectId is marked non-null but is null");
        }
        this.logger.info("Retrieving the details for project id: {}", (Object)projectId);
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("project");
        arguments.add("show");
        arguments.add("--project-id");
        arguments.add(projectId.toString());
        arguments.addAll(this.jsonArguments());
        return Execution.executeCommand(this.withConfigArguments(arguments), this.logger, Project::fromLine);
    }

    public List<Project> projectList() throws IOException, InterruptedException, CxException {
        return this.projectList("");
    }

    public List<Project> projectList(String filter) throws IOException, InterruptedException, CxException {
        this.logger.info("Fetching the project list using the filter: {}", (Object)filter);
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("project");
        arguments.add("list");
        arguments.addAll(this.filterArguments(filter));
        arguments.addAll(this.jsonArguments());
        return Execution.executeCommand(this.withConfigArguments(arguments), this.logger, Project::listFromLine);
    }

    public ScanResult ScanAsca(String fileSource, boolean ascaLatestVersion, String agent) throws IOException, InterruptedException, CxException {
        this.logger.info("Fetching ASCA scanResult");
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("scan");
        arguments.add("asca");
        arguments.add("--file-source");
        arguments.add(fileSource);
        if (ascaLatestVersion) {
            arguments.add("--asca-latest-version");
        }
        CxWrapper.appendAgentToArguments(agent, arguments);
        return Execution.executeCommand(this.withConfigArguments(arguments), this.logger, ScanResult::fromLine, (args, ignored) -> args.size() >= 3 && ((String)args.get(1)).equals("scan") && ((String)args.get(2)).equals("asca"));
    }

    private static void appendAgentToArguments(String agent, List<String> arguments) {
        arguments.add("--agent");
        if (agent != null && !agent.isEmpty()) {
            arguments.add(agent);
        } else {
            arguments.add("CLI-Java-Wrapper");
        }
    }

    public List<String> projectBranches(@NonNull UUID projectId, String filter) throws CxException, IOException, InterruptedException {
        if (projectId == null) {
            throw new NullPointerException("projectId is marked non-null but is null");
        }
        this.logger.info("Fetching the branches for project id {} using the filter: {}", (Object)projectId, (Object)filter);
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("project");
        arguments.add("branches");
        arguments.add("--project-id");
        arguments.add(projectId.toString());
        arguments.addAll(this.filterArguments(filter));
        return Execution.executeCommand(this.withConfigArguments(arguments), this.logger, line -> (List)JsonParser.parse(line, (JavaType)BRANCHES_TYPE));
    }

    public List<CodeBashing> codeBashingList(@NonNull String cweId, @NonNull String language, @NonNull String queryName) throws IOException, InterruptedException, CxException {
        if (cweId == null) {
            throw new NullPointerException("cweId is marked non-null but is null");
        }
        if (language == null) {
            throw new NullPointerException("language is marked non-null but is null");
        }
        if (queryName == null) {
            throw new NullPointerException("queryName is marked non-null but is null");
        }
        this.logger.info("Fetching the codebashing link");
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("results");
        arguments.add("codebashing");
        arguments.add("--language");
        arguments.add(language);
        arguments.add("--vulnerability-type");
        arguments.add(queryName);
        arguments.add("--cwe-id");
        arguments.add(cweId);
        arguments.addAll(this.jsonArguments());
        return Execution.executeCommand(this.withConfigArguments(arguments), this.logger, CodeBashing::listFromLine);
    }

    public ResultsSummary resultsSummary(@NonNull UUID scanId) throws IOException, InterruptedException, CxException {
        if (scanId == null) {
            throw new NullPointerException("scanId is marked non-null but is null");
        }
        return (ResultsSummary)new ObjectMapper().readerFor(ResultsSummary.class).readValue(this.results(scanId, ReportFormat.summaryJSON));
    }

    public Results results(@NonNull UUID scanId) throws IOException, InterruptedException, CxException {
        if (scanId == null) {
            throw new NullPointerException("scanId is marked non-null but is null");
        }
        return (Results)new ObjectMapper().readerFor(Results.class).readValue(this.results(scanId, ReportFormat.json));
    }

    public Results results(@NonNull UUID scanId, String agent) throws IOException, InterruptedException, CxException {
        if (scanId == null) {
            throw new NullPointerException("scanId is marked non-null but is null");
        }
        return (Results)new ObjectMapper().readerFor(Results.class).readValue(this.results(scanId, ReportFormat.json, agent));
    }

    public String results(@NonNull UUID scanId, ReportFormat reportFormat) throws IOException, InterruptedException, CxException {
        if (scanId == null) {
            throw new NullPointerException("scanId is marked non-null but is null");
        }
        return this.results(scanId, reportFormat, null);
    }

    public String results(@NonNull UUID scanId, ReportFormat reportFormat, String agent) throws IOException, InterruptedException, CxException {
        if (scanId == null) {
            throw new NullPointerException("scanId is marked non-null but is null");
        }
        this.logger.info("Retrieving the scan result for scan id {}", (Object)scanId);
        String tempDir = Files.createTempDirectory("cx", new FileAttribute[0]).toAbsolutePath().toString();
        String fileName = Long.toString(System.nanoTime());
        List<String> arguments = this.buildResultsArguments(scanId, reportFormat);
        arguments.add("--output-name");
        arguments.add(fileName);
        arguments.add("--output-path");
        arguments.add(tempDir);
        if (agent != null) {
            arguments.add("--agent");
            arguments.add(agent);
        }
        return Execution.executeCommand(arguments, this.logger, tempDir, fileName + reportFormat.getExtension());
    }

    public String scaRemediation(String packageFiles, String packages, String packageVersion) throws CxException, IOException, InterruptedException {
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("utils");
        arguments.add("remediation");
        arguments.add("sca");
        arguments.add("--package-files");
        arguments.add(packageFiles);
        arguments.add("--package");
        arguments.add(packages);
        arguments.add("--package-version");
        arguments.add(packageVersion);
        return Execution.executeCommand(this.withConfigArguments(arguments), this.logger, line -> null);
    }

    public int getResultsBfl(@NonNull UUID scanId, @NonNull String queryId, List<Node> resultNodes) throws IOException, InterruptedException, CxException {
        if (scanId == null) {
            throw new NullPointerException("scanId is marked non-null but is null");
        }
        if (queryId == null) {
            throw new NullPointerException("queryId is marked non-null but is null");
        }
        this.logger.info("Executing 'results bfl' command using the CLI.");
        this.logger.info("Fetching the best fix location for ScanId {} and QueryId {}", (Object)scanId, (Object)queryId);
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("results");
        arguments.add("bfl");
        arguments.add("--scan-id");
        arguments.add(scanId.toString());
        arguments.add("--query-id");
        arguments.add(queryId);
        arguments.addAll(this.jsonArguments());
        List bflNodes = Execution.executeCommand(this.withConfigArguments(arguments), this.logger, Node::listFromLine);
        return this.getIndexOfBfLNode(bflNodes, resultNodes);
    }

    public KicsRealtimeResults kicsRealtimeScan(@NonNull String fileSources, String engine, String additionalParams) throws IOException, InterruptedException, CxException {
        if (fileSources == null) {
            throw new NullPointerException("fileSources is marked non-null but is null");
        }
        this.logger.info("Executing 'scan kics-realtime' command using the CLI.");
        this.logger.info("Fetching the results for fileSources {} and additionalParams {}", (Object)fileSources, (Object)additionalParams);
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("scan");
        arguments.add("kics-realtime");
        arguments.add("--file");
        arguments.add(fileSources);
        arguments.add("--additional-params");
        arguments.add(additionalParams);
        if (!engine.isEmpty()) {
            arguments.add("--engine");
            arguments.add(engine);
        }
        return Execution.executeCommand(this.withConfigArguments(arguments), this.logger, KicsRealtimeResults::fromLine);
    }

    public <T> T realtimeScan(@NonNull String subCommand, @NonNull String sourcePath, String ignoredFilePath, Function<String, T> resultParser) throws IOException, InterruptedException, CxException {
        if (subCommand == null) {
            throw new NullPointerException("subCommand is marked non-null but is null");
        }
        if (sourcePath == null) {
            throw new NullPointerException("sourcePath is marked non-null but is null");
        }
        this.logger.info("Executing 'scan {}' command using the CLI.", (Object)subCommand);
        this.logger.info("Source: {} IgnoredFilePath: {}", (Object)sourcePath, (Object)ignoredFilePath);
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("scan");
        arguments.add(subCommand);
        arguments.add("-s");
        arguments.add(sourcePath);
        if (StringUtils.isNotBlank((CharSequence)ignoredFilePath)) {
            arguments.add("--ignored-file-path");
            arguments.add(ignoredFilePath);
        }
        return Execution.executeCommand(this.withConfigArguments(arguments), this.logger, resultParser);
    }

    public OssRealtimeResults ossRealtimeScan(@NonNull String sourcePath, String ignoredFilePath) throws IOException, InterruptedException, CxException {
        if (sourcePath == null) {
            throw new NullPointerException("sourcePath is marked non-null but is null");
        }
        return this.realtimeScan("oss-realtime", sourcePath, ignoredFilePath, OssRealtimeResults::fromLine);
    }

    public IacRealtimeResults iacRealtimeScan(@NonNull String sourcePath, String ignoredFilePath) throws IOException, InterruptedException, CxException {
        if (sourcePath == null) {
            throw new NullPointerException("sourcePath is marked non-null but is null");
        }
        return this.realtimeScan("iac-realtime", sourcePath, ignoredFilePath, IacRealtimeResults::fromLine);
    }

    public SecretsRealtimeResults secretsRealtimeScan(@NonNull String sourcePath, String ignoredFilePath) throws IOException, InterruptedException, CxException {
        if (sourcePath == null) {
            throw new NullPointerException("sourcePath is marked non-null but is null");
        }
        return this.realtimeScan("secrets-realtime", sourcePath, ignoredFilePath, SecretsRealtimeResults::fromLine);
    }

    public ContainersRealtimeResults containersRealtimeScan(@NonNull String sourcePath, String ignoredFilePath) throws IOException, InterruptedException, CxException {
        if (sourcePath == null) {
            throw new NullPointerException("sourcePath is marked non-null but is null");
        }
        return this.realtimeScan("containers-realtime", sourcePath, ignoredFilePath, ContainersRealtimeResults::fromLine);
    }

    public KicsRemediation kicsRemediate(@NonNull String resultsFile, String kicsFile, String engine, String similarityIds) throws IOException, InterruptedException, CxException {
        if (resultsFile == null) {
            throw new NullPointerException("resultsFile is marked non-null but is null");
        }
        this.logger.info("Executing 'remediation kics' command using the CLI.");
        this.logger.info("Applying remediation for resultsFile {} and resultsFile {}", (Object)resultsFile, (Object)kicsFile);
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add(this.executable);
        arguments.add("utils");
        arguments.add("remediation");
        arguments.add("kics");
        arguments.add("--results-file");
        arguments.add(resultsFile);
        arguments.add("--kics-files");
        arguments.add(kicsFile);
        if (!engine.isEmpty()) {
            arguments.add("--engine");
            arguments.add(engine);
        }
        if (!similarityIds.isEmpty()) {
            arguments.add("--similarity-ids");
            arguments.add(similarityIds);
        }
        return Execution.executeCommand(arguments, this.logger, KicsRemediation::fromLine);
    }

    public List<LearnMore> learnMore(String queryId) throws CxException, IOException, InterruptedException {
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("utils");
        arguments.add("learn-more");
        arguments.add("--query-id");
        arguments.add(queryId);
        arguments.add("--format");
        arguments.add("json");
        return Execution.executeCommand(this.withConfigArguments(arguments), this.logger, LearnMore::listFromLine);
    }

    public boolean ideScansEnabled() throws CxException, IOException, InterruptedException {
        List<TenantSetting> tenantSettings = this.tenantSettings();
        if (tenantSettings == null) {
            throw new CxException(1, "Unable to parse tenant settings");
        }
        return tenantSettings.stream().filter(t -> t.getKey().equals("scan.config.plugins.ideScans")).findFirst().map(t -> Boolean.parseBoolean(t.getValue())).orElse(false);
    }

    public boolean aiMcpServerEnabled() throws CxException, IOException, InterruptedException {
        List<TenantSetting> tenantSettings = this.tenantSettings();
        if (tenantSettings == null) {
            throw new CxException(1, "Unable to parse tenant settings");
        }
        return tenantSettings.stream().filter(t -> t.getKey().equals("scan.config.plugins.aiMcpServer")).findFirst().map(t -> Boolean.parseBoolean(t.getValue())).orElse(false);
    }

    public List<TenantSetting> tenantSettings() throws CxException, IOException, InterruptedException {
        List<String> arguments = this.jsonArguments();
        arguments.add("utils");
        arguments.add("tenant");
        return Execution.executeCommand(this.withConfigArguments(arguments), this.logger, TenantSetting::listFromLine);
    }

    public MaskResult maskSecrets(@NonNull String filePath) throws CxException, IOException, InterruptedException {
        if (filePath == null) {
            throw new NullPointerException("filePath is marked non-null but is null");
        }
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("utils");
        arguments.add("mask");
        arguments.add("--result-file");
        arguments.add(filePath);
        return Execution.executeCommand(this.withConfigArguments(arguments), this.logger, MaskResult::fromLine);
    }

    private int getIndexOfBfLNode(List<Node> bflNodes, List<Node> resultNodes) {
        int bflNodeNotFound = -1;
        for (Node bflNode : bflNodes) {
            for (Node resultNode : resultNodes) {
                if (!bflNode.equals(resultNode)) continue;
                return resultNodes.indexOf(resultNode);
            }
        }
        return bflNodeNotFound;
    }

    public List<String> buildResultsArguments(@NonNull UUID scanId, ReportFormat reportFormat) {
        if (scanId == null) {
            throw new NullPointerException("scanId is marked non-null but is null");
        }
        return this.withConfigArguments(this.buildResultsArgumentsArray(scanId, reportFormat));
    }

    private List<String> buildResultsArgumentsArray(UUID scanId, ReportFormat reportFormat) {
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("results");
        arguments.add("show");
        arguments.add("--scan-id");
        arguments.add(scanId.toString());
        arguments.add("--report-format");
        arguments.add(reportFormat.toString());
        return arguments;
    }

    private List<String> withConfigArguments(List<String> commands) {
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add(this.executable);
        arguments.addAll(commands);
        arguments.addAll(this.cxConfig.toArguments());
        return arguments;
    }

    private List<String> jsonArguments() {
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("--format");
        arguments.add("json");
        return arguments;
    }

    private List<String> filterArguments(String filter) {
        ArrayList<String> arguments = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            arguments.add("--filter");
            arguments.add(filter);
        }
        return arguments;
    }
}

