/*
 * Decompiled with CFR 0.152.
 */
package com.checkmarx.ast.wrapper;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class CxConfig {
    private static final Pattern pattern = Pattern.compile("([^\"]\\S*|\".+?\")\\s*");
    private String baseUri;
    private String baseAuthUri;
    private String tenant;
    private String clientId;
    private String clientSecret;
    private String apiKey;
    private String pathToExecutable;
    private List<String> additionalParameters;

    public void setAdditionalParameters(String additionalParameters) {
        this.additionalParameters = CxConfig.parseAdditionalParameters(additionalParameters);
    }

    List<String> toArguments() {
        ArrayList<String> commands = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)this.getClientId()) && StringUtils.isNotBlank((CharSequence)this.getApiKey())) {
            commands.add("--client-id");
            commands.add(this.getClientId());
            commands.add("--apikey");
            commands.add(this.getApiKey());
        } else if (StringUtils.isNotBlank((CharSequence)this.getApiKey())) {
            commands.add("--apikey");
            commands.add(this.getApiKey());
        } else if (StringUtils.isNotBlank((CharSequence)this.getClientId()) && StringUtils.isNotBlank((CharSequence)this.getClientSecret())) {
            commands.add("--client-id");
            commands.add(this.getClientId());
            commands.add("--client-secret");
            commands.add(this.getClientSecret());
        }
        if (StringUtils.isNotBlank((CharSequence)this.getTenant())) {
            commands.add("--tenant");
            commands.add(this.getTenant());
        }
        if (StringUtils.isNotBlank((CharSequence)this.getBaseUri())) {
            commands.add("--base-uri");
            commands.add(this.getBaseUri());
        }
        if (StringUtils.isNotBlank((CharSequence)this.getBaseAuthUri())) {
            commands.add("--base-auth-uri");
            commands.add(this.getBaseAuthUri());
        }
        if (this.getAdditionalParameters() != null) {
            commands.addAll(this.getAdditionalParameters());
        }
        return commands;
    }

    static List<String> parseAdditionalParameters(String additionalParameters) {
        ArrayList<String> additionalParametersList = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)additionalParameters)) {
            Matcher m = pattern.matcher(additionalParameters);
            while (m.find()) {
                additionalParametersList.add(m.group(1).replaceAll("\"", ""));
            }
        }
        return additionalParametersList;
    }

    CxConfig(String baseUri, String baseAuthUri, String tenant, String clientId, String clientSecret, String apiKey, String pathToExecutable, List<String> additionalParameters) {
        this.baseUri = baseUri;
        this.baseAuthUri = baseAuthUri;
        this.tenant = tenant;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.apiKey = apiKey;
        this.pathToExecutable = pathToExecutable;
        this.additionalParameters = additionalParameters;
    }

    public static CxConfigBuilder builder() {
        return new CxConfigBuilder();
    }

    public String getBaseUri() {
        return this.baseUri;
    }

    public String getBaseAuthUri() {
        return this.baseAuthUri;
    }

    public String getTenant() {
        return this.tenant;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public String getPathToExecutable() {
        return this.pathToExecutable;
    }

    public List<String> getAdditionalParameters() {
        return this.additionalParameters;
    }

    public void setBaseUri(String baseUri) {
        this.baseUri = baseUri;
    }

    public void setBaseAuthUri(String baseAuthUri) {
        this.baseAuthUri = baseAuthUri;
    }

    public void setTenant(String tenant) {
        this.tenant = tenant;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public void setPathToExecutable(String pathToExecutable) {
        this.pathToExecutable = pathToExecutable;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CxConfig)) {
            return false;
        }
        CxConfig other = (CxConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$baseUri = this.getBaseUri();
        String other$baseUri = other.getBaseUri();
        if (this$baseUri == null ? other$baseUri != null : !this$baseUri.equals(other$baseUri)) {
            return false;
        }
        String this$baseAuthUri = this.getBaseAuthUri();
        String other$baseAuthUri = other.getBaseAuthUri();
        if (this$baseAuthUri == null ? other$baseAuthUri != null : !this$baseAuthUri.equals(other$baseAuthUri)) {
            return false;
        }
        String this$tenant = this.getTenant();
        String other$tenant = other.getTenant();
        if (this$tenant == null ? other$tenant != null : !this$tenant.equals(other$tenant)) {
            return false;
        }
        String this$clientId = this.getClientId();
        String other$clientId = other.getClientId();
        if (this$clientId == null ? other$clientId != null : !this$clientId.equals(other$clientId)) {
            return false;
        }
        String this$clientSecret = this.getClientSecret();
        String other$clientSecret = other.getClientSecret();
        if (this$clientSecret == null ? other$clientSecret != null : !this$clientSecret.equals(other$clientSecret)) {
            return false;
        }
        String this$apiKey = this.getApiKey();
        String other$apiKey = other.getApiKey();
        if (this$apiKey == null ? other$apiKey != null : !this$apiKey.equals(other$apiKey)) {
            return false;
        }
        String this$pathToExecutable = this.getPathToExecutable();
        String other$pathToExecutable = other.getPathToExecutable();
        if (this$pathToExecutable == null ? other$pathToExecutable != null : !this$pathToExecutable.equals(other$pathToExecutable)) {
            return false;
        }
        List<String> this$additionalParameters = this.getAdditionalParameters();
        List<String> other$additionalParameters = other.getAdditionalParameters();
        return !(this$additionalParameters == null ? other$additionalParameters != null : !((Object)this$additionalParameters).equals(other$additionalParameters));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CxConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $baseUri = this.getBaseUri();
        result = result * 59 + ($baseUri == null ? 43 : $baseUri.hashCode());
        String $baseAuthUri = this.getBaseAuthUri();
        result = result * 59 + ($baseAuthUri == null ? 43 : $baseAuthUri.hashCode());
        String $tenant = this.getTenant();
        result = result * 59 + ($tenant == null ? 43 : $tenant.hashCode());
        String $clientId = this.getClientId();
        result = result * 59 + ($clientId == null ? 43 : $clientId.hashCode());
        String $clientSecret = this.getClientSecret();
        result = result * 59 + ($clientSecret == null ? 43 : $clientSecret.hashCode());
        String $apiKey = this.getApiKey();
        result = result * 59 + ($apiKey == null ? 43 : $apiKey.hashCode());
        String $pathToExecutable = this.getPathToExecutable();
        result = result * 59 + ($pathToExecutable == null ? 43 : $pathToExecutable.hashCode());
        List<String> $additionalParameters = this.getAdditionalParameters();
        result = result * 59 + ($additionalParameters == null ? 43 : ((Object)$additionalParameters).hashCode());
        return result;
    }

    public String toString() {
        return "CxConfig(baseUri=" + this.getBaseUri() + ", baseAuthUri=" + this.getBaseAuthUri() + ", tenant=" + this.getTenant() + ", clientId=" + this.getClientId() + ", clientSecret=" + this.getClientSecret() + ", apiKey=" + this.getApiKey() + ", pathToExecutable=" + this.getPathToExecutable() + ", additionalParameters=" + this.getAdditionalParameters() + ")";
    }

    public static class CxConfigBuilder {
        private String baseUri;
        private String baseAuthUri;
        private String tenant;
        private String clientId;
        private String clientSecret;
        private String apiKey;
        private String pathToExecutable;
        private List<String> additionalParameters;

        public CxConfigBuilder additionalParameters(String additionalParameters) {
            this.additionalParameters = CxConfig.parseAdditionalParameters(additionalParameters);
            return this;
        }

        CxConfigBuilder() {
        }

        public CxConfigBuilder baseUri(String baseUri) {
            this.baseUri = baseUri;
            return this;
        }

        public CxConfigBuilder baseAuthUri(String baseAuthUri) {
            this.baseAuthUri = baseAuthUri;
            return this;
        }

        public CxConfigBuilder tenant(String tenant) {
            this.tenant = tenant;
            return this;
        }

        public CxConfigBuilder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public CxConfigBuilder clientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        public CxConfigBuilder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public CxConfigBuilder pathToExecutable(String pathToExecutable) {
            this.pathToExecutable = pathToExecutable;
            return this;
        }

        public CxConfig build() {
            return new CxConfig(this.baseUri, this.baseAuthUri, this.tenant, this.clientId, this.clientSecret, this.apiKey, this.pathToExecutable, this.additionalParameters);
        }

        public String toString() {
            return "CxConfig.CxConfigBuilder(baseUri=" + this.baseUri + ", baseAuthUri=" + this.baseAuthUri + ", tenant=" + this.tenant + ", clientId=" + this.clientId + ", clientSecret=" + this.clientSecret + ", apiKey=" + this.apiKey + ", pathToExecutable=" + this.pathToExecutable + ", additionalParameters=" + this.additionalParameters + ")";
        }
    }
}

