/*
 * Decompiled with CFR 0.152.
 */
package com.checkmarx.ast.secretsrealtime;

import com.checkmarx.ast.realtime.RealtimeLocation;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public final class SecretsRealtimeResults {
    private static final Logger log = LoggerFactory.getLogger(SecretsRealtimeResults.class);
    @JsonProperty(value="Secrets")
    private final List<Secret> secrets;

    @JsonCreator
    public SecretsRealtimeResults(@JsonProperty(value="Secrets") List<Secret> secrets) {
        this.secrets = secrets == null ? Collections.emptyList() : secrets;
    }

    public static SecretsRealtimeResults fromLine(String line) {
        if (StringUtils.isBlank((CharSequence)line)) {
            return null;
        }
        try {
            if (!SecretsRealtimeResults.isValidJSON(line)) {
                return null;
            }
            ObjectMapper mapper = new ObjectMapper();
            String trimmed = line.trim();
            if (trimmed.startsWith("[")) {
                List list = (List)mapper.readValue(trimmed, (JavaType)mapper.getTypeFactory().constructCollectionType(List.class, Secret.class));
                return new SecretsRealtimeResults(list);
            }
            if (trimmed.startsWith("{")) {
                Secret single = (Secret)mapper.readValue(trimmed, Secret.class);
                return new SecretsRealtimeResults(Collections.singletonList(single));
            }
        }
        catch (IOException e) {
            log.debug("Failed to parse secrets realtime JSON line: {}", (Object)line, (Object)e);
        }
        return null;
    }

    private static boolean isValidJSON(String json) {
        try {
            new ObjectMapper().readTree(json);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public List<Secret> getSecrets() {
        return this.secrets;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SecretsRealtimeResults)) {
            return false;
        }
        SecretsRealtimeResults other = (SecretsRealtimeResults)o;
        List<Secret> this$secrets = this.getSecrets();
        List<Secret> other$secrets = other.getSecrets();
        return !(this$secrets == null ? other$secrets != null : !((Object)this$secrets).equals(other$secrets));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Secret> $secrets = this.getSecrets();
        result = result * 59 + ($secrets == null ? 43 : ((Object)$secrets).hashCode());
        return result;
    }

    public String toString() {
        return "SecretsRealtimeResults(secrets=" + this.getSecrets() + ")";
    }

    @JsonDeserialize
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Secret {
        @JsonProperty(value="Title")
        private final String title;
        @JsonProperty(value="Description")
        private final String description;
        @JsonProperty(value="SecretValue")
        private final String secretValue;
        @JsonProperty(value="FilePath")
        private final String filePath;
        @JsonProperty(value="Severity")
        private final String severity;
        @JsonProperty(value="Locations")
        private final List<RealtimeLocation> locations;

        @JsonCreator
        public Secret(@JsonProperty(value="Title") String title, @JsonProperty(value="Description") String description, @JsonProperty(value="SecretValue") String secretValue, @JsonProperty(value="FilePath") String filePath, @JsonProperty(value="Severity") String severity, @JsonProperty(value="Locations") List<RealtimeLocation> locations) {
            this.title = title;
            this.description = description;
            this.secretValue = secretValue;
            this.filePath = filePath;
            this.severity = severity;
            this.locations = locations == null ? Collections.emptyList() : locations;
        }

        public String getTitle() {
            return this.title;
        }

        public String getDescription() {
            return this.description;
        }

        public String getSecretValue() {
            return this.secretValue;
        }

        public String getFilePath() {
            return this.filePath;
        }

        public String getSeverity() {
            return this.severity;
        }

        public List<RealtimeLocation> getLocations() {
            return this.locations;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Secret)) {
                return false;
            }
            Secret other = (Secret)o;
            String this$title = this.getTitle();
            String other$title = other.getTitle();
            if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                return false;
            }
            String this$secretValue = this.getSecretValue();
            String other$secretValue = other.getSecretValue();
            if (this$secretValue == null ? other$secretValue != null : !this$secretValue.equals(other$secretValue)) {
                return false;
            }
            String this$filePath = this.getFilePath();
            String other$filePath = other.getFilePath();
            if (this$filePath == null ? other$filePath != null : !this$filePath.equals(other$filePath)) {
                return false;
            }
            String this$severity = this.getSeverity();
            String other$severity = other.getSeverity();
            if (this$severity == null ? other$severity != null : !this$severity.equals(other$severity)) {
                return false;
            }
            List<RealtimeLocation> this$locations = this.getLocations();
            List<RealtimeLocation> other$locations = other.getLocations();
            return !(this$locations == null ? other$locations != null : !((Object)this$locations).equals(other$locations));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $title = this.getTitle();
            result = result * 59 + ($title == null ? 43 : $title.hashCode());
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            String $secretValue = this.getSecretValue();
            result = result * 59 + ($secretValue == null ? 43 : $secretValue.hashCode());
            String $filePath = this.getFilePath();
            result = result * 59 + ($filePath == null ? 43 : $filePath.hashCode());
            String $severity = this.getSeverity();
            result = result * 59 + ($severity == null ? 43 : $severity.hashCode());
            List<RealtimeLocation> $locations = this.getLocations();
            result = result * 59 + ($locations == null ? 43 : ((Object)$locations).hashCode());
            return result;
        }

        public String toString() {
            return "SecretsRealtimeResults.Secret(title=" + this.getTitle() + ", description=" + this.getDescription() + ", secretValue=" + this.getSecretValue() + ", filePath=" + this.getFilePath() + ", severity=" + this.getSeverity() + ", locations=" + this.getLocations() + ")";
        }
    }
}

