/*
 * Decompiled with CFR 0.152.
 */
package com.checkmarx.ast.predicate;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

@JsonDeserialize
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public final class Predicate {
    private final String id;
    private final String similarityId;
    private final String projectId;
    private final String state;
    private final String severity;
    private final String comment;
    private final String createdBy;
    private final String createdAt;
    private final String updatedAt;
    private final Integer stateId;

    @JsonCreator
    public Predicate(@JsonProperty(value="ID") String id, @JsonProperty(value="SimilarityID") String similarityId, @JsonProperty(value="ProjectID") String projectId, @JsonProperty(value="State") String state, @JsonProperty(value="Severity") String severity, @JsonProperty(value="Comment") String comment, @JsonProperty(value="CreatedBy") String createdBy, @JsonProperty(value="CreatedAt") String createdAt, @JsonProperty(value="UpdatedAt") String updatedAt, @JsonProperty(value="StateId") Integer stateId) {
        this.id = id;
        this.similarityId = similarityId;
        this.projectId = projectId;
        this.state = state;
        this.severity = severity;
        this.comment = comment;
        this.createdBy = createdBy;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.stateId = stateId;
    }

    public static <T> T fromLine(String line) {
        return Predicate.parse(line, TypeFactory.defaultInstance().constructType(Predicate.class));
    }

    public static <T> List<T> listFromLine(String line) {
        return (List)Predicate.parse(line, (JavaType)TypeFactory.defaultInstance().constructCollectionType(List.class, Predicate.class));
    }

    protected static <T> T parse(String line, JavaType type) {
        Object result = null;
        try {
            if (!StringUtils.isBlank((CharSequence)line) && Predicate.isValidJSON(line)) {
                result = new ObjectMapper().readValue(line, type);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return (T)result;
    }

    public static boolean validator(List<String> arguments, Object parsedLine) {
        for (Field field : parsedLine.getClass().getFields()) {
            field.setAccessible(true);
            try {
                if (field.get(parsedLine) != null || field.getName().equals("stateId")) continue;
                return false;
            }
            catch (IllegalAccessException e) {
                return false;
            }
        }
        return true;
    }

    private static boolean isValidJSON(String json) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            mapper.readTree(json);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public String getId() {
        return this.id;
    }

    public String getSimilarityId() {
        return this.similarityId;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getState() {
        return this.state;
    }

    public String getSeverity() {
        return this.severity;
    }

    public String getComment() {
        return this.comment;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public String getCreatedAt() {
        return this.createdAt;
    }

    public String getUpdatedAt() {
        return this.updatedAt;
    }

    public Integer getStateId() {
        return this.stateId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Predicate)) {
            return false;
        }
        Predicate other = (Predicate)o;
        Integer this$stateId = this.getStateId();
        Integer other$stateId = other.getStateId();
        if (this$stateId == null ? other$stateId != null : !((Object)this$stateId).equals(other$stateId)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$similarityId = this.getSimilarityId();
        String other$similarityId = other.getSimilarityId();
        if (this$similarityId == null ? other$similarityId != null : !this$similarityId.equals(other$similarityId)) {
            return false;
        }
        String this$projectId = this.getProjectId();
        String other$projectId = other.getProjectId();
        if (this$projectId == null ? other$projectId != null : !this$projectId.equals(other$projectId)) {
            return false;
        }
        String this$state = this.getState();
        String other$state = other.getState();
        if (this$state == null ? other$state != null : !this$state.equals(other$state)) {
            return false;
        }
        String this$severity = this.getSeverity();
        String other$severity = other.getSeverity();
        if (this$severity == null ? other$severity != null : !this$severity.equals(other$severity)) {
            return false;
        }
        String this$comment = this.getComment();
        String other$comment = other.getComment();
        if (this$comment == null ? other$comment != null : !this$comment.equals(other$comment)) {
            return false;
        }
        String this$createdBy = this.getCreatedBy();
        String other$createdBy = other.getCreatedBy();
        if (this$createdBy == null ? other$createdBy != null : !this$createdBy.equals(other$createdBy)) {
            return false;
        }
        String this$createdAt = this.getCreatedAt();
        String other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !this$createdAt.equals(other$createdAt)) {
            return false;
        }
        String this$updatedAt = this.getUpdatedAt();
        String other$updatedAt = other.getUpdatedAt();
        return !(this$updatedAt == null ? other$updatedAt != null : !this$updatedAt.equals(other$updatedAt));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $stateId = this.getStateId();
        result = result * 59 + ($stateId == null ? 43 : ((Object)$stateId).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $similarityId = this.getSimilarityId();
        result = result * 59 + ($similarityId == null ? 43 : $similarityId.hashCode());
        String $projectId = this.getProjectId();
        result = result * 59 + ($projectId == null ? 43 : $projectId.hashCode());
        String $state = this.getState();
        result = result * 59 + ($state == null ? 43 : $state.hashCode());
        String $severity = this.getSeverity();
        result = result * 59 + ($severity == null ? 43 : $severity.hashCode());
        String $comment = this.getComment();
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        String $createdBy = this.getCreatedBy();
        result = result * 59 + ($createdBy == null ? 43 : $createdBy.hashCode());
        String $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : $createdAt.hashCode());
        String $updatedAt = this.getUpdatedAt();
        result = result * 59 + ($updatedAt == null ? 43 : $updatedAt.hashCode());
        return result;
    }

    public String toString() {
        return "Predicate(id=" + this.getId() + ", similarityId=" + this.getSimilarityId() + ", projectId=" + this.getProjectId() + ", state=" + this.getState() + ", severity=" + this.getSeverity() + ", comment=" + this.getComment() + ", createdBy=" + this.getCreatedBy() + ", createdAt=" + this.getCreatedAt() + ", updatedAt=" + this.getUpdatedAt() + ", stateId=" + this.getStateId() + ")";
    }
}

