/*
 * Decompiled with CFR 0.152.
 */
package com.checkmarx.ast.ossrealtime;

import com.checkmarx.ast.ossrealtime.OssRealtimeScanPackage;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public final class OssRealtimeResults {
    private static final Logger log = LoggerFactory.getLogger(OssRealtimeResults.class);
    @JsonProperty(value="Packages")
    private final List<OssRealtimeScanPackage> packages;

    @JsonCreator
    public OssRealtimeResults(@JsonProperty(value="Packages") List<OssRealtimeScanPackage> packages) {
        this.packages = packages == null ? Collections.emptyList() : packages;
    }

    public static OssRealtimeResults fromLine(String line) {
        if (StringUtils.isBlank((CharSequence)line)) {
            return null;
        }
        try {
            if (OssRealtimeResults.isValidJSON(line) && line.contains("\"Packages\"")) {
                return (OssRealtimeResults)new ObjectMapper().readValue(line, OssRealtimeResults.class);
            }
        }
        catch (IOException e) {
            log.debug("Failed to parse oss realtime line: {}", (Object)line, (Object)e);
        }
        return null;
    }

    private static boolean isValidJSON(String json) {
        try {
            new ObjectMapper().readTree(json);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public List<OssRealtimeScanPackage> getPackages() {
        return this.packages;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OssRealtimeResults)) {
            return false;
        }
        OssRealtimeResults other = (OssRealtimeResults)o;
        List<OssRealtimeScanPackage> this$packages = this.getPackages();
        List<OssRealtimeScanPackage> other$packages = other.getPackages();
        return !(this$packages == null ? other$packages != null : !((Object)this$packages).equals(other$packages));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<OssRealtimeScanPackage> $packages = this.getPackages();
        result = result * 59 + ($packages == null ? 43 : ((Object)$packages).hashCode());
        return result;
    }

    public String toString() {
        return "OssRealtimeResults(packages=" + this.getPackages() + ")";
    }
}

