/*
 * Decompiled with CFR 0.152.
 */
package com.checkmarx.ast.kicsRealtimeResults;

import com.checkmarx.ast.kicsRealtimeResults.ast.kicsRealtimeResult.KicsResult;
import com.checkmarx.ast.kicsRealtimeResults.ast.kicsRealtimeResult.KicsSummary;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

@JsonDeserialize
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public final class KicsRealtimeResults {
    private final int totalCount;
    private final String version;
    private final List<KicsResult> results;
    private final KicsSummary kicsSummary;

    @JsonCreator
    public KicsRealtimeResults(@JsonProperty(value="total_counter") int totalCount, @JsonProperty(value="queries") List<KicsResult> results, @JsonProperty(value="kics_version") String version, @JsonProperty(value="severity_counters") KicsSummary kicsSummary) {
        this.totalCount = totalCount;
        this.version = version;
        this.results = results;
        this.kicsSummary = kicsSummary;
    }

    public static <T> T fromLine(String line) {
        return KicsRealtimeResults.parse(line, TypeFactory.defaultInstance().constructType(KicsRealtimeResults.class));
    }

    private static <T> T parse(String line, JavaType type) {
        Object result = null;
        try {
            if (!StringUtils.isBlank((CharSequence)line) && KicsRealtimeResults.isValidJSON(line)) {
                result = new ObjectMapper().readValue(line, type);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return (T)result;
    }

    private static boolean isValidJSON(String json) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            mapper.readTree(json);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    public String getVersion() {
        return this.version;
    }

    public List<KicsResult> getResults() {
        return this.results;
    }

    public KicsSummary getKicsSummary() {
        return this.kicsSummary;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KicsRealtimeResults)) {
            return false;
        }
        KicsRealtimeResults other = (KicsRealtimeResults)o;
        if (this.getTotalCount() != other.getTotalCount()) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        List<KicsResult> this$results = this.getResults();
        List<KicsResult> other$results = other.getResults();
        if (this$results == null ? other$results != null : !((Object)this$results).equals(other$results)) {
            return false;
        }
        KicsSummary this$kicsSummary = this.getKicsSummary();
        KicsSummary other$kicsSummary = other.getKicsSummary();
        return !(this$kicsSummary == null ? other$kicsSummary != null : !((Object)this$kicsSummary).equals(other$kicsSummary));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getTotalCount();
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        List<KicsResult> $results = this.getResults();
        result = result * 59 + ($results == null ? 43 : ((Object)$results).hashCode());
        KicsSummary $kicsSummary = this.getKicsSummary();
        result = result * 59 + ($kicsSummary == null ? 43 : ((Object)$kicsSummary).hashCode());
        return result;
    }

    public String toString() {
        return "KicsRealtimeResults(totalCount=" + this.getTotalCount() + ", version=" + this.getVersion() + ", results=" + this.getResults() + ", kicsSummary=" + this.getKicsSummary() + ")";
    }
}

