/*
 * Decompiled with CFR 0.152.
 */
package com.checkmarx.ast.iacrealtime;

import com.checkmarx.ast.realtime.RealtimeLocation;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public final class IacRealtimeResults {
    private static final Logger log = LoggerFactory.getLogger(IacRealtimeResults.class);
    @JsonProperty(value="Results")
    private final List<Issue> results;

    @JsonCreator
    public IacRealtimeResults(@JsonProperty(value="Results") List<Issue> results) {
        this.results = results == null ? Collections.emptyList() : results;
    }

    public static IacRealtimeResults fromLine(String line) {
        if (StringUtils.isBlank((CharSequence)line)) {
            return null;
        }
        try {
            if (!IacRealtimeResults.isValidJSON(line)) {
                return null;
            }
            ObjectMapper mapper = new ObjectMapper();
            String trimmed = line.trim();
            if (trimmed.startsWith("[")) {
                List list = (List)mapper.readValue(trimmed, (JavaType)mapper.getTypeFactory().constructCollectionType(List.class, Issue.class));
                return new IacRealtimeResults(list == null ? Collections.emptyList() : list);
            }
            if (trimmed.startsWith("{")) {
                Issue single = (Issue)mapper.readValue(trimmed, Issue.class);
                return new IacRealtimeResults(Collections.singletonList(single));
            }
        }
        catch (IOException e) {
            log.debug("Failed to parse iac realtime JSON line: {}", (Object)line, (Object)e);
        }
        return null;
    }

    private static boolean isValidJSON(String json) {
        try {
            new ObjectMapper().readTree(json);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public List<Issue> getResults() {
        return this.results;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IacRealtimeResults)) {
            return false;
        }
        IacRealtimeResults other = (IacRealtimeResults)o;
        List<Issue> this$results = this.getResults();
        List<Issue> other$results = other.getResults();
        return !(this$results == null ? other$results != null : !((Object)this$results).equals(other$results));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Issue> $results = this.getResults();
        result = result * 59 + ($results == null ? 43 : ((Object)$results).hashCode());
        return result;
    }

    public String toString() {
        return "IacRealtimeResults(results=" + this.getResults() + ")";
    }

    @JsonDeserialize
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Issue {
        @JsonProperty(value="Title")
        private final String title;
        @JsonProperty(value="Description")
        private final String description;
        @JsonProperty(value="SimilarityID")
        private final String similarityId;
        @JsonProperty(value="FilePath")
        private final String filePath;
        @JsonProperty(value="Severity")
        private final String severity;
        @JsonProperty(value="ExpectedValue")
        private final String expectedValue;
        @JsonProperty(value="ActualValue")
        private final String actualValue;
        @JsonProperty(value="Locations")
        private final List<RealtimeLocation> locations;

        @JsonCreator
        public Issue(@JsonProperty(value="Title") String title, @JsonProperty(value="Description") String description, @JsonProperty(value="SimilarityID") String similarityId, @JsonProperty(value="FilePath") String filePath, @JsonProperty(value="Severity") String severity, @JsonProperty(value="ExpectedValue") String expectedValue, @JsonProperty(value="ActualValue") String actualValue, @JsonProperty(value="Locations") List<RealtimeLocation> locations) {
            this.title = title;
            this.description = description;
            this.similarityId = similarityId;
            this.filePath = filePath;
            this.severity = severity;
            this.expectedValue = expectedValue;
            this.actualValue = actualValue;
            this.locations = locations == null ? Collections.emptyList() : locations;
        }

        public String getTitle() {
            return this.title;
        }

        public String getDescription() {
            return this.description;
        }

        public String getSimilarityId() {
            return this.similarityId;
        }

        public String getFilePath() {
            return this.filePath;
        }

        public String getSeverity() {
            return this.severity;
        }

        public String getExpectedValue() {
            return this.expectedValue;
        }

        public String getActualValue() {
            return this.actualValue;
        }

        public List<RealtimeLocation> getLocations() {
            return this.locations;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Issue)) {
                return false;
            }
            Issue other = (Issue)o;
            String this$title = this.getTitle();
            String other$title = other.getTitle();
            if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                return false;
            }
            String this$similarityId = this.getSimilarityId();
            String other$similarityId = other.getSimilarityId();
            if (this$similarityId == null ? other$similarityId != null : !this$similarityId.equals(other$similarityId)) {
                return false;
            }
            String this$filePath = this.getFilePath();
            String other$filePath = other.getFilePath();
            if (this$filePath == null ? other$filePath != null : !this$filePath.equals(other$filePath)) {
                return false;
            }
            String this$severity = this.getSeverity();
            String other$severity = other.getSeverity();
            if (this$severity == null ? other$severity != null : !this$severity.equals(other$severity)) {
                return false;
            }
            String this$expectedValue = this.getExpectedValue();
            String other$expectedValue = other.getExpectedValue();
            if (this$expectedValue == null ? other$expectedValue != null : !this$expectedValue.equals(other$expectedValue)) {
                return false;
            }
            String this$actualValue = this.getActualValue();
            String other$actualValue = other.getActualValue();
            if (this$actualValue == null ? other$actualValue != null : !this$actualValue.equals(other$actualValue)) {
                return false;
            }
            List<RealtimeLocation> this$locations = this.getLocations();
            List<RealtimeLocation> other$locations = other.getLocations();
            return !(this$locations == null ? other$locations != null : !((Object)this$locations).equals(other$locations));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $title = this.getTitle();
            result = result * 59 + ($title == null ? 43 : $title.hashCode());
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            String $similarityId = this.getSimilarityId();
            result = result * 59 + ($similarityId == null ? 43 : $similarityId.hashCode());
            String $filePath = this.getFilePath();
            result = result * 59 + ($filePath == null ? 43 : $filePath.hashCode());
            String $severity = this.getSeverity();
            result = result * 59 + ($severity == null ? 43 : $severity.hashCode());
            String $expectedValue = this.getExpectedValue();
            result = result * 59 + ($expectedValue == null ? 43 : $expectedValue.hashCode());
            String $actualValue = this.getActualValue();
            result = result * 59 + ($actualValue == null ? 43 : $actualValue.hashCode());
            List<RealtimeLocation> $locations = this.getLocations();
            result = result * 59 + ($locations == null ? 43 : ((Object)$locations).hashCode());
            return result;
        }

        public String toString() {
            return "IacRealtimeResults.Issue(title=" + this.getTitle() + ", description=" + this.getDescription() + ", similarityId=" + this.getSimilarityId() + ", filePath=" + this.getFilePath() + ", severity=" + this.getSeverity() + ", expectedValue=" + this.getExpectedValue() + ", actualValue=" + this.getActualValue() + ", locations=" + this.getLocations() + ")";
        }
    }
}

