/*
 * Decompiled with CFR 0.152.
 */
package com.checkmarx.ast.containersrealtime;

import com.checkmarx.ast.containersrealtime.ContainersRealtimeImage;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public final class ContainersRealtimeResults {
    private static final Logger log = LoggerFactory.getLogger(ContainersRealtimeResults.class);
    @JsonProperty(value="Images")
    private final List<ContainersRealtimeImage> images;

    @JsonCreator
    public ContainersRealtimeResults(@JsonProperty(value="Images") List<ContainersRealtimeImage> images) {
        this.images = images;
    }

    public static ContainersRealtimeResults fromLine(String line) {
        if (StringUtils.isBlank((CharSequence)line)) {
            return null;
        }
        try {
            if (line.contains("\"Images\"") && ContainersRealtimeResults.isValidJSON(line)) {
                return (ContainersRealtimeResults)new ObjectMapper().readValue(line, ContainersRealtimeResults.class);
            }
        }
        catch (IOException e) {
            log.debug("Failed to parse containers realtime line: {}", (Object)line, (Object)e);
        }
        return null;
    }

    private static boolean isValidJSON(String json) {
        try {
            new ObjectMapper().readTree(json);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public List<ContainersRealtimeImage> getImages() {
        return this.images;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContainersRealtimeResults)) {
            return false;
        }
        ContainersRealtimeResults other = (ContainersRealtimeResults)o;
        List<ContainersRealtimeImage> this$images = this.getImages();
        List<ContainersRealtimeImage> other$images = other.getImages();
        return !(this$images == null ? other$images != null : !((Object)this$images).equals(other$images));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<ContainersRealtimeImage> $images = this.getImages();
        result = result * 59 + ($images == null ? 43 : ((Object)$images).hashCode());
        return result;
    }

    public String toString() {
        return "ContainersRealtimeResults(images=" + this.getImages() + ")";
    }
}

