/*
 * Decompiled with CFR 0.152.
 */
package pl.damianszczepanik.jenkins.buildhistorymanager.model.conditions;

import hudson.model.Run;
import java.util.Calendar;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import pl.damianszczepanik.jenkins.buildhistorymanager.model.RuleConfiguration;
import pl.damianszczepanik.jenkins.buildhistorymanager.model.conditions.Condition;

public class BuildAgeRangeCondition
extends Condition {
    private int minDaysAge;
    private int maxDaysAge;

    @DataBoundConstructor
    public BuildAgeRangeCondition() {
    }

    public int getMinDaysAge() {
        return this.minDaysAge;
    }

    @DataBoundSetter
    public void setMinDaysAge(int minDaysAge) {
        this.minDaysAge = minDaysAge;
    }

    public int getMaxDaysAge() {
        return this.maxDaysAge;
    }

    @DataBoundSetter
    public void setMaxDaysAge(int maxDaysAge) {
        this.maxDaysAge = maxDaysAge;
    }

    @Override
    public boolean matches(Run<?, ?> run, RuleConfiguration configuration) {
        Calendar buildTime = Calendar.getInstance();
        buildTime.setTimeInMillis(run.getStartTimeInMillis() + run.getDuration());
        this.clearTime(buildTime);
        Calendar maxDays = Calendar.getInstance();
        maxDays.add(5, -this.maxDaysAge);
        this.clearTime(maxDays);
        Calendar minDays = Calendar.getInstance();
        minDays.add(5, -this.minDaysAge);
        this.clearTime(minDays);
        return buildTime.compareTo(minDays) <= 0 && buildTime.compareTo(maxDays) >= 0;
    }

    protected void clearTime(Calendar calendar) {
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
    }
}

