/*
 * Decompiled with CFR 0.152.
 */
package org.mongojack.internal.util;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mongodb.Function;
import com.mongodb.client.MapReduceIterable;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoIterable;
import com.mongodb.client.model.Collation;
import com.mongodb.client.model.MapReduceAction;
import com.mongodb.lang.Nullable;
import java.util.Collection;
import java.util.Spliterator;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.bson.conversions.Bson;
import org.mongojack.InitializationRequiredForTransformation;
import org.mongojack.JacksonCodecRegistry;
import org.mongojack.SerializationOptions;
import org.mongojack.internal.util.DocumentSerializationUtils;

public class MapReduceIterableDecorator<TResult>
implements MapReduceIterable<TResult> {
    private final MapReduceIterable<TResult> delegate;
    private final ObjectMapper objectMapper;
    private final JavaType type;
    private final JacksonCodecRegistry codecRegistry;
    private final SerializationOptions serializationOptions;

    public MapReduceIterableDecorator(MapReduceIterable<TResult> delegate, ObjectMapper objectMapper, JavaType type, JacksonCodecRegistry codecRegistry, SerializationOptions serializationOptions) {
        this.delegate = delegate;
        this.objectMapper = objectMapper;
        this.type = type;
        this.codecRegistry = codecRegistry;
        this.serializationOptions = serializationOptions;
    }

    public void toCollection() {
        this.delegate.toCollection();
    }

    public MapReduceIterable<TResult> collectionName(String collectionName) {
        return this.delegate.collectionName(collectionName);
    }

    public MapReduceIterable<TResult> finalizeFunction(String finalizeFunction) {
        return this.delegate.finalizeFunction(finalizeFunction);
    }

    public MapReduceIterable<TResult> scope(Bson scope) {
        return this.delegate.scope(scope);
    }

    public MapReduceIterable<TResult> sort(Bson sort) {
        return this.delegate.sort(sort);
    }

    public MapReduceIterable<TResult> filter(Bson filter) {
        if (filter instanceof InitializationRequiredForTransformation) {
            ((InitializationRequiredForTransformation)filter).initialize(this.objectMapper, this.type, this.codecRegistry);
            return this.delegate.filter(filter);
        }
        if (this.serializationOptions.isSimpleFilterSerialization()) {
            return this.delegate.filter(filter);
        }
        return this.delegate.filter(DocumentSerializationUtils.serializeFilter(this.objectMapper, this.type, filter, this.codecRegistry));
    }

    public MapReduceIterable<TResult> limit(int limit) {
        return this.delegate.limit(limit);
    }

    public MapReduceIterable<TResult> jsMode(boolean jsMode) {
        return this.delegate.jsMode(jsMode);
    }

    public MapReduceIterable<TResult> verbose(boolean verbose) {
        return this.delegate.verbose(verbose);
    }

    public MapReduceIterable<TResult> maxTime(long maxTime, TimeUnit timeUnit) {
        return this.delegate.maxTime(maxTime, timeUnit);
    }

    public MapReduceIterable<TResult> action(MapReduceAction action) {
        return this.delegate.action(action);
    }

    public MapReduceIterable<TResult> databaseName(String databaseName) {
        return this.delegate.databaseName(databaseName);
    }

    public MapReduceIterable<TResult> sharded(boolean sharded) {
        return this.delegate.sharded(sharded);
    }

    public MapReduceIterable<TResult> nonAtomic(boolean nonAtomic) {
        return this.delegate.nonAtomic(nonAtomic);
    }

    public MapReduceIterable<TResult> batchSize(int batchSize) {
        return this.delegate.batchSize(batchSize);
    }

    public MapReduceIterable<TResult> bypassDocumentValidation(Boolean bypassDocumentValidation) {
        return this.delegate.bypassDocumentValidation(bypassDocumentValidation);
    }

    public MapReduceIterable<TResult> collation(Collation collation) {
        return this.delegate.collation(collation);
    }

    public MongoCursor<TResult> iterator() {
        return this.delegate.iterator();
    }

    public MongoCursor<TResult> cursor() {
        return this.delegate.cursor();
    }

    @Nullable
    public TResult first() {
        return (TResult)this.delegate.first();
    }

    public <U> MongoIterable<U> map(Function<TResult, U> mapper) {
        return this.delegate.map(mapper);
    }

    public <A extends Collection<? super TResult>> A into(A target) {
        return (A)this.delegate.into(target);
    }

    public void forEach(Consumer<? super TResult> action) {
        this.delegate.forEach(action);
    }

    public Spliterator<TResult> spliterator() {
        return this.delegate.spliterator();
    }
}

