/*
 * Decompiled with CFR 0.152.
 */
package org.mongojack.internal.util;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.DefaultSerializerProvider;
import com.fasterxml.jackson.databind.ser.SerializerFactory;
import com.fasterxml.jackson.databind.ser.std.BeanSerializerBase;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class JacksonAccessor {
    private static final Method objectMapperCreateDeserializationContext = JacksonAccessor.findMethod(ObjectMapper.class, "createDeserializationContext", new Class[]{JsonParser.class, DeserializationConfig.class});
    private static final Method objectMapperFindRootDeserializer = JacksonAccessor.findMethod(ObjectMapper.class, "_findRootDeserializer", new Class[]{DeserializationContext.class, JavaType.class});
    private static final Field beanSerializerBaseProps = JacksonAccessor.findField(BeanSerializerBase.class, "_props");
    private static final Field objectMapperSerializerFactory = JacksonAccessor.findField(ObjectMapper.class, "_serializerFactory");

    public static JsonDeserializer findDeserializer(ObjectMapper objectMapper, JavaType type) {
        return JacksonAccessor.invoke(objectMapper, objectMapperFindRootDeserializer, JsonDeserializer.class, JacksonAccessor.createDeserializationContext(objectMapper), type);
    }

    public static DeserializationContext createDeserializationContext(ObjectMapper objectMapper) {
        return JacksonAccessor.invoke(objectMapper, objectMapperCreateDeserializationContext, DeserializationContext.class, null, objectMapper.getDeserializationConfig());
    }

    public static BeanPropertyWriter findPropertyWriter(BeanSerializerBase serializer, String propertyName) {
        BeanPropertyWriter[] props;
        for (BeanPropertyWriter prop : props = JacksonAccessor.get(serializer, beanSerializerBaseProps, BeanPropertyWriter[].class)) {
            if (!propertyName.equals(prop.getName())) continue;
            return prop;
        }
        return null;
    }

    public static SerializerFactory getSerializerFactory(ObjectMapper objectMapper) {
        return JacksonAccessor.get(objectMapper, objectMapperSerializerFactory, SerializerFactory.class);
    }

    public static SerializerProvider getSerializerProvider(ObjectMapper objectMapper) {
        DefaultSerializerProvider serializerProvider = (DefaultSerializerProvider)objectMapper.getSerializerProvider();
        return serializerProvider.createInstance(objectMapper.getSerializationConfig(), JacksonAccessor.getSerializerFactory(objectMapper));
    }

    public static JsonSerializer findValueSerializer(SerializerProvider serializerProvider, JavaType javaType) {
        try {
            return serializerProvider.findValueSerializer(javaType, null);
        }
        catch (JsonMappingException e) {
            throw new RuntimeException(e);
        }
    }

    public static JsonSerializer findValueSerializer(SerializerProvider serializerProvider, Class clazz) {
        try {
            return serializerProvider.findValueSerializer(clazz, null);
        }
        catch (JsonMappingException e) {
            throw new RuntimeException(e);
        }
    }

    private static Method findMethod(Class clazz, String name, Class[] argTypes) {
        try {
            Method method = clazz.getDeclaredMethod(name, argTypes);
            method.setAccessible(true);
            return method;
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    private static Field findField(Class clazz, String name) {
        try {
            Field field = clazz.getDeclaredField(name);
            field.setAccessible(true);
            return field;
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    private static <T> T get(Object object, Field field, Class<T> type) {
        try {
            return (T)field.get(object);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private static <T> T invoke(Object object, Method method, Class<T> returnType, Object ... args) {
        try {
            return (T)method.invoke(object, args);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

