/*
 * Decompiled with CFR 0.152.
 */
package org.mongojack.internal.stream;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mongodb.MongoException;
import java.io.IOException;
import org.bson.BsonWriter;
import org.bson.UuidRepresentation;
import org.bson.codecs.Encoder;
import org.bson.codecs.EncoderContext;
import org.mongojack.MongoJsonMappingException;
import org.mongojack.internal.stream.DBEncoderBsonGenerator;

public class JacksonEncoder<T>
implements Encoder<T> {
    private final Class<T> clazz;
    private final Class<?> view;
    private final ObjectMapper objectMapper;
    private final UuidRepresentation uuidRepresentation;

    public JacksonEncoder(Class<T> clazz, Class<?> view, ObjectMapper objectMapper, UuidRepresentation uuidRepresentation) {
        this.clazz = clazz;
        this.view = view;
        this.objectMapper = objectMapper;
        this.uuidRepresentation = uuidRepresentation;
    }

    public JacksonEncoder<T> withUuidRepresentation(UuidRepresentation uuidRepresentation) {
        return new JacksonEncoder<T>(this.clazz, this.view, this.objectMapper, uuidRepresentation);
    }

    public void encode(BsonWriter writer, T value, EncoderContext encoderContext) {
        try (DBEncoderBsonGenerator generator = new DBEncoderBsonGenerator(writer, this.uuidRepresentation);){
            this.objectMapper.writerWithView(this.view).writeValue((JsonGenerator)generator, value);
        }
        catch (JsonMappingException e) {
            throw new MongoJsonMappingException(e);
        }
        catch (IOException e) {
            throw new MongoException("Error writing object out", (Throwable)e);
        }
    }

    public Class<T> getEncoderClass() {
        return this.clazz;
    }
}

