/*
 * Decompiled with CFR 0.152.
 */
package org.mongojack.internal.stream;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.core.util.BufferRecycler;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import org.bson.AbstractBsonReader;
import org.bson.BsonReader;
import org.bson.UuidRepresentation;
import org.bson.codecs.Decoder;
import org.bson.codecs.DecoderContext;
import org.mongojack.internal.stream.DBDecoderBsonParser;

public class JacksonDecoder<T>
implements Decoder<T> {
    private static final InputStream EMPTY_INPUT_STREAM = new EmptyInputStream();
    private final Class<T> clazz;
    private final ObjectMapper objectMapper;
    private final Class<?> view;
    private final UuidRepresentation uuidRepresentation;

    public JacksonDecoder(Class<T> clazz, Class<?> view, ObjectMapper objectMapper, UuidRepresentation uuidRepresentation) {
        this.clazz = clazz;
        this.objectMapper = objectMapper;
        this.view = view;
        this.uuidRepresentation = uuidRepresentation;
    }

    public JacksonDecoder<T> withUuidRepresentation(UuidRepresentation uuidRepresentation) {
        return new JacksonDecoder<T>(this.clazz, this.view, this.objectMapper, uuidRepresentation);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public T decode(BsonReader reader, DecoderContext decoderContext) {
        try (DBDecoderBsonParser parser = new DBDecoderBsonParser(new IOContext(new BufferRecycler(), (Object)EMPTY_INPUT_STREAM, false), 0, (AbstractBsonReader)reader, this.objectMapper, this.uuidRepresentation);){
            Object object = this.objectMapper.reader().forType(this.clazz).withView(this.view).readValue((JsonParser)parser);
            return (T)object;
        }
        catch (IOException e) {
            throw new RuntimeException("IOException encountered while parsing", e);
        }
    }

    private static class EmptyInputStream
    extends InputStream {
        private EmptyInputStream() {
        }

        @Override
        public int available() {
            return 0;
        }

        @Override
        public int read() {
            return -1;
        }
    }
}

