/*
 * Decompiled with CFR 0.152.
 */
package org.mongojack.internal.object.document;

import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.core.JsonToken;
import com.mongodb.DBRef;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import org.bson.BSONObject;
import org.bson.Document;
import org.bson.types.ObjectId;

abstract class DocumentObjectCursor
extends JsonStreamContext {
    private final DocumentObjectCursor parent;

    public DocumentObjectCursor(int contextType, DocumentObjectCursor p) {
        this._type = contextType;
        this._index = -1;
        this.parent = p;
    }

    public final DocumentObjectCursor getParent() {
        return this.parent;
    }

    public abstract String getCurrentName();

    public abstract JsonToken nextToken();

    public abstract JsonToken endToken();

    public abstract Object currentNode();

    public boolean currentHasChildren() {
        Object o = this.currentNode();
        if (o instanceof Collection) {
            return !((Collection)o).isEmpty();
        }
        if (o instanceof Map) {
            return !((Map)o).isEmpty();
        }
        return this.currentNode() != null;
    }

    public final DocumentObjectCursor iterateChildren() {
        Object n = this.currentNode();
        if (n == null) {
            throw new IllegalStateException("No current node");
        }
        if (n instanceof Iterable) {
            return new ArrayCursor((Iterable)n, this);
        }
        if (n instanceof Document) {
            return new ObjectCursor((Document)n, this);
        }
        throw new IllegalStateException("Current node of type " + n.getClass().getName());
    }

    private static JsonToken getToken(Object o) {
        if (o == null) {
            return JsonToken.VALUE_NULL;
        }
        if (o instanceof Iterable) {
            return JsonToken.START_ARRAY;
        }
        if (o instanceof BSONObject) {
            return JsonToken.START_OBJECT;
        }
        if (o instanceof Number) {
            if (o instanceof Double || o instanceof Float || o instanceof BigDecimal) {
                return JsonToken.VALUE_NUMBER_FLOAT;
            }
            return JsonToken.VALUE_NUMBER_INT;
        }
        if (o instanceof Boolean) {
            if (((Boolean)o).booleanValue()) {
                return JsonToken.VALUE_TRUE;
            }
            return JsonToken.VALUE_FALSE;
        }
        if (o instanceof CharSequence) {
            return JsonToken.VALUE_STRING;
        }
        if (o instanceof ObjectId) {
            return JsonToken.VALUE_EMBEDDED_OBJECT;
        }
        if (o instanceof DBRef) {
            return JsonToken.VALUE_EMBEDDED_OBJECT;
        }
        if (o instanceof Date) {
            return JsonToken.VALUE_EMBEDDED_OBJECT;
        }
        if (o instanceof UUID) {
            return JsonToken.VALUE_EMBEDDED_OBJECT;
        }
        if (o instanceof byte[]) {
            return JsonToken.VALUE_EMBEDDED_OBJECT;
        }
        throw new IllegalStateException("Don't know how to parse type: " + o.getClass());
    }

    protected static final class ObjectCursor
    extends DocumentObjectCursor {
        Iterator<String> fields;
        Document object;
        String currentFieldName;
        boolean needField;

        public ObjectCursor(Document object, DocumentObjectCursor p) {
            super(2, p);
            this.object = object;
            this.fields = object.keySet().iterator();
            this.needField = true;
        }

        @Override
        public String getCurrentName() {
            return this.currentFieldName;
        }

        @Override
        public JsonToken nextToken() {
            if (this.needField) {
                if (!this.fields.hasNext()) {
                    this.currentFieldName = null;
                    return null;
                }
                this.needField = false;
                this.currentFieldName = this.fields.next();
                return JsonToken.FIELD_NAME;
            }
            this.needField = true;
            return DocumentObjectCursor.getToken(this.object.get((Object)this.currentFieldName));
        }

        @Override
        public JsonToken endToken() {
            return JsonToken.END_OBJECT;
        }

        @Override
        public Object currentNode() {
            return this.currentFieldName == null ? null : this.object.get((Object)this.currentFieldName);
        }
    }

    protected static final class ArrayCursor
    extends DocumentObjectCursor {
        Iterator<?> contents;
        Object currentNode;

        public ArrayCursor(Iterable n, DocumentObjectCursor p) {
            super(1, p);
            this.contents = n.iterator();
        }

        @Override
        public String getCurrentName() {
            return null;
        }

        @Override
        public JsonToken nextToken() {
            if (!this.contents.hasNext()) {
                this.currentNode = null;
                return null;
            }
            this.currentNode = this.contents.next();
            return DocumentObjectCursor.getToken(this.currentNode);
        }

        @Override
        public JsonToken endToken() {
            return JsonToken.END_ARRAY;
        }

        @Override
        public Object currentNode() {
            return this.currentNode;
        }
    }
}

