/*
 * Decompiled with CFR 0.152.
 */
package org.mongojack.internal.object;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.base.ParserMinimalBase;
import com.mongodb.BasicDBObject;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.bson.BSONObject;
import org.bson.types.ObjectId;
import org.mongojack.internal.object.BsonObjectCursor;
import org.mongojack.internal.util.VersionUtils;

public class BsonObjectTraversingParser
extends ParserMinimalBase {
    protected ObjectCodec objectCodec;
    protected BsonObjectCursor nodeCursor;
    protected JsonToken nextToken;
    protected boolean startContainer;
    protected boolean closed;

    public BsonObjectTraversingParser(Object rootValue, ObjectCodec codec) {
        this((BSONObject)new BasicDBObject("root", rootValue), (ObjectCodec)null);
        try {
            this.nextToken();
            this.nextToken();
            this.nextToken();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private BsonObjectTraversingParser(BSONObject o, ObjectCodec codec) {
        super(0);
        this.objectCodec = codec;
        if (o instanceof Iterable) {
            this.nextToken = JsonToken.START_ARRAY;
            this.nodeCursor = new BsonObjectCursor.ArrayCursor((Iterable)o, null);
        } else {
            this.nextToken = JsonToken.START_OBJECT;
            this.nodeCursor = new BsonObjectCursor.ObjectCursor(o, null);
        }
    }

    public Version version() {
        return VersionUtils.VERSION;
    }

    public void setCodec(ObjectCodec c) {
        this.objectCodec = c;
    }

    public ObjectCodec getCodec() {
        return this.objectCodec;
    }

    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            this.nodeCursor = null;
            this._currToken = null;
        }
    }

    public JsonToken nextToken() throws IOException {
        if (this.nextToken != null) {
            this._currToken = this.nextToken;
            this.nextToken = null;
            return this._currToken;
        }
        if (this.startContainer) {
            this.startContainer = false;
            if (!this.nodeCursor.currentHasChildren()) {
                this._currToken = this._currToken == JsonToken.START_OBJECT ? JsonToken.END_OBJECT : JsonToken.END_ARRAY;
                return this._currToken;
            }
            this.nodeCursor = this.nodeCursor.iterateChildren();
            this._currToken = this.nodeCursor.nextToken();
            if (this._currToken == JsonToken.START_OBJECT || this._currToken == JsonToken.START_ARRAY) {
                this.startContainer = true;
            }
            return this._currToken;
        }
        if (this.nodeCursor == null) {
            this.closed = true;
            return null;
        }
        this._currToken = this.nodeCursor.nextToken();
        if (this._currToken != null) {
            if (this._currToken == JsonToken.START_OBJECT || this._currToken == JsonToken.START_ARRAY) {
                this.startContainer = true;
            }
            return this._currToken;
        }
        this._currToken = this.nodeCursor.endToken();
        this.nodeCursor = this.nodeCursor.getParent();
        return this._currToken;
    }

    public JsonParser skipChildren() throws IOException {
        if (this._currToken == JsonToken.START_OBJECT) {
            this.startContainer = false;
            this._currToken = JsonToken.END_OBJECT;
        } else if (this._currToken == JsonToken.START_ARRAY) {
            this.startContainer = false;
            this._currToken = JsonToken.END_ARRAY;
        }
        return this;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public String getCurrentName() {
        return this.nodeCursor == null ? null : this.nodeCursor.getCurrentName();
    }

    public JsonStreamContext getParsingContext() {
        return this.nodeCursor;
    }

    public JsonLocation getTokenLocation() {
        return JsonLocation.NA;
    }

    public JsonLocation getCurrentLocation() {
        return JsonLocation.NA;
    }

    public String getText() {
        if (this.closed) {
            return null;
        }
        switch (this._currToken) {
            case FIELD_NAME: {
                return this.nodeCursor.getCurrentName();
            }
            case VALUE_STRING: 
            case VALUE_NUMBER_INT: 
            case VALUE_NUMBER_FLOAT: 
            case VALUE_EMBEDDED_OBJECT: {
                return this.currentNode().toString();
            }
        }
        return this._currToken.asString();
    }

    public char[] getTextCharacters() throws IOException {
        return this.getText().toCharArray();
    }

    public int getTextLength() throws IOException {
        return this.getText().length();
    }

    public int getTextOffset() throws IOException {
        return 0;
    }

    public boolean hasTextCharacters() {
        return false;
    }

    public JsonParser.NumberType getNumberType() throws IOException {
        Object n = this.currentNode();
        if (n instanceof Integer) {
            return JsonParser.NumberType.INT;
        }
        if (n instanceof BigInteger) {
            return JsonParser.NumberType.BIG_INTEGER;
        }
        if (n instanceof BigDecimal) {
            return JsonParser.NumberType.BIG_DECIMAL;
        }
        if (n instanceof Double) {
            return JsonParser.NumberType.DOUBLE;
        }
        if (n instanceof Float) {
            return JsonParser.NumberType.FLOAT;
        }
        if (n instanceof Long) {
            return JsonParser.NumberType.LONG;
        }
        throw this._constructError(n + " is not a number");
    }

    public BigInteger getBigIntegerValue() throws IOException {
        Number n = this.currentNumericNode();
        if (n instanceof BigInteger) {
            return (BigInteger)n;
        }
        return BigInteger.valueOf(n.longValue());
    }

    public BigDecimal getDecimalValue() throws IOException {
        Number n = this.currentNumericNode();
        if (n instanceof BigDecimal) {
            return (BigDecimal)n;
        }
        return BigDecimal.valueOf(n.doubleValue());
    }

    public double getDoubleValue() throws IOException {
        return this.currentNumericNode().doubleValue();
    }

    public float getFloatValue() throws IOException {
        return this.currentNumericNode().floatValue();
    }

    public long getLongValue() throws IOException {
        return this.currentNumericNode().longValue();
    }

    public int getIntValue() throws IOException {
        return this.currentNumericNode().intValue();
    }

    public Number getNumberValue() throws IOException {
        return this.currentNumericNode();
    }

    private Number currentNumericNode() throws JsonParseException {
        Object n = this.currentNode();
        if (n instanceof Number) {
            return (Number)n;
        }
        throw this._constructError(n + " is not a number");
    }

    public byte[] getBinaryValue(Base64Variant b64variant) throws IOException {
        Object n = this.currentNode();
        if (n instanceof byte[]) {
            return (byte[])n;
        }
        if (n instanceof ObjectId) {
            return ((ObjectId)n).toByteArray();
        }
        return null;
    }

    public Object getEmbeddedObject() throws IOException {
        return this.currentNode();
    }

    protected void _handleEOF() throws JsonParseException {
    }

    public void overrideCurrentName(String name) {
    }

    protected Object currentNode() {
        if (this.closed || this.nodeCursor == null) {
            return null;
        }
        return this.nodeCursor.currentNode();
    }
}

