/*
 * Decompiled with CFR 0.152.
 */
package org.mongojack.internal;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.mongodb.DBRef;
import java.io.IOException;

public class MongoDBRefSerializer
extends JsonSerializer<DBRef> {
    public void serialize(DBRef value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        if (value == null) {
            gen.writeNull();
        } else {
            gen.writeStartObject();
            gen.writeFieldName("$ref");
            gen.writeString(value.getCollectionName());
            gen.writeFieldName("$id");
            gen.writeObject(value.getId());
            if (value.getDatabaseName() != null) {
                gen.writeFieldName("$db");
                gen.writeObject((Object)value.getDatabaseName());
            }
            gen.writeEndObject();
        }
    }

    public Class<DBRef> handledType() {
        return DBRef.class;
    }
}

