/*
 * Decompiled with CFR 0.152.
 */
package org.mongojack.internal;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;

public class CalendarDeserializer
extends StdDeserializer<Calendar> {
    public CalendarDeserializer() {
        super(Calendar.class);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Calendar deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        Date date;
        JsonToken token = jp.getCurrentToken();
        if (token == JsonToken.VALUE_EMBEDDED_OBJECT) {
            Object object = jp.getEmbeddedObject();
            if (!(object instanceof Date)) return (Calendar)ctxt.handleUnexpectedToken(Calendar.class, jp);
            date = (Date)object;
        } else {
            date = this._parseDate(jp, ctxt);
        }
        if (date != null) return ctxt.constructCalendar(date);
        return null;
    }
}

