/*
 * Decompiled with CFR 0.152.
 */
package org.mongojack;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mongodb.MongoBulkWriteException;
import com.mongodb.MongoException;
import com.mongodb.MongoWriteConcernException;
import com.mongodb.MongoWriteException;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.client.DistinctIterable;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MapReduceIterable;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.DeleteManyModel;
import com.mongodb.client.model.DeleteOneModel;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.ReplaceOneModel;
import com.mongodb.client.model.ReplaceOptions;
import com.mongodb.client.model.UpdateManyModel;
import com.mongodb.client.model.UpdateOneModel;
import com.mongodb.client.model.WriteModel;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.UuidRepresentation;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import org.mongojack.InitializationRequiredForTransformation;
import org.mongojack.JacksonCodecRegistry;
import org.mongojack.JacksonCollectionKey;
import org.mongojack.MongoCollection;
import org.mongojack.MongoCollectionDecorator;
import org.mongojack.SerializationOptions;
import org.mongojack.internal.MongoJackModule;
import org.mongojack.internal.stream.JacksonCodec;
import org.mongojack.internal.util.DistinctIterableDecorator;
import org.mongojack.internal.util.DocumentSerializationUtils;
import org.mongojack.internal.util.FindIterableDecorator;
import org.mongojack.internal.util.MapReduceIterableDecorator;

public class JacksonMongoCollection<TResult>
extends MongoCollectionDecorator<TResult> {
    private static final AtomicReference<ObjectMapper> DEFAULT_OBJECT_MAPPER = new AtomicReference();
    private final ObjectMapper objectMapper;
    private final JacksonCodecRegistry jacksonCodecRegistry;
    private final Class<?> view;
    private final Class<TResult> valueClass;
    private final JavaType type;
    private final com.mongodb.client.MongoCollection<TResult> mongoCollection;
    private final SerializationOptions serializationOptions;

    private JacksonMongoCollection(com.mongodb.client.MongoCollection<TResult> mongoCollection, ObjectMapper objectMapper, Class<TResult> valueClass, Class<?> view, SerializationOptions serializationOptions, UuidRepresentation uuidRepresentation) {
        this.objectMapper = objectMapper != null ? objectMapper : JacksonMongoCollection.getDefaultObjectMapper();
        this.view = view;
        this.serializationOptions = serializationOptions;
        com.mongodb.client.MongoCollection underlyingCollection = mongoCollection.withDocumentClass(valueClass);
        this.jacksonCodecRegistry = new JacksonCodecRegistry(this.objectMapper, underlyingCollection.getCodecRegistry(), this.view, uuidRepresentation);
        this.jacksonCodecRegistry.addCodecForClass(valueClass);
        this.mongoCollection = underlyingCollection.withCodecRegistry((CodecRegistry)this.jacksonCodecRegistry);
        this.valueClass = valueClass;
        this.type = this.objectMapper.constructType(valueClass);
    }

    private JacksonMongoCollection(ObjectMapper objectMapper, JacksonCodecRegistry jacksonCodecRegistry, Class<?> view, Class<TResult> valueClass, JavaType type, com.mongodb.client.MongoCollection<TResult> mongoCollection, SerializationOptions serializationOptions) {
        this.objectMapper = objectMapper;
        this.jacksonCodecRegistry = jacksonCodecRegistry;
        this.view = view;
        this.valueClass = valueClass;
        this.type = type;
        this.mongoCollection = mongoCollection;
        this.serializationOptions = serializationOptions;
    }

    private static ObjectMapper getDefaultObjectMapper() {
        return DEFAULT_OBJECT_MAPPER.updateAndGet(current -> {
            if (current == null) {
                return MongoJackModule.configure(new ObjectMapper());
            }
            return current;
        });
    }

    public static JacksonMongoCollectionBuilder builder() {
        return new JacksonMongoCollectionBuilder();
    }

    public TResult findOne() throws MongoException {
        return this.findOne((Bson)new Document());
    }

    public TResult findOne(Bson query) {
        return (TResult)this.find(query).first();
    }

    public TResult findOne(Bson query, Bson projection) {
        return (TResult)this.find(query).projection(projection).first();
    }

    public TResult findOneById(Object id) throws MongoException {
        return this.findOne(this.createIdQuery(id, new Object[0]));
    }

    public Bson createIdQuery(Object id, Object ... ids) {
        if (ids.length == 0) {
            if (id instanceof BsonValue) {
                return Filters.eq((String)"_id", (Object)id);
            }
            return Filters.eq((String)"_id", (Object)JacksonCodec.constructIdValue(id, JacksonCodec.getIdElement(this.valueClass)));
        }
        List<Object> allIds = Arrays.asList(ids);
        allIds.add(id);
        return this.createIdInQuery(allIds);
    }

    public Bson createIdInQuery(List<?> allIds) {
        Optional<AnnotatedElement> idElement = JacksonCodec.getIdElement(this.valueClass);
        return Filters.in((String)"_id", (Iterable)allIds.stream().map(currentId -> {
            if (currentId instanceof BsonValue) {
                return currentId;
            }
            return JacksonCodec.constructIdValue(currentId, idElement);
        }).collect(Collectors.toList()));
    }

    public JacksonCollectionKey<TResult> getCollectionKey() {
        return new JacksonCollectionKey<TResult>(this.getMongoCollection().getNamespace().getDatabaseName(), this.getMongoCollection().getNamespace().getCollectionName(), this.getValueClass());
    }

    public com.mongodb.client.MongoCollection<TResult> getMongoCollection() {
        return this.mongoCollection;
    }

    public String getDatabaseName() {
        return this.mongoCollection.getNamespace().getDatabaseName();
    }

    public String getName() {
        return this.mongoCollection.getNamespace().getCollectionName();
    }

    public Class<TResult> getValueClass() {
        return this.valueClass;
    }

    @SafeVarargs
    public final void insert(TResult ... objects) throws MongoException, MongoBulkWriteException {
        ArrayList objectList = new ArrayList(objects.length);
        Collections.addAll(objectList, objects);
        this.insert(objectList);
    }

    public void insert(List<TResult> list) throws MongoException, MongoBulkWriteException {
        this.mongoCollection.insertMany(list);
    }

    @SafeVarargs
    public final void insert(WriteConcern concern, TResult ... objects) throws MongoException, MongoBulkWriteException {
        ArrayList objectList = new ArrayList(objects.length);
        Collections.addAll(objectList, objects);
        this.insert(objectList, concern);
    }

    public void insert(List<TResult> list, WriteConcern concern) throws MongoException {
        this.mongoCollection.withWriteConcern(concern).insertMany(list);
    }

    public DeleteResult removeById(Object _id) throws MongoException, MongoWriteException, MongoWriteConcernException {
        return this.deleteOne(this.createIdQuery(_id, new Object[0]));
    }

    public UpdateResult replaceOneById(Object _id, TResult object) throws MongoException, MongoWriteException, MongoWriteConcernException {
        return this.replaceOne(this.createIdQuery(_id, new Object[0]), object);
    }

    public UpdateResult save(TResult object) throws MongoWriteException, MongoWriteConcernException, MongoException {
        return this.save(object, null);
    }

    public UpdateResult save(TResult object, WriteConcern concern) throws MongoWriteException, MongoWriteConcernException, MongoException {
        JacksonCodec<TResult> codec = this.getValueClassCodec();
        BsonValue _id = codec.getDocumentId(object);
        if (_id == null || _id.isNull()) {
            if (concern == null) {
                this.insertOne(object);
            } else {
                this.withWriteConcern(concern).insertOne(object);
            }
            return UpdateResult.acknowledged((long)0L, (Long)1L, (BsonValue)codec.getDocumentId(object));
        }
        BsonDocument query = new BsonDocument();
        query.put("_id", _id);
        if (concern != null) {
            return this.withWriteConcern(concern).replaceOne((Bson)query, object, new ReplaceOptions().upsert(true));
        }
        return this.replaceOne((Bson)query, object, new ReplaceOptions().upsert(true));
    }

    private JacksonCodec<TResult> getValueClassCodec() {
        return (JacksonCodec)this.jacksonCodecRegistry.get(this.valueClass);
    }

    public SerializationOptions getSerializationOptions() {
        return this.serializationOptions;
    }

    @Override
    protected com.mongodb.client.MongoCollection<TResult> mongoCollection() {
        return this.mongoCollection;
    }

    @Override
    protected Bson manageUpdateBson(Bson update) {
        this.initializeIfNecessary(update);
        if (update instanceof InitializationRequiredForTransformation) {
            return update;
        }
        return DocumentSerializationUtils.serializeFields(update, this.jacksonCodecRegistry);
    }

    @Override
    protected List<Bson> manageUpdatePipeline(List<? extends Bson> update) {
        return update.stream().map(u -> u.toBsonDocument(Document.class, (CodecRegistry)this.jacksonCodecRegistry)).collect(Collectors.toList());
    }

    @Override
    protected Bson manageFilterBson(Bson filter) {
        this.initializeIfNecessary(filter);
        if (filter instanceof InitializationRequiredForTransformation) {
            return filter;
        }
        if (this.getSerializationOptions().isSimpleFilterSerialization()) {
            return filter.toBsonDocument(this.getDocumentClass(), this.getCodecRegistry());
        }
        return DocumentSerializationUtils.serializeFilter(this.objectMapper, this.type, filter, this.jacksonCodecRegistry);
    }

    @Override
    protected List<Bson> manageAggregationPipeline(List<? extends Bson> pipeline) {
        this.initializeIfNecessary(pipeline);
        return pipeline;
    }

    @Override
    protected List<WriteModel<TResult>> manageBulkWriteRequests(List<? extends WriteModel<? extends TResult>> requests) {
        return requests.stream().map(request -> {
            if (request instanceof DeleteOneModel) {
                DeleteOneModel deleteRequest = (DeleteOneModel)request;
                return new DeleteOneModel(this.manageFilterBson(deleteRequest.getFilter()), deleteRequest.getOptions());
            }
            if (request instanceof DeleteManyModel) {
                DeleteManyModel deleteRequest = (DeleteManyModel)request;
                return new DeleteManyModel(this.manageFilterBson(deleteRequest.getFilter()), deleteRequest.getOptions());
            }
            if (request instanceof ReplaceOneModel) {
                ReplaceOneModel replaceRequest = (ReplaceOneModel)request;
                return new ReplaceOneModel(this.manageFilterBson(replaceRequest.getFilter()), replaceRequest.getReplacement(), replaceRequest.getReplaceOptions());
            }
            if (request instanceof UpdateOneModel) {
                UpdateOneModel updateRequest = (UpdateOneModel)request;
                if (updateRequest.getUpdatePipeline() != null) {
                    return new UpdateOneModel(this.manageFilterBson(updateRequest.getFilter()), this.manageUpdatePipeline(updateRequest.getUpdatePipeline()), updateRequest.getOptions());
                }
                return new UpdateOneModel(this.manageFilterBson(updateRequest.getFilter()), this.manageUpdateBson(updateRequest.getUpdate()), updateRequest.getOptions());
            }
            if (request instanceof UpdateManyModel) {
                UpdateManyModel updateRequest = (UpdateManyModel)request;
                if (updateRequest.getUpdatePipeline() != null) {
                    return new UpdateManyModel(this.manageFilterBson(updateRequest.getFilter()), this.manageUpdatePipeline(updateRequest.getUpdatePipeline()), updateRequest.getOptions());
                }
                return new UpdateManyModel(this.manageFilterBson(updateRequest.getFilter()), this.manageUpdateBson(updateRequest.getUpdate()), updateRequest.getOptions());
            }
            return request;
        }).collect(Collectors.toList());
    }

    @Override
    protected <T1> DistinctIterable<T1> wrapIterable(DistinctIterable<T1> input) {
        return new DistinctIterableDecorator<T1>(input, this.objectMapper, this.type, this.jacksonCodecRegistry, this.serializationOptions);
    }

    @Override
    protected <T1> FindIterable<T1> wrapIterable(FindIterable<T1> input) {
        return new FindIterableDecorator<T1>(input, this.objectMapper, this.type, this.jacksonCodecRegistry, this.serializationOptions);
    }

    @Override
    protected <T1> MapReduceIterable<T1> wrapIterable(MapReduceIterable<T1> input) {
        return new MapReduceIterableDecorator<T1>(input, this.objectMapper, this.type, this.jacksonCodecRegistry, this.serializationOptions);
    }

    public String toString() {
        return String.format("%s<%s, %s>", this.getClass().getName(), this.getMongoCollection().getNamespace().getFullName(), this.valueClass.getName());
    }

    public UpdateResult updateById(Object _id, Bson update) throws MongoException, MongoWriteException, MongoWriteConcernException {
        return this.updateOne(this.createIdQuery(_id, new Object[0]), update);
    }

    public <NewTDocument> JacksonMongoCollection<NewTDocument> withDocumentClass(Class<NewTDocument> clazz) {
        return new JacksonMongoCollection<NewTDocument>(this.objectMapper, this.jacksonCodecRegistry, this.view, clazz, this.objectMapper.constructType(clazz), this.mongoCollection.withDocumentClass(clazz), this.serializationOptions);
    }

    public com.mongodb.client.MongoCollection<TResult> withCodecRegistry(CodecRegistry codecRegistry) {
        return this.mongoCollection.withCodecRegistry(codecRegistry);
    }

    public JacksonMongoCollection<TResult> withReadPreference(ReadPreference readPreference) {
        return new JacksonMongoCollection<TResult>(this.objectMapper, this.jacksonCodecRegistry, this.view, this.valueClass, this.type, this.mongoCollection.withReadPreference(readPreference), this.serializationOptions);
    }

    public JacksonMongoCollection<TResult> withWriteConcern(WriteConcern writeConcern) {
        return new JacksonMongoCollection<TResult>(this.objectMapper, this.jacksonCodecRegistry, this.view, this.valueClass, this.type, this.mongoCollection.withWriteConcern(writeConcern), this.serializationOptions);
    }

    public JacksonMongoCollection<TResult> withReadConcern(ReadConcern readConcern) {
        return new JacksonMongoCollection<TResult>(this.objectMapper, this.jacksonCodecRegistry, this.view, this.valueClass, this.type, this.mongoCollection.withReadConcern(readConcern), this.serializationOptions);
    }

    private void initializeIfNecessary(Object maybeInitializable) {
        if (maybeInitializable instanceof InitializationRequiredForTransformation) {
            ((InitializationRequiredForTransformation)maybeInitializable).initialize(this.objectMapper, this.type, this.jacksonCodecRegistry);
        }
    }

    public static final class JacksonMongoCollectionBuilder {
        private ObjectMapper objectMapper;
        private Class<?> view;
        private SerializationOptions serializationOptions = SerializationOptions.builder().build();

        private JacksonMongoCollectionBuilder() {
        }

        public JacksonMongoCollectionBuilder withObjectMapper(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
            return this;
        }

        public JacksonMongoCollectionBuilder withView(Class<?> view) {
            this.view = view;
            return this;
        }

        public JacksonMongoCollectionBuilder withSerializationOptions(SerializationOptions serializationOptions) {
            this.serializationOptions = serializationOptions;
            return this;
        }

        public <CT> JacksonMongoCollection<CT> build(MongoClient client, String databaseName, String collectionName, Class<CT> valueType, UuidRepresentation uuidRepresentation) {
            return this.build(client.getDatabase(databaseName), collectionName, valueType, uuidRepresentation);
        }

        public <CT> JacksonMongoCollection<CT> build(MongoClient client, String databaseName, Class<CT> valueType, UuidRepresentation uuidRepresentation) {
            return this.build(client.getDatabase(databaseName), valueType, uuidRepresentation);
        }

        public <CT> JacksonMongoCollection<CT> build(MongoDatabase database, String collectionName, Class<CT> valueType, UuidRepresentation uuidRepresentation) {
            return this.build(database.getCollection(collectionName, valueType), valueType, uuidRepresentation);
        }

        public <CT> JacksonMongoCollection<CT> build(MongoDatabase database, Class<CT> valueType, UuidRepresentation uuidRepresentation) {
            MongoCollection annotation = valueType.getAnnotation(MongoCollection.class);
            if (annotation == null) {
                throw new IllegalArgumentException("You can only use the builder methods without explicit collection names if you have a class annotated with org.mongojack.MongoCollection");
            }
            return this.build(database.getCollection(annotation.name(), valueType), valueType, uuidRepresentation);
        }

        public <CT> JacksonMongoCollection<CT> build(com.mongodb.client.MongoCollection<CT> mongoCollection, Class<CT> valueType, UuidRepresentation uuidRepresentation) {
            return new JacksonMongoCollection(mongoCollection, this.objectMapper, valueType, this.view, this.serializationOptions, uuidRepresentation);
        }
    }
}

