/*
 * Decompiled with CFR 0.152.
 */
package org.mongojack;

import java.util.Objects;

public class JacksonCollectionKey<CT> {
    private final String collectionName;
    private final String databaseName;
    private final Class<CT> valueType;

    public JacksonCollectionKey(String databaseName, String collectionName, Class<CT> valueType) {
        assert (collectionName != null);
        assert (valueType != null);
        this.databaseName = databaseName;
        this.collectionName = collectionName;
        this.valueType = valueType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JacksonCollectionKey that = (JacksonCollectionKey)o;
        return Objects.equals(this.getCollectionName(), that.getCollectionName()) && Objects.equals(this.getDatabaseName(), that.getDatabaseName()) && Objects.equals(this.getValueType(), that.getValueType());
    }

    public int hashCode() {
        return Objects.hash(this.getCollectionName(), this.getDatabaseName(), this.getValueType());
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public Class<CT> getValueType() {
        return this.valueType;
    }
}

