/*
 * Decompiled with CFR 0.152.
 */
package org.mongojack;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.mongodb.client.MongoClient;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.bson.UuidRepresentation;
import org.bson.conversions.Bson;
import org.mongojack.DBRef;
import org.mongojack.JacksonCollectionKey;
import org.mongojack.JacksonMongoCollection;

public class DbReferenceManager {
    private final Map<JacksonCollectionKey<?>, JacksonMongoCollection<?>> referencedCollectionCache = new ConcurrentHashMap();
    private final MongoClient mongoClient;
    private final ObjectMapper objectMapper;
    private final String defaultDatabaseName;
    private final UuidRepresentation uuidRepresentation;

    public DbReferenceManager(MongoClient mongoClient, ObjectMapper objectMapper, String defaultDatabaseName, UuidRepresentation uuidRepresentation) {
        this.mongoClient = mongoClient;
        this.objectMapper = objectMapper;
        this.defaultDatabaseName = defaultDatabaseName;
        this.uuidRepresentation = uuidRepresentation;
    }

    public DbReferenceManager(MongoClient mongoClient, String defaultDatabaseName, UuidRepresentation uuidRepresentation) {
        this(mongoClient, null, defaultDatabaseName, uuidRepresentation);
    }

    public <CT> JacksonMongoCollection<CT> getReferenceCollection(String databaseName, String collectionName, Class<CT> valueClass) {
        return this.getReferenceCollection(new JacksonCollectionKey<CT>(databaseName, collectionName, valueClass));
    }

    public <CT> JacksonMongoCollection<CT> getReferenceCollection(JacksonCollectionKey<CT> collectionKey) {
        return this.referencedCollectionCache.computeIfAbsent(collectionKey, k -> {
            String databaseName = Optional.ofNullable(k.getDatabaseName()).orElse(this.defaultDatabaseName);
            return JacksonMongoCollection.builder().withObjectMapper(this.objectMapper).build(this.mongoClient.getDatabase(databaseName).getCollection(k.getCollectionName()).withDocumentClass(k.getValueType()), k.getValueType(), this.uuidRepresentation);
        });
    }

    public <R, RK> R fetch(DBRef<R, RK> ref) {
        return this.fetch(ref, null);
    }

    public <R, RK> R fetch(DBRef<R, RK> ref, Bson fields) {
        JacksonMongoCollection<R> collection = this.getReferenceCollection(ref.getCollectionKey());
        return (R)collection.find(collection.createIdQuery(ref.getId(), new Object[0])).projection(fields).first();
    }

    public <R, RK> List<R> fetch(Collection<DBRef<R, RK>> refs) {
        return this.fetch(refs, null);
    }

    public <R, RK> List<R> fetch(Collection<DBRef<R, RK>> refs, Bson fields) {
        Map groupedIdentifiers = refs.stream().collect(Collectors.groupingBy(DBRef::getCollectionKey, Collectors.mapping(DBRef::getId, Collectors.toList())));
        return groupedIdentifiers.entrySet().stream().map(entry -> {
            JacksonMongoCollection collection = this.getReferenceCollection((JacksonCollectionKey)entry.getKey());
            return (ArrayList)collection.find(collection.createIdInQuery((List)entry.getValue())).projection(fields).into(new ArrayList());
        }).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public void registerCollection(JacksonMongoCollection<?> collection) {
        this.referencedCollectionCache.put(collection.getCollectionKey(), collection);
    }
}

