/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.jenkins.plugins.bfa;

import com.sonyericsson.jenkins.plugins.bfa.PluginImpl;
import java.io.PrintStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.plugins.slack.SlackNotifier;
import jenkins.plugins.slack.StandardSlackService;

public class SlackMessageProvider {
    private static final Logger logger = Logger.getLogger(SlackMessageProvider.class.getName());
    private String slackMessageText;
    private String teamDomain;
    private String baseUrl;
    private String room;
    private String authToken;
    private boolean botUser;
    private String authTokenCredentialId;

    SlackMessageProvider() {
        SlackNotifier.DescriptorImpl slackDesc = this.getSlackDescriptor();
        this.teamDomain = slackDesc.getTeamDomain();
        this.baseUrl = slackDesc.getBaseUrl();
        this.authToken = slackDesc.getToken();
        this.botUser = slackDesc.getBotUser();
        this.authTokenCredentialId = slackDesc.getTokenCredentialId();
        this.room = slackDesc.getRoom();
    }

    SlackMessageProvider(String teamDomain, String baseUrl, String authToken, boolean botUser, String authTokenCredentialId, String room) {
        this.teamDomain = teamDomain;
        this.baseUrl = baseUrl;
        this.authToken = authToken;
        this.botUser = botUser;
        this.authTokenCredentialId = authTokenCredentialId;
        this.room = room;
    }

    private SlackNotifier.DescriptorImpl getSlackDescriptor() {
        return (SlackNotifier.DescriptorImpl)Jenkins.getInstance().getDescriptor(SlackNotifier.class);
    }

    public boolean getBotUser() {
        return this.botUser;
    }

    public String getTeamDomain() {
        return this.teamDomain;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public String getRoom() {
        return this.room;
    }

    public String getSlackMessageText() {
        return this.slackMessageText;
    }

    private boolean checkSlackConfigurationParams() {
        return this.room != null && !this.room.equals("") && (this.teamDomain != null && !this.teamDomain.equals("") || this.baseUrl != null && !this.baseUrl.equals("")) && (this.authToken != null && !this.authToken.equals("") || this.authTokenCredentialId != null && !this.authTokenCredentialId.equals(""));
    }

    private void reportGenericErrorMessage(PrintStream buildLog, String message) {
        StringBuilder s = new StringBuilder("Global Slack Notifier tried posting build failure to slack. However some error occurred\n");
        s.append("TeamDomain :" + this.teamDomain + "\n");
        s.append("BaseUrl :" + this.baseUrl + "\n");
        s.append("Channel :" + this.room + "\n");
        s.append("BotUser:" + this.botUser);
        if (message != null) {
            s.append("\n" + message);
        }
        if (buildLog != null) {
            buildLog.println("[BFA] Failed to send build failure information to slack.");
            if (message != null) {
                buildLog.println(message);
            }
        }
        logger.log(Level.SEVERE, s.toString());
    }

    public boolean postToSlack(String messageText, PrintStream buildLog) {
        this.slackMessageText = messageText;
        String messageColor = "danger";
        String customSlackChannel = PluginImpl.getInstance().getSlackChannelName();
        String useRoom = customSlackChannel.equals("") ? this.room : customSlackChannel;
        if (this.checkSlackConfigurationParams()) {
            StandardSlackService service = new StandardSlackService(this.baseUrl, this.teamDomain, this.authToken, this.authTokenCredentialId, this.botUser, useRoom);
            boolean postResult = service.publish(messageText, messageColor);
            if (!postResult) {
                this.reportGenericErrorMessage(buildLog, null);
            } else if (buildLog != null) {
                buildLog.println("[BFA] Sent build failure information to slack.");
            }
            return true;
        }
        this.reportGenericErrorMessage(buildLog, "Slack Notifier plugin missing configurations.");
        return false;
    }
}

