/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.jenkins.plugins.bfa;

import com.codahale.metrics.MetricRegistry;
import com.sonyericsson.jenkins.plugins.bfa.model.FailureCause;
import com.sonyericsson.jenkins.plugins.bfa.model.IFailureCauseMetricData;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import jenkins.metrics.api.Metrics;

public final class MetricsManager {
    static final String CAUSEPREFIX = "jenkins_bfa.cause.";
    static final String CATEGORYPREFIX = "jenkins_bfa.category.";
    public static final FailureCause UNKNOWNCAUSE = new FailureCause("no matching cause", "");

    private MetricsManager() {
    }

    private static Set<String> getMetricNames(IFailureCauseMetricData cause) {
        HashSet<String> metrics = new HashSet<String>();
        metrics.add(CAUSEPREFIX + cause.getName());
        List<String> categoriesForCause = cause.getCategories();
        if (categoriesForCause != null) {
            for (String string : categoriesForCause) {
                metrics.add(CATEGORYPREFIX + string);
            }
        }
        return metrics;
    }

    public static void addMetric(IFailureCauseMetricData cause) {
        MetricRegistry metricRegistry = Metrics.metricRegistry();
        SortedSet existingMetrics = metricRegistry.getNames();
        Set<String> metrics = MetricsManager.getMetricNames(cause);
        for (String metric : metrics) {
            if (existingMetrics.contains(metric)) continue;
            metricRegistry.counter(metric);
        }
    }

    public static void incCounters(List<? extends IFailureCauseMetricData> causes, boolean squashCauses) {
        MetricRegistry metricRegistry = Metrics.metricRegistry();
        if (squashCauses) {
            HashSet<String> metrics = new HashSet<String>();
            for (IFailureCauseMetricData iFailureCauseMetricData : causes) {
                metrics.addAll(MetricsManager.getMetricNames(iFailureCauseMetricData));
            }
            for (String string : metrics) {
                metricRegistry.counter(string).inc();
            }
        } else {
            for (IFailureCauseMetricData iFailureCauseMetricData : causes) {
                Set<String> set = MetricsManager.getMetricNames(iFailureCauseMetricData);
                for (String metric : set) {
                    metricRegistry.counter(metric).inc();
                }
            }
        }
    }
}

