/*
 * Decompiled with CFR 0.152.
 */
package org.mongojack.internal.stream;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.bson.BsonDecimal128;
import org.bson.BsonDouble;
import org.bson.BsonInt32;
import org.bson.BsonInt64;
import org.bson.BsonNull;
import org.bson.BsonObjectId;
import org.bson.BsonReader;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.BsonWriter;
import org.bson.UuidRepresentation;
import org.bson.codecs.Codec;
import org.bson.codecs.CollectibleCodec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.OverridableUuidRepresentationCodec;
import org.bson.types.Decimal128;
import org.mongojack.Id;
import org.mongojack.ObjectId;
import org.mongojack.internal.stream.JacksonDecoder;
import org.mongojack.internal.stream.JacksonEncoder;

public class JacksonCodec<T>
implements Codec<T>,
CollectibleCodec<T>,
OverridableUuidRepresentationCodec<T> {
    private final JacksonEncoder<T> encoder;
    private final JacksonDecoder<T> decoder;

    public JacksonCodec(JacksonEncoder<T> encoder, JacksonDecoder<T> decoder) {
        this.encoder = encoder;
        this.decoder = decoder;
    }

    public void encode(BsonWriter writer, T value, EncoderContext encoderContext) {
        this.encoder.encode(writer, value, encoderContext);
    }

    public Class<T> getEncoderClass() {
        return this.encoder.getEncoderClass();
    }

    public T decode(BsonReader reader, DecoderContext decoderContext) {
        return this.decoder.decode(reader, decoderContext);
    }

    public T generateIdIfAbsentFromDocument(T t) {
        if (!this.documentHasId(t)) {
            this.getIdWriter(t).accept(new BsonObjectId());
        }
        return t;
    }

    public boolean documentHasId(T t) {
        BsonValue readValue = this.getDocumentId(t);
        return readValue != null && !readValue.isNull();
    }

    public BsonValue getDocumentId(T t) {
        return this.getIdReader(t).get();
    }

    public Codec<T> withUuidRepresentation(UuidRepresentation uuidRepresentation) {
        return new JacksonCodec<T>(this.encoder.withUuidRepresentation(uuidRepresentation), this.decoder.withUuidRepresentation(uuidRepresentation));
    }

    private Supplier<BsonValue> getIdReader(T t) {
        Class<?> documentClass = t.getClass();
        Optional<Method> maybeIdGetter = JacksonCodec.getIdGetter(documentClass);
        if (maybeIdGetter.isPresent()) {
            Method getter = maybeIdGetter.get();
            getter.setAccessible(true);
            return () -> {
                try {
                    return JacksonCodec.constructIdValue(getter.invoke(t, new Object[0]), maybeIdGetter);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return BsonNull.VALUE;
                }
            };
        }
        Optional<Field> maybeField = JacksonCodec.getIdField(documentClass);
        if (maybeField.isPresent()) {
            Field field = maybeField.get();
            field.setAccessible(true);
            return () -> {
                try {
                    return JacksonCodec.constructIdValue(field.get(t), maybeField);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return BsonNull.VALUE;
                }
            };
        }
        return () -> BsonNull.VALUE;
    }

    private Consumer<BsonObjectId> getIdWriter(T t) {
        Class<?> documentClass = t.getClass();
        Optional<Method> maybeSetter = JacksonCodec.getIdSetter(documentClass);
        if (maybeSetter.isPresent()) {
            Method setter = maybeSetter.get();
            setter.setAccessible(true);
            return value -> {
                try {
                    if (value != null) {
                        setter.invoke(t, JacksonCodec.extractIdValue(value, setter.getParameterTypes()[0]));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            };
        }
        Optional<Field> maybeField = JacksonCodec.getIdField(documentClass);
        if (maybeField.isPresent()) {
            Field field = maybeField.get();
            field.setAccessible(true);
            return value -> {
                try {
                    field.set(t, JacksonCodec.extractIdValue(value, field.getType()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            };
        }
        return value -> {};
    }

    private static Optional<Field> getIdField(Class<?> documentClass) {
        Field[] fields = documentClass.getDeclaredFields();
        Optional<Field> maybeField = Arrays.stream(fields).filter(field -> field.isAnnotationPresent(javax.persistence.Id.class) || field.isAnnotationPresent(Id.class) || field.getName().equals("_id")).findFirst();
        if (maybeField.isPresent()) {
            return maybeField;
        }
        Class<?> superClass = documentClass.getSuperclass();
        if (superClass != null && !Object.class.equals(superClass)) {
            return JacksonCodec.getIdField(superClass);
        }
        return Optional.empty();
    }

    private static Optional<Method> getIdGetter(Class<?> documentClass) {
        Method[] methods = documentClass.getDeclaredMethods();
        Optional<Method> maybeGetter = Arrays.stream(methods).filter(method -> method.getName().startsWith("get") && method.getParameterCount() == 0 && (method.isAnnotationPresent(javax.persistence.Id.class) || method.isAnnotationPresent(Id.class) || method.getName().equals("get_id"))).findFirst();
        if (maybeGetter.isPresent()) {
            return maybeGetter;
        }
        Class<?> superClass = documentClass.getSuperclass();
        if (superClass != null && !Object.class.equals(superClass)) {
            return JacksonCodec.getIdGetter(superClass);
        }
        return Optional.empty();
    }

    private static Optional<Method> getIdSetter(Class<?> documentClass) {
        Method[] methods = documentClass.getDeclaredMethods();
        Optional<Method> maybeSetter = Arrays.stream(methods).filter(method -> method.getName().startsWith("set") && method.getParameterCount() == 1 && (method.isAnnotationPresent(javax.persistence.Id.class) || method.isAnnotationPresent(Id.class) || method.getName().equals("set_id"))).findFirst();
        if (maybeSetter.isPresent()) {
            return maybeSetter;
        }
        Class<?> superClass = documentClass.getSuperclass();
        if (superClass != null && !Object.class.equals(superClass)) {
            return JacksonCodec.getIdSetter(superClass);
        }
        return Optional.empty();
    }

    private static Object extractIdValue(BsonObjectId value, Class<?> valueType) {
        if (String.class.equals(valueType)) {
            return value.asObjectId().getValue().toHexString();
        }
        if (org.bson.types.ObjectId.class.equals(valueType)) {
            return value.asObjectId().getValue();
        }
        if (byte[].class.equals(valueType)) {
            return value.asObjectId().getValue().toByteArray();
        }
        if (Byte[].class.equals(valueType)) {
            byte[] inputArray = value.asObjectId().getValue().toByteArray();
            Byte[] outputArray = new Byte[inputArray.length];
            for (int i = 0; i < inputArray.length; ++i) {
                outputArray[i] = inputArray[i];
            }
            return outputArray;
        }
        throw new IllegalArgumentException("Unsupported ID type: " + value.getClass());
    }

    public static BsonValue constructIdValue(Object value, Optional<? extends AnnotatedElement> element) {
        if (element.isPresent() && element.get().isAnnotationPresent(ObjectId.class)) {
            if (value instanceof String) {
                return new BsonObjectId(new org.bson.types.ObjectId((String)value));
            }
            if (value instanceof byte[]) {
                return new BsonObjectId(new org.bson.types.ObjectId((byte[])value));
            }
            if (value instanceof Byte[]) {
                Byte[] inputArray = (Byte[])value;
                byte[] outputArray = new byte[inputArray.length];
                for (int i = 0; i < inputArray.length; ++i) {
                    outputArray[i] = inputArray[i];
                }
                return new BsonObjectId(new org.bson.types.ObjectId(outputArray));
            }
        }
        if (value == null) {
            return BsonNull.VALUE;
        }
        if (value instanceof Double) {
            return new BsonDouble(((Double)value).doubleValue());
        }
        if (value instanceof String) {
            return new BsonString((String)value);
        }
        if (value instanceof org.bson.types.ObjectId) {
            return new BsonObjectId((org.bson.types.ObjectId)value);
        }
        if (value instanceof Integer) {
            return new BsonInt32(((Integer)value).intValue());
        }
        if (value instanceof Long) {
            return new BsonInt64(((Long)value).longValue());
        }
        if (value instanceof Decimal128) {
            return new BsonDecimal128((Decimal128)value);
        }
        throw new IllegalArgumentException(String.format("Unsupported ID type: %s", value.getClass()));
    }

    public static Optional<? extends AnnotatedElement> getIdElement(Class<?> documentClass) {
        Optional<Method> maybeIdGetter = JacksonCodec.getIdGetter(documentClass);
        if (maybeIdGetter.isPresent()) {
            return maybeIdGetter;
        }
        return JacksonCodec.getIdField(documentClass);
    }
}

