/*
 * Decompiled with CFR 0.152.
 */
package org.mongojack.internal;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.datatype.jsr310.deser.InstantDeserializer;
import java.io.IOException;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Date;

public class MongoJackInstantDeserializer
extends InstantDeserializer<Instant> {
    public MongoJackInstantDeserializer() {
        super(Instant.class, DateTimeFormatter.ISO_INSTANT, Instant::from, a -> Instant.ofEpochMilli(a.value), a -> Instant.ofEpochSecond(a.integer, a.fraction), null, true);
    }

    public Instant deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        if (parser.getCurrentTokenId() == 12) {
            Object embeddedObject = parser.getEmbeddedObject();
            if (embeddedObject instanceof Instant) {
                return (Instant)embeddedObject;
            }
            if (embeddedObject instanceof Date) {
                return ((Date)embeddedObject).toInstant();
            }
        }
        return (Instant)super.deserialize(parser, context);
    }
}

