/*
 * Decompiled with CFR 0.152.
 */
package org.mongojack.internal;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import org.mongojack.DBRef;

public class DBRefDeserializer<T, K>
extends JsonDeserializer<DBRef> {
    private final JavaType type;
    private final JavaType keyType;
    private final JsonDeserializer<K> keyDeserializer;

    public DBRefDeserializer(JavaType type, JavaType keyType) {
        this(type, keyType, null);
    }

    public DBRefDeserializer(JavaType type, JavaType keyType, JsonDeserializer<K> keyDeserializer) {
        this.type = type;
        this.keyType = keyType;
        this.keyDeserializer = keyDeserializer;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DBRef deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        Object id = null;
        String collectionName = null;
        String databaseName = null;
        JsonToken token = jp.getCurrentToken();
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        if (token == JsonToken.VALUE_EMBEDDED_OBJECT) {
            Object object = jp.getEmbeddedObject();
            if (!(object instanceof com.mongodb.DBRef)) throw ctxt.instantiationException(DBRef.class, "Don't know what to do with embedded object: " + object);
            id = this.keyDeserializer != null ? this.keyDeserializer.deserialize(jp, ctxt) : ((com.mongodb.DBRef)object).getId();
            collectionName = ((com.mongodb.DBRef)object).getCollectionName();
            databaseName = ((com.mongodb.DBRef)object).getDatabaseName();
        } else if (token == JsonToken.START_OBJECT) {
            token = jp.nextValue();
            while (token != JsonToken.END_OBJECT) {
                if (jp.getCurrentName().equals("$id")) {
                    id = this.keyDeserializer != null ? this.keyDeserializer.deserialize(jp, ctxt) : jp.getEmbeddedObject();
                } else if (jp.getCurrentName().equals("$ref")) {
                    collectionName = jp.getText();
                } else if (jp.getCurrentName().equals("$db")) {
                    databaseName = jp.getText();
                }
                token = jp.nextValue();
            }
        }
        if (id == null) {
            return null;
        }
        if (collectionName != null) return new DBRef(id, this.type.getRawClass(), collectionName, databaseName);
        throw ctxt.instantiationException(DBRef.class, "DBRef contains no collection name");
    }
}

