/*
 * Decompiled with CFR 0.152.
 */
package org.mongojack;

import com.mongodb.MongoNamespace;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.client.AggregateIterable;
import com.mongodb.client.ChangeStreamIterable;
import com.mongodb.client.ClientSession;
import com.mongodb.client.DistinctIterable;
import com.mongodb.client.FindIterable;
import com.mongodb.client.ListIndexesIterable;
import com.mongodb.client.MapReduceIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.BulkWriteOptions;
import com.mongodb.client.model.CountOptions;
import com.mongodb.client.model.CreateIndexOptions;
import com.mongodb.client.model.DeleteOptions;
import com.mongodb.client.model.DropIndexOptions;
import com.mongodb.client.model.EstimatedDocumentCountOptions;
import com.mongodb.client.model.FindOneAndDeleteOptions;
import com.mongodb.client.model.FindOneAndReplaceOptions;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.IndexModel;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.InsertManyOptions;
import com.mongodb.client.model.InsertOneOptions;
import com.mongodb.client.model.RenameCollectionOptions;
import com.mongodb.client.model.ReplaceOptions;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.WriteModel;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.InsertManyResult;
import com.mongodb.client.result.InsertOneResult;
import com.mongodb.client.result.UpdateResult;
import com.mongodb.lang.Nullable;
import java.util.List;
import org.bson.Document;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

public abstract class MongoCollectionDecorator<TDocument>
implements MongoCollection<TDocument> {
    protected abstract MongoCollection<TDocument> mongoCollection();

    protected abstract Bson manageUpdateBson(Bson var1);

    protected abstract List<Bson> manageUpdatePipeline(List<? extends Bson> var1);

    protected abstract Bson manageFilterBson(Bson var1);

    protected abstract List<Bson> manageAggregationPipeline(List<? extends Bson> var1);

    protected abstract List<WriteModel<TDocument>> manageBulkWriteRequests(List<? extends WriteModel<? extends TDocument>> var1);

    protected abstract <T> DistinctIterable<T> wrapIterable(DistinctIterable<T> var1);

    protected abstract <T> FindIterable<T> wrapIterable(FindIterable<T> var1);

    protected abstract <T> MapReduceIterable<T> wrapIterable(MapReduceIterable<T> var1);

    public MongoNamespace getNamespace() {
        return this.mongoCollection().getNamespace();
    }

    public Class<TDocument> getDocumentClass() {
        return this.mongoCollection().getDocumentClass();
    }

    public CodecRegistry getCodecRegistry() {
        return this.mongoCollection().getCodecRegistry();
    }

    public ReadPreference getReadPreference() {
        return this.mongoCollection().getReadPreference();
    }

    public WriteConcern getWriteConcern() {
        return this.mongoCollection().getWriteConcern();
    }

    public ReadConcern getReadConcern() {
        return this.mongoCollection().getReadConcern();
    }

    public long countDocuments() {
        return this.mongoCollection().countDocuments();
    }

    public long countDocuments(Bson filter) {
        return this.mongoCollection().countDocuments(this.manageFilterBson(filter));
    }

    public long countDocuments(Bson filter, CountOptions options) {
        return this.mongoCollection().countDocuments(this.manageFilterBson(filter), options);
    }

    public long countDocuments(ClientSession clientSession) {
        return this.mongoCollection().countDocuments(clientSession);
    }

    public long countDocuments(ClientSession clientSession, Bson filter) {
        return this.mongoCollection().countDocuments(clientSession, this.manageFilterBson(filter));
    }

    public long countDocuments(ClientSession clientSession, Bson filter, CountOptions options) {
        return this.mongoCollection().countDocuments(clientSession, this.manageFilterBson(filter), options);
    }

    public long estimatedDocumentCount() {
        return this.mongoCollection().estimatedDocumentCount();
    }

    public long estimatedDocumentCount(EstimatedDocumentCountOptions options) {
        return this.mongoCollection().estimatedDocumentCount(options);
    }

    public <TResult> DistinctIterable<TResult> distinct(String fieldName, Class<TResult> tResultClass) {
        return this.wrapIterable(this.mongoCollection().distinct(fieldName, tResultClass));
    }

    public <TResult> DistinctIterable<TResult> distinct(String fieldName, Bson filter, Class<TResult> tResultClass) {
        return this.wrapIterable(this.mongoCollection().distinct(fieldName, this.manageFilterBson(filter), tResultClass));
    }

    public <TResult> DistinctIterable<TResult> distinct(ClientSession clientSession, String fieldName, Class<TResult> tResultClass) {
        return this.wrapIterable(this.mongoCollection().distinct(clientSession, fieldName, tResultClass));
    }

    public <TResult> DistinctIterable<TResult> distinct(ClientSession clientSession, String fieldName, Bson filter, Class<TResult> tResultClass) {
        return this.wrapIterable(this.mongoCollection().distinct(clientSession, fieldName, this.manageFilterBson(filter), tResultClass));
    }

    public FindIterable<TDocument> find() {
        return this.wrapIterable(this.mongoCollection().find());
    }

    public <TResult> FindIterable<TResult> find(Class<TResult> tResultClass) {
        return this.wrapIterable(this.mongoCollection().find(tResultClass));
    }

    public FindIterable<TDocument> find(Bson filter) {
        return this.wrapIterable(this.mongoCollection().find(this.manageFilterBson(filter)));
    }

    public <TResult> FindIterable<TResult> find(Bson filter, Class<TResult> tResultClass) {
        return this.wrapIterable(this.mongoCollection().find(this.manageFilterBson(filter), tResultClass));
    }

    public FindIterable<TDocument> find(ClientSession clientSession) {
        return this.wrapIterable(this.mongoCollection().find(clientSession));
    }

    public <TResult> FindIterable<TResult> find(ClientSession clientSession, Class<TResult> tResultClass) {
        return this.wrapIterable(this.mongoCollection().find(clientSession, tResultClass));
    }

    public FindIterable<TDocument> find(ClientSession clientSession, Bson filter) {
        return this.wrapIterable(this.mongoCollection().find(clientSession, this.manageFilterBson(filter)));
    }

    public <TResult> FindIterable<TResult> find(ClientSession clientSession, Bson filter, Class<TResult> tResultClass) {
        return this.wrapIterable(this.mongoCollection().find(clientSession, this.manageFilterBson(filter), tResultClass));
    }

    public AggregateIterable<TDocument> aggregate(List<? extends Bson> pipeline) {
        return this.mongoCollection().aggregate(this.manageAggregationPipeline(pipeline));
    }

    public <TResult> AggregateIterable<TResult> aggregate(List<? extends Bson> pipeline, Class<TResult> tResultClass) {
        return this.mongoCollection().aggregate(this.manageAggregationPipeline(pipeline), tResultClass);
    }

    public AggregateIterable<TDocument> aggregate(ClientSession clientSession, List<? extends Bson> pipeline) {
        return this.mongoCollection().aggregate(clientSession, this.manageAggregationPipeline(pipeline));
    }

    public <TResult> AggregateIterable<TResult> aggregate(ClientSession clientSession, List<? extends Bson> pipeline, Class<TResult> tResultClass) {
        return this.mongoCollection().aggregate(clientSession, this.manageAggregationPipeline(pipeline), tResultClass);
    }

    public ChangeStreamIterable<TDocument> watch() {
        return this.mongoCollection().watch();
    }

    public <TResult> ChangeStreamIterable<TResult> watch(Class<TResult> tResultClass) {
        return this.mongoCollection().watch(tResultClass);
    }

    public ChangeStreamIterable<TDocument> watch(List<? extends Bson> pipeline) {
        return this.mongoCollection().watch(this.manageAggregationPipeline(pipeline));
    }

    public <TResult> ChangeStreamIterable<TResult> watch(List<? extends Bson> pipeline, Class<TResult> tResultClass) {
        return this.mongoCollection().watch(this.manageAggregationPipeline(pipeline), tResultClass);
    }

    public ChangeStreamIterable<TDocument> watch(ClientSession clientSession) {
        return this.mongoCollection().watch(clientSession);
    }

    public <TResult> ChangeStreamIterable<TResult> watch(ClientSession clientSession, Class<TResult> tResultClass) {
        return this.mongoCollection().watch(clientSession, tResultClass);
    }

    public ChangeStreamIterable<TDocument> watch(ClientSession clientSession, List<? extends Bson> pipeline) {
        return this.mongoCollection().watch(clientSession, this.manageAggregationPipeline(pipeline));
    }

    public <TResult> ChangeStreamIterable<TResult> watch(ClientSession clientSession, List<? extends Bson> pipeline, Class<TResult> tResultClass) {
        return this.mongoCollection().watch(clientSession, this.manageAggregationPipeline(pipeline), tResultClass);
    }

    public MapReduceIterable<TDocument> mapReduce(String mapFunction, String reduceFunction) {
        return this.wrapIterable(this.mongoCollection().mapReduce(mapFunction, reduceFunction));
    }

    public <TResult> MapReduceIterable<TResult> mapReduce(String mapFunction, String reduceFunction, Class<TResult> tResultClass) {
        return this.wrapIterable(this.mongoCollection().mapReduce(mapFunction, reduceFunction, tResultClass));
    }

    public MapReduceIterable<TDocument> mapReduce(ClientSession clientSession, String mapFunction, String reduceFunction) {
        return this.wrapIterable(this.mongoCollection().mapReduce(clientSession, mapFunction, reduceFunction));
    }

    public <TResult> MapReduceIterable<TResult> mapReduce(ClientSession clientSession, String mapFunction, String reduceFunction, Class<TResult> tResultClass) {
        return this.wrapIterable(this.mongoCollection().mapReduce(clientSession, mapFunction, reduceFunction, tResultClass));
    }

    public BulkWriteResult bulkWrite(List<? extends WriteModel<? extends TDocument>> requests) {
        return this.mongoCollection().bulkWrite(this.manageBulkWriteRequests(requests));
    }

    public BulkWriteResult bulkWrite(List<? extends WriteModel<? extends TDocument>> requests, BulkWriteOptions options) {
        return this.mongoCollection().bulkWrite(this.manageBulkWriteRequests(requests), options);
    }

    public BulkWriteResult bulkWrite(ClientSession clientSession, List<? extends WriteModel<? extends TDocument>> requests) {
        return this.mongoCollection().bulkWrite(clientSession, this.manageBulkWriteRequests(requests));
    }

    public BulkWriteResult bulkWrite(ClientSession clientSession, List<? extends WriteModel<? extends TDocument>> requests, BulkWriteOptions options) {
        return this.mongoCollection().bulkWrite(clientSession, this.manageBulkWriteRequests(requests), options);
    }

    public InsertOneResult insertOne(TDocument tDocument) {
        return this.mongoCollection().insertOne(tDocument);
    }

    public InsertOneResult insertOne(TDocument tDocument, InsertOneOptions options) {
        return this.mongoCollection().insertOne(tDocument, options);
    }

    public InsertOneResult insertOne(ClientSession clientSession, TDocument tDocument) {
        return this.mongoCollection().insertOne(clientSession, tDocument);
    }

    public InsertOneResult insertOne(ClientSession clientSession, TDocument tDocument, InsertOneOptions options) {
        return this.mongoCollection().insertOne(clientSession, tDocument, options);
    }

    public InsertManyResult insertMany(List<? extends TDocument> tDocuments) {
        return this.mongoCollection().insertMany(tDocuments);
    }

    public InsertManyResult insertMany(List<? extends TDocument> tDocuments, InsertManyOptions options) {
        return this.mongoCollection().insertMany(tDocuments, options);
    }

    public InsertManyResult insertMany(ClientSession clientSession, List<? extends TDocument> tDocuments) {
        return this.mongoCollection().insertMany(clientSession, tDocuments);
    }

    public InsertManyResult insertMany(ClientSession clientSession, List<? extends TDocument> tDocuments, InsertManyOptions options) {
        return this.mongoCollection().insertMany(clientSession, tDocuments, options);
    }

    public DeleteResult deleteOne(Bson filter) {
        return this.mongoCollection().deleteOne(this.manageFilterBson(filter));
    }

    public DeleteResult deleteOne(Bson filter, DeleteOptions options) {
        return this.mongoCollection().deleteOne(this.manageFilterBson(filter), options);
    }

    public DeleteResult deleteOne(ClientSession clientSession, Bson filter) {
        return this.mongoCollection().deleteOne(clientSession, this.manageFilterBson(filter));
    }

    public DeleteResult deleteOne(ClientSession clientSession, Bson filter, DeleteOptions options) {
        return this.mongoCollection().deleteOne(clientSession, this.manageFilterBson(filter), options);
    }

    public DeleteResult deleteMany(Bson filter) {
        return this.mongoCollection().deleteMany(this.manageFilterBson(filter));
    }

    public DeleteResult deleteMany(Bson filter, DeleteOptions options) {
        return this.mongoCollection().deleteMany(this.manageFilterBson(filter), options);
    }

    public DeleteResult deleteMany(ClientSession clientSession, Bson filter) {
        return this.mongoCollection().deleteMany(clientSession, this.manageFilterBson(filter));
    }

    public DeleteResult deleteMany(ClientSession clientSession, Bson filter, DeleteOptions options) {
        return this.mongoCollection().deleteMany(clientSession, this.manageFilterBson(filter), options);
    }

    public UpdateResult replaceOne(Bson filter, TDocument replacement) {
        return this.mongoCollection().replaceOne(this.manageFilterBson(filter), replacement);
    }

    public UpdateResult replaceOne(Bson filter, TDocument replacement, ReplaceOptions replaceOptions) {
        return this.mongoCollection().replaceOne(this.manageFilterBson(filter), replacement, replaceOptions);
    }

    public UpdateResult replaceOne(ClientSession clientSession, Bson filter, TDocument replacement) {
        return this.mongoCollection().replaceOne(clientSession, this.manageFilterBson(filter), replacement);
    }

    public UpdateResult replaceOne(ClientSession clientSession, Bson filter, TDocument replacement, ReplaceOptions replaceOptions) {
        return this.mongoCollection().replaceOne(clientSession, this.manageFilterBson(filter), replacement, replaceOptions);
    }

    public UpdateResult updateOne(Bson filter, Bson update) {
        return this.mongoCollection().updateOne(this.manageFilterBson(filter), this.manageUpdateBson(update));
    }

    public UpdateResult updateOne(Bson filter, Bson update, UpdateOptions updateOptions) {
        return this.mongoCollection().updateOne(this.manageFilterBson(filter), this.manageUpdateBson(update), updateOptions);
    }

    public UpdateResult updateOne(ClientSession clientSession, Bson filter, Bson update) {
        return this.mongoCollection().updateOne(clientSession, this.manageFilterBson(filter), this.manageUpdateBson(update));
    }

    public UpdateResult updateOne(ClientSession clientSession, Bson filter, Bson update, UpdateOptions updateOptions) {
        return this.mongoCollection().updateOne(clientSession, this.manageFilterBson(filter), this.manageUpdateBson(update), updateOptions);
    }

    public UpdateResult updateOne(Bson filter, List<? extends Bson> update) {
        return this.mongoCollection().updateOne(this.manageFilterBson(filter), this.manageUpdatePipeline(update));
    }

    public UpdateResult updateOne(Bson filter, List<? extends Bson> update, UpdateOptions updateOptions) {
        return this.mongoCollection().updateOne(this.manageFilterBson(filter), this.manageUpdatePipeline(update), updateOptions);
    }

    public UpdateResult updateOne(ClientSession clientSession, Bson filter, List<? extends Bson> update) {
        return this.mongoCollection().updateOne(clientSession, this.manageFilterBson(filter), this.manageUpdatePipeline(update));
    }

    public UpdateResult updateOne(ClientSession clientSession, Bson filter, List<? extends Bson> update, UpdateOptions updateOptions) {
        return this.mongoCollection().updateOne(clientSession, this.manageFilterBson(filter), this.manageUpdatePipeline(update), updateOptions);
    }

    public UpdateResult updateMany(Bson filter, Bson update) {
        return this.mongoCollection().updateMany(this.manageFilterBson(filter), this.manageUpdateBson(update));
    }

    public UpdateResult updateMany(Bson filter, Bson update, UpdateOptions updateOptions) {
        return this.mongoCollection().updateMany(this.manageFilterBson(filter), this.manageUpdateBson(update), updateOptions);
    }

    public UpdateResult updateMany(ClientSession clientSession, Bson filter, Bson update) {
        return this.mongoCollection().updateMany(clientSession, this.manageFilterBson(filter), this.manageUpdateBson(update));
    }

    public UpdateResult updateMany(ClientSession clientSession, Bson filter, Bson update, UpdateOptions updateOptions) {
        return this.mongoCollection().updateMany(clientSession, this.manageFilterBson(filter), this.manageUpdateBson(update), updateOptions);
    }

    public UpdateResult updateMany(Bson filter, List<? extends Bson> update) {
        return this.mongoCollection().updateMany(this.manageFilterBson(filter), this.manageUpdatePipeline(update));
    }

    public UpdateResult updateMany(Bson filter, List<? extends Bson> update, UpdateOptions updateOptions) {
        return this.mongoCollection().updateMany(this.manageFilterBson(filter), this.manageUpdatePipeline(update), updateOptions);
    }

    public UpdateResult updateMany(ClientSession clientSession, Bson filter, List<? extends Bson> update) {
        return this.mongoCollection().updateMany(clientSession, this.manageFilterBson(filter), this.manageUpdatePipeline(update));
    }

    public UpdateResult updateMany(ClientSession clientSession, Bson filter, List<? extends Bson> update, UpdateOptions updateOptions) {
        return this.mongoCollection().updateMany(clientSession, this.manageFilterBson(filter), this.manageUpdatePipeline(update), updateOptions);
    }

    @Nullable
    public TDocument findOneAndDelete(Bson filter) {
        return (TDocument)this.mongoCollection().findOneAndDelete(this.manageFilterBson(filter));
    }

    @Nullable
    public TDocument findOneAndDelete(Bson filter, FindOneAndDeleteOptions options) {
        return (TDocument)this.mongoCollection().findOneAndDelete(this.manageFilterBson(filter), options);
    }

    @Nullable
    public TDocument findOneAndDelete(ClientSession clientSession, Bson filter) {
        return (TDocument)this.mongoCollection().findOneAndDelete(clientSession, this.manageFilterBson(filter));
    }

    @Nullable
    public TDocument findOneAndDelete(ClientSession clientSession, Bson filter, FindOneAndDeleteOptions options) {
        return (TDocument)this.mongoCollection().findOneAndDelete(clientSession, this.manageFilterBson(filter), options);
    }

    @Nullable
    public TDocument findOneAndReplace(Bson filter, TDocument replacement) {
        return (TDocument)this.mongoCollection().findOneAndReplace(this.manageFilterBson(filter), replacement);
    }

    @Nullable
    public TDocument findOneAndReplace(Bson filter, TDocument replacement, FindOneAndReplaceOptions options) {
        return (TDocument)this.mongoCollection().findOneAndReplace(this.manageFilterBson(filter), replacement, options);
    }

    @Nullable
    public TDocument findOneAndReplace(ClientSession clientSession, Bson filter, TDocument replacement) {
        return (TDocument)this.mongoCollection().findOneAndReplace(clientSession, this.manageFilterBson(filter), replacement);
    }

    @Nullable
    public TDocument findOneAndReplace(ClientSession clientSession, Bson filter, TDocument replacement, FindOneAndReplaceOptions options) {
        return (TDocument)this.mongoCollection().findOneAndReplace(clientSession, this.manageFilterBson(filter), replacement, options);
    }

    @Nullable
    public TDocument findOneAndUpdate(Bson filter, Bson update) {
        return (TDocument)this.mongoCollection().findOneAndUpdate(this.manageFilterBson(filter), this.manageUpdateBson(update));
    }

    @Nullable
    public TDocument findOneAndUpdate(Bson filter, Bson update, FindOneAndUpdateOptions options) {
        return (TDocument)this.mongoCollection().findOneAndUpdate(this.manageFilterBson(filter), this.manageUpdateBson(update), options);
    }

    @Nullable
    public TDocument findOneAndUpdate(ClientSession clientSession, Bson filter, Bson update) {
        return (TDocument)this.mongoCollection().findOneAndUpdate(clientSession, this.manageFilterBson(filter), this.manageUpdateBson(update));
    }

    @Nullable
    public TDocument findOneAndUpdate(ClientSession clientSession, Bson filter, Bson update, FindOneAndUpdateOptions options) {
        return (TDocument)this.mongoCollection().findOneAndUpdate(clientSession, this.manageFilterBson(filter), this.manageUpdateBson(update), options);
    }

    @Nullable
    public TDocument findOneAndUpdate(Bson filter, List<? extends Bson> update) {
        return (TDocument)this.mongoCollection().findOneAndUpdate(this.manageFilterBson(filter), this.manageUpdatePipeline(update));
    }

    @Nullable
    public TDocument findOneAndUpdate(Bson filter, List<? extends Bson> update, FindOneAndUpdateOptions options) {
        return (TDocument)this.mongoCollection().findOneAndUpdate(this.manageFilterBson(filter), this.manageUpdatePipeline(update), options);
    }

    @Nullable
    public TDocument findOneAndUpdate(ClientSession clientSession, Bson filter, List<? extends Bson> update) {
        return (TDocument)this.mongoCollection().findOneAndUpdate(clientSession, this.manageFilterBson(filter), this.manageUpdatePipeline(update));
    }

    @Nullable
    public TDocument findOneAndUpdate(ClientSession clientSession, Bson filter, List<? extends Bson> update, FindOneAndUpdateOptions options) {
        return (TDocument)this.mongoCollection().findOneAndUpdate(clientSession, this.manageFilterBson(filter), this.manageUpdatePipeline(update), options);
    }

    public void drop() {
        this.mongoCollection().drop();
    }

    public void drop(ClientSession clientSession) {
        this.mongoCollection().drop(clientSession);
    }

    public String createIndex(Bson keys) {
        return this.mongoCollection().createIndex(keys);
    }

    public String createIndex(Bson keys, IndexOptions indexOptions) {
        return this.mongoCollection().createIndex(keys, indexOptions);
    }

    public String createIndex(ClientSession clientSession, Bson keys) {
        return this.mongoCollection().createIndex(clientSession, keys);
    }

    public String createIndex(ClientSession clientSession, Bson keys, IndexOptions indexOptions) {
        return this.mongoCollection().createIndex(clientSession, keys, indexOptions);
    }

    public List<String> createIndexes(List<IndexModel> indexes) {
        return this.mongoCollection().createIndexes(indexes);
    }

    public List<String> createIndexes(List<IndexModel> indexes, CreateIndexOptions createIndexOptions) {
        return this.mongoCollection().createIndexes(indexes, createIndexOptions);
    }

    public List<String> createIndexes(ClientSession clientSession, List<IndexModel> indexes) {
        return this.mongoCollection().createIndexes(clientSession, indexes);
    }

    public List<String> createIndexes(ClientSession clientSession, List<IndexModel> indexes, CreateIndexOptions createIndexOptions) {
        return this.mongoCollection().createIndexes(clientSession, indexes, createIndexOptions);
    }

    public ListIndexesIterable<Document> listIndexes() {
        return this.mongoCollection().listIndexes();
    }

    public <TResult> ListIndexesIterable<TResult> listIndexes(Class<TResult> tResultClass) {
        return this.mongoCollection().listIndexes(tResultClass);
    }

    public ListIndexesIterable<Document> listIndexes(ClientSession clientSession) {
        return this.mongoCollection().listIndexes(clientSession);
    }

    public <TResult> ListIndexesIterable<TResult> listIndexes(ClientSession clientSession, Class<TResult> tResultClass) {
        return this.mongoCollection().listIndexes(clientSession, tResultClass);
    }

    public void dropIndex(String indexName) {
        this.mongoCollection().dropIndex(indexName);
    }

    public void dropIndex(String indexName, DropIndexOptions dropIndexOptions) {
        this.mongoCollection().dropIndex(indexName, dropIndexOptions);
    }

    public void dropIndex(Bson keys) {
        this.mongoCollection().dropIndex(keys);
    }

    public void dropIndex(Bson keys, DropIndexOptions dropIndexOptions) {
        this.mongoCollection().dropIndex(keys, dropIndexOptions);
    }

    public void dropIndex(ClientSession clientSession, String indexName) {
        this.mongoCollection().dropIndex(clientSession, indexName);
    }

    public void dropIndex(ClientSession clientSession, Bson keys) {
        this.mongoCollection().dropIndex(clientSession, keys);
    }

    public void dropIndex(ClientSession clientSession, String indexName, DropIndexOptions dropIndexOptions) {
        this.mongoCollection().dropIndex(clientSession, indexName, dropIndexOptions);
    }

    public void dropIndex(ClientSession clientSession, Bson keys, DropIndexOptions dropIndexOptions) {
        this.mongoCollection().dropIndex(clientSession, keys, dropIndexOptions);
    }

    public void dropIndexes() {
        this.mongoCollection().dropIndexes();
    }

    public void dropIndexes(ClientSession clientSession) {
        this.mongoCollection().dropIndexes(clientSession);
    }

    public void dropIndexes(DropIndexOptions dropIndexOptions) {
        this.mongoCollection().dropIndexes(dropIndexOptions);
    }

    public void dropIndexes(ClientSession clientSession, DropIndexOptions dropIndexOptions) {
        this.mongoCollection().dropIndexes(clientSession, dropIndexOptions);
    }

    public void renameCollection(MongoNamespace newCollectionNamespace) {
        this.mongoCollection().renameCollection(newCollectionNamespace);
    }

    public void renameCollection(MongoNamespace newCollectionNamespace, RenameCollectionOptions renameCollectionOptions) {
        this.mongoCollection().renameCollection(newCollectionNamespace, renameCollectionOptions);
    }

    public void renameCollection(ClientSession clientSession, MongoNamespace newCollectionNamespace) {
        this.mongoCollection().renameCollection(clientSession, newCollectionNamespace);
    }

    public void renameCollection(ClientSession clientSession, MongoNamespace newCollectionNamespace, RenameCollectionOptions renameCollectionOptions) {
        this.mongoCollection().renameCollection(clientSession, newCollectionNamespace, renameCollectionOptions);
    }
}

