/*
 * Decompiled with CFR 0.152.
 */
package org.mongojack;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.mongodb.DBObject;
import java.util.concurrent.ConcurrentHashMap;
import org.bson.Document;
import org.bson.UuidRepresentation;
import org.bson.codecs.Codec;
import org.bson.codecs.configuration.CodecProvider;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import org.mongojack.internal.stream.JacksonCodec;
import org.mongojack.internal.stream.JacksonDecoder;
import org.mongojack.internal.stream.JacksonEncoder;
import org.mongojack.internal.util.DocumentSerializationUtils;

public class JacksonCodecRegistry
implements CodecRegistry,
CodecProvider {
    private final ObjectMapper objectMapper;
    private final Class<?> view;
    private final ConcurrentHashMap<Class<?>, Codec<?>> codecCache = new ConcurrentHashMap();
    private final CodecRegistry defaultCodecRegistry;
    private final UuidRepresentation uuidRepresentation;

    public JacksonCodecRegistry(ObjectMapper objectMapper, CodecRegistry defaultCodecRegistry, UuidRepresentation uuidRepresentation) {
        this(objectMapper, defaultCodecRegistry, null, uuidRepresentation);
    }

    public JacksonCodecRegistry(ObjectMapper objectMapper, CodecRegistry defaultCodecRegistry, Class<?> view, UuidRepresentation uuidRepresentation) {
        this.objectMapper = objectMapper;
        this.view = view;
        this.defaultCodecRegistry = defaultCodecRegistry;
        this.uuidRepresentation = uuidRepresentation;
    }

    public <T> Codec<T> get(Class<T> clazz) {
        if (this.isDefault(clazz)) {
            return this.defaultCodecRegistry.get(clazz);
        }
        return this.addCodecForClass(clazz);
    }

    public <T> Codec<T> get(Class<T> clazz, CodecRegistry registry) {
        if (this.isDefault(clazz)) {
            return this.defaultCodecRegistry.get(clazz, registry);
        }
        return this.addCodecForClass(clazz);
    }

    private <T> boolean isDefault(Class<T> clazz) {
        return DocumentSerializationUtils.isKnownClass(clazz) || DBObject.class.isAssignableFrom(clazz) || Document.class.isAssignableFrom(clazz) || Bson.class.isAssignableFrom(clazz);
    }

    public <T> Codec<T> addCodecForClass(Class<T> clazz) {
        return this.codecCache.computeIfAbsent(clazz, k -> {
            JacksonEncoder encoder = new JacksonEncoder(clazz, this.view, this.objectMapper, this.uuidRepresentation);
            JacksonDecoder decoder = new JacksonDecoder(clazz, this.view, this.objectMapper, this.uuidRepresentation);
            return new JacksonCodec(encoder, decoder);
        });
    }

    public UuidRepresentation getUuidRepresentation() {
        return this.uuidRepresentation;
    }
}

