/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.buildblocker;

import hudson.Extension;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.JobPropertyDescriptor;
import hudson.plugins.buildblocker.BuildBlockerUtils;
import hudson.plugins.buildblocker.IBuildBlockerProperty;
import hudson.plugins.buildblocker.Messages;
import hudson.util.FormValidation;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class BuildBlockerProperty
extends JobProperty<Job<?, ?>>
implements IBuildBlockerProperty {
    private static final Logger LOG = Logger.getLogger(BuildBlockerProperty.class.getName());
    private boolean useBuildBlocker;
    private BlockLevel blockLevel;
    private QueueScanScope scanQueueFor;
    private String blockingJobs;

    @Override
    public BlockLevel getBlockLevel() {
        return this.blockLevel != null ? this.blockLevel : BlockLevel.UNDEFINED;
    }

    @Override
    public QueueScanScope getScanQueueFor() {
        return this.scanQueueFor != null ? this.scanQueueFor : QueueScanScope.DISABLED;
    }

    @Override
    public boolean isUseBuildBlocker() {
        return this.useBuildBlocker;
    }

    @Override
    public String getBlockingJobs() {
        return this.blockingJobs;
    }

    @DataBoundConstructor
    public BuildBlockerProperty(boolean useBuildBlocker, String blockLevel, String scanQueueFor, String blockingJobs) {
        LOG.logp(Level.FINE, this.getClass().getName(), "BuildBlockerProperty", "useBuildBlocker: " + useBuildBlocker + " blockLevel: " + blockLevel + " scanQueueFor: " + scanQueueFor + " blockingJobs: " + blockingJobs);
        this.useBuildBlocker = useBuildBlocker;
        this.scanQueueFor = QueueScanScope.from(scanQueueFor);
        this.blockLevel = BlockLevel.from(blockLevel);
        this.blockingJobs = blockingJobs;
    }

    public static enum BlockLevel {
        GLOBAL,
        NODE,
        UNDEFINED;


        public static BlockLevel from(String value) {
            if (value == null) {
                return UNDEFINED;
            }
            try {
                return BlockLevel.valueOf(value.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return UNDEFINED;
            }
        }

        public boolean isGlobal() {
            return this.equals((Object)GLOBAL);
        }

        public boolean isNode() {
            return this.equals((Object)NODE);
        }
    }

    public static enum QueueScanScope {
        ALL,
        BUILDABLE,
        DISABLED;


        public static QueueScanScope from(String value) {
            if (value == null) {
                return DISABLED;
            }
            try {
                return QueueScanScope.valueOf(value.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return DISABLED;
            }
        }

        public boolean isAll() {
            return this.equals((Object)ALL);
        }

        public boolean isBuildable() {
            return this.equals((Object)BUILDABLE);
        }

        public boolean isDisabled() {
            return this.equals((Object)DISABLED);
        }
    }

    @Extension
    @Symbol(value={"buildBlocker"})
    public static final class BuildBlockerDescriptor
    extends JobPropertyDescriptor {
        public String getDisplayName() {
            return Messages.DisplayName();
        }

        public FormValidation doCheckRegex(@QueryParameter String blockingJobs) {
            return BuildBlockerUtils.doCheckRegex(blockingJobs);
        }

        public boolean isApplicable(Class<? extends Job> jobType) {
            return true;
        }
    }
}

