/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.buildblocker;

import com.cloudbees.hudson.plugins.folder.AbstractFolder;
import com.cloudbees.hudson.plugins.folder.AbstractFolderProperty;
import com.cloudbees.hudson.plugins.folder.AbstractFolderPropertyDescriptor;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Extension;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.plugins.buildblocker.BuildBlockerProperty;
import hudson.plugins.buildblocker.BuildBlockerUtils;
import hudson.plugins.buildblocker.IBuildBlockerProperty;
import hudson.plugins.buildblocker.Messages;
import hudson.util.FormValidation;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class BuildBlockerFolderProperty
extends AbstractFolderProperty<AbstractFolder<?>>
implements IBuildBlockerProperty {
    private boolean useBuildBlocker;
    private BuildBlockerProperty.BlockLevel blockLevel;
    private BuildBlockerProperty.QueueScanScope scanQueueFor;
    private String blockingJobs;

    @DataBoundConstructor
    public BuildBlockerFolderProperty() {
    }

    @Override
    public BuildBlockerProperty.BlockLevel getBlockLevel() {
        return this.blockLevel != null ? this.blockLevel : BuildBlockerProperty.BlockLevel.UNDEFINED;
    }

    @Override
    public BuildBlockerProperty.QueueScanScope getScanQueueFor() {
        return this.scanQueueFor != null ? this.scanQueueFor : BuildBlockerProperty.QueueScanScope.DISABLED;
    }

    @Override
    public boolean isUseBuildBlocker() {
        return this.useBuildBlocker;
    }

    @Override
    public String getBlockingJobs() {
        return this.blockingJobs;
    }

    @DataBoundSetter
    public void setBlockLevel(String blockLevel) {
        this.blockLevel = BuildBlockerProperty.BlockLevel.from(blockLevel);
    }

    @DataBoundSetter
    public void setUseBuildBlocker(boolean useBuildBlocker) {
        this.useBuildBlocker = useBuildBlocker;
    }

    @DataBoundSetter
    public void setScanQueueFor(String scanQueueFor) {
        this.scanQueueFor = BuildBlockerProperty.QueueScanScope.from(scanQueueFor);
    }

    @DataBoundSetter
    public void setBlockingJobs(String blockingJobs) {
        this.blockingJobs = blockingJobs;
    }

    @Extension(optional=true)
    @Symbol(value={"folderBuildBlocker"})
    public static final class DescriptorImpl
    extends AbstractFolderPropertyDescriptor {
        public String getDisplayName() {
            return Messages.DisplayName();
        }

        public FormValidation doCheckRegex(@QueryParameter String blockingJobs) {
            return BuildBlockerUtils.doCheckRegex(blockingJobs);
        }

        @Nullable
        public IBuildBlockerProperty getBuildBlockerFolderProperty(Job<?, ?> job) {
            ItemGroup itemGroup = job.getParent();
            while (itemGroup instanceof AbstractFolder) {
                AbstractFolder folder = (AbstractFolder)itemGroup;
                BuildBlockerFolderProperty folderProperty = (BuildBlockerFolderProperty)folder.getProperties().get(BuildBlockerFolderProperty.class);
                if (folderProperty != null) {
                    return folderProperty;
                }
                itemGroup = folder.getParent();
            }
            return null;
        }
    }
}

