/*
 * Decompiled with CFR 0.152.
 */
package jenkins.branch;

import com.cloudbees.hudson.plugins.folder.health.FolderHealthMetric;
import com.cloudbees.hudson.plugins.folder.health.FolderHealthMetricDescriptor;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.model.Items;
import hudson.model.TaskListener;
import hudson.util.DescribableList;
import hudson.util.XStream2;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import jenkins.branch.Messages;
import jenkins.branch.MultiBranchProject;
import jenkins.branch.OrganizationFolder;
import jenkins.branch.OrganizationFolderProperty;
import jenkins.branch.OrganizationFolderPropertyDescriptor;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.stapler.DataBoundConstructor;

public class OrganizationChildHealthMetricsProperty
extends OrganizationFolderProperty<OrganizationFolder> {
    private final List<FolderHealthMetric> templates;
    @CheckForNull
    private transient Map<FolderHealthMetric, String> templateXML;

    @DataBoundConstructor
    public OrganizationChildHealthMetricsProperty(List<FolderHealthMetric> templates) {
        this.templates = new ArrayList<FolderHealthMetric>(Util.fixNull(templates));
    }

    public List<FolderHealthMetric> getTemplates() {
        return Collections.unmodifiableList(this.templates);
    }

    @NonNull
    private String templateXML(@NonNull FolderHealthMetric template) {
        if (this.templateXML == null) {
            this.templateXML = new ConcurrentHashMap<FolderHealthMetric, String>();
        }
        return this.templateXML.computeIfAbsent(template, arg_0 -> ((XStream2)Items.XSTREAM2).toXML(arg_0));
    }

    private boolean sameAsTemplate(FolderHealthMetric template, FolderHealthMetric trigger) {
        return this.templateXML(template).equals(Items.XSTREAM2.toXML((Object)trigger));
    }

    private <T extends FolderHealthMetric> T newInstance(T template) {
        return (T)((FolderHealthMetric)Items.XSTREAM2.fromXML(this.templateXML(template)));
    }

    @Override
    protected void decorate(@NonNull MultiBranchProject<?, ?> child, @NonNull TaskListener listener) throws IOException {
        DescribableList metrics = child.getHealthMetrics();
        ArrayList<FolderHealthMetric> toAdd = new ArrayList<FolderHealthMetric>(this.templates);
        boolean updated = false;
        ArrayList<FolderHealthMetric> update = new ArrayList<FolderHealthMetric>((Collection<FolderHealthMetric>)metrics);
        ListIterator<FolderHealthMetric> currentIter = update.listIterator();
        block0: while (currentIter.hasNext()) {
            FolderHealthMetric current = (FolderHealthMetric)currentIter.next();
            Iterator templateIter = toAdd.iterator();
            while (templateIter.hasNext()) {
                FolderHealthMetric healthMetric = (FolderHealthMetric)templateIter.next();
                if (!current.getClass().equals(healthMetric.getClass())) continue;
                templateIter.remove();
                if (this.sameAsTemplate(healthMetric, current)) continue block0;
                updated = true;
                currentIter.set(this.newInstance(healthMetric));
                continue block0;
            }
            currentIter.remove();
        }
        for (FolderHealthMetric healthMetric : toAdd) {
            updated = true;
            update.add(this.newInstance(healthMetric));
        }
        if (updated) {
            metrics.replaceBy(update);
        }
    }

    @Extension
    public static class DescriptorImpl
    extends OrganizationFolderPropertyDescriptor {
        @NonNull
        public String getDisplayName() {
            return Messages.OrganizationChildHealthMetricsProperty_DisplayName();
        }

        @Restricted(value={DoNotUse.class})
        @NonNull
        public List<FolderHealthMetricDescriptor> getHealthMetricDescriptors() {
            ArrayList<FolderHealthMetricDescriptor> r = new ArrayList<FolderHealthMetricDescriptor>();
            for (FolderHealthMetricDescriptor d : FolderHealthMetricDescriptor.all()) {
                if (!d.isApplicable(MultiBranchProject.class)) continue;
                r.add(d);
            }
            return r;
        }

        @Restricted(value={DoNotUse.class})
        @NonNull
        public List<FolderHealthMetric> getDefaultTemplates() {
            ArrayList<FolderHealthMetric> metrics = new ArrayList<FolderHealthMetric>();
            for (FolderHealthMetricDescriptor d : FolderHealthMetricDescriptor.all()) {
                FolderHealthMetric metric;
                if (!d.isApplicable(MultiBranchProject.class) || (metric = d.createDefault()) == null) continue;
                metrics.add(metric);
            }
            return metrics;
        }
    }
}

