/*
 * Decompiled with CFR 0.152.
 */
package jenkins.branch;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.ListView;
import hudson.model.View;
import hudson.model.ViewGroup;
import hudson.security.ACL;
import hudson.security.Permission;
import java.io.IOException;
import jenkins.scm.api.SCMCategory;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.springframework.security.core.Authentication;

@Restricted(value={NoExternalUse.class})
public abstract class BaseView<T extends SCMCategory<?>>
extends ListView {
    private final T category;

    public BaseView(ViewGroup owner, @NonNull T category) {
        super(category.getName(), owner);
        this.category = category;
    }

    public String getDisplayName() {
        return String.valueOf(this.category.getDisplayName()) + " (" + this.getItems().size() + ")";
    }

    public boolean isRecurse() {
        return false;
    }

    @NonNull
    public ACL getACL() {
        final ACL acl = super.getACL();
        return new ACL(){

            public boolean hasPermission2(@NonNull Authentication a, @NonNull Permission permission) {
                if (View.CREATE.equals((Object)permission) || View.CONFIGURE.equals((Object)permission) || View.DELETE.equals((Object)permission)) {
                    return false;
                }
                return acl.hasPermission2(a, permission);
            }
        };
    }

    public void save() throws IOException {
    }
}

