/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.bootstrap5;

import hudson.model.ModelObject;
import hudson.model.Run;
import io.jenkins.plugins.bootstrap5.Messages;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class MessagesViewModel
implements ModelObject {
    private final Run<?, ?> owner;
    private final List<String> errorMessages;
    private final List<String> infoMessages;
    private final String displayName;

    public MessagesViewModel(Run<?, ?> owner, String displayName, List<String> infoMessages) {
        this(owner, displayName, infoMessages, Collections.emptyList());
    }

    public MessagesViewModel(Run<?, ?> owner, String displayName, List<String> infoMessages, List<String> errorMessages) {
        this.owner = owner;
        this.errorMessages = this.asImmutableList(errorMessages);
        this.infoMessages = this.asImmutableList(infoMessages);
        this.displayName = displayName + " - " + Messages.Messages_View_Name();
    }

    private List<String> asImmutableList(List<String> elements) {
        return Collections.unmodifiableList(new ArrayList<String>(elements));
    }

    public final Run<?, ?> getOwner() {
        return this.owner;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Collection<String> getInfoMessages() {
        return this.infoMessages;
    }

    public Collection<String> getErrorMessages() {
        return this.errorMessages;
    }

    public boolean hasErrors() {
        return !this.errorMessages.isEmpty();
    }
}

