/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.plugin.diagnosis;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.AdministrativeMonitor;
import hudson.model.ItemGroup;
import hudson.model.User;
import hudson.security.ACL;
import hudson.security.ACLContext;
import hudson.util.HttpResponses;
import io.jenkins.blueocean.rest.impl.pipeline.credential.BlueOceanCredentialsProvider;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import jenkins.model.Jenkins;
import jenkins.scm.api.SCMSource;
import jenkins.util.SystemProperties;
import jenkins.util.Timer;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.workflow.multibranch.WorkflowMultiBranchProject;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.HttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension
@Symbol(value={"bo-credentials"})
@Restricted(value={NoExternalUse.class})
public class BlueOceanCredentialsMonitor
extends AdministrativeMonitor {
    private static final Logger LOGGER = LoggerFactory.getLogger(BlueOceanCredentialsProvider.class);
    private final Map<String, String> projectsNamesUrlsWithBoFolderCred = new ConcurrentHashMap<String, String>();
    private static final long SCANNING_INTERVAL = SystemProperties.getLong((String)(BlueOceanCredentialsMonitor.class.getName() + ".scanning.interval.minutes"), (Long)30L);

    public String getDisplayName() {
        return "Blue Ocean credentials provider";
    }

    public boolean isBlueOceanCredentialsProvidedEnabled() {
        return ((BlueOceanCredentialsProvider)ExtensionList.lookupSingleton(BlueOceanCredentialsProvider.class)).isEnabled(null);
    }

    public boolean isActivated() {
        return !this.projectsNamesUrlsWithBoFolderCred.isEmpty() || this.isBlueOceanCredentialsProvidedEnabled();
    }

    public boolean isSecurity() {
        return true;
    }

    public Map<String, String> getProjectsNamesUrlsWithBoFolderCred() {
        return this.projectsNamesUrlsWithBoFolderCred;
    }

    @Initializer(after=InitMilestone.JOB_LOADED)
    public void scanBlueOceanCredentials() {
        if (SCANNING_INTERVAL < 1L) {
            LOGGER.info("BlueOceanCredentialsMonitor scanning is deactivated");
            return;
        }
        Timer.get().scheduleAtFixedRate(this::scanInstance, 0L, SCANNING_INTERVAL, TimeUnit.MINUTES);
    }

    public HttpResponse doScan() {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        this.scanInstance();
        return HttpResponses.redirectToDot();
    }

    private void scanInstance() {
        LOGGER.debug("scan multibranch projects");
        List projects = Jenkins.get().getItems(WorkflowMultiBranchProject.class);
        HashMap<String, String> projectsNamesUrls = new HashMap<String, String>();
        for (WorkflowMultiBranchProject project : projects) {
            for (SCMSource scmSource : project.getSCMSources()) {
                try {
                    Method getCredentialsIdMethod = scmSource.getClass().getDeclaredMethod("getCredentialsId", null);
                    String credentialsId = (String)getCredentialsIdMethod.invoke((Object)scmSource, null);
                    BlueOceanCredentialsProvider.FolderPropertyImpl property = (BlueOceanCredentialsProvider.FolderPropertyImpl)project.getProperties().get(BlueOceanCredentialsProvider.FolderPropertyImpl.class);
                    if (property == null || !StringUtils.equals((String)property.getId(), (String)credentialsId) || this.findCredentials(property.getUser(), credentialsId) == null) continue;
                    projectsNamesUrls.put(project.getDisplayName(), project.getUrl());
                }
                catch (NoSuchMethodException e) {
                    LOGGER.debug("SCMSource: {} do not have method getCredentialsId", (Object)scmSource.getClass().getName());
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    LOGGER.debug("SCMSource: '" + scmSource.getClass().getName() + "' cannot retrieve credentialId via getCredentialsId", (Throwable)e);
                }
            }
        }
        this.projectsNamesUrlsWithBoFolderCred.clear();
        this.projectsNamesUrlsWithBoFolderCred.putAll(projectsNamesUrls);
        LOGGER.debug("end scan multibranch projects, projects found {}", (Object)projectsNamesUrls.size());
    }

    private Credentials findCredentials(String userId, String credentialsId) {
        User proxyUser = User.get((String)userId, (boolean)false, Collections.emptyMap());
        try (ACLContext ignored = ACL.as((Authentication)proxyUser.impersonate());){
            StandardCredentials standardCredentials = (StandardCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StandardCredentials.class, (ItemGroup)Jenkins.get(), (Authentication)Jenkins.getAuthentication(), (List)null), (CredentialsMatcher)CredentialsMatchers.allOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.withId((String)credentialsId), CredentialsMatchers.withScope((CredentialsScope)CredentialsScope.USER)}));
            if (standardCredentials != null) {
                LOGGER.debug("find standardCredentials for user {} with id {} and description {}", new Object[]{userId, credentialsId, standardCredentials.getDescription()});
            } else {
                LOGGER.debug("find standardCredentials for user {} with id {}", (Object)userId, (Object)credentialsId);
            }
            StandardCredentials standardCredentials2 = standardCredentials;
            return standardCredentials2;
        }
    }
}

