/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.service.embedded.rest;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.Item;
import hudson.model.ItemGroup;
import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.factory.BluePipelineFactory;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.model.BlueOrganization;
import io.jenkins.blueocean.rest.model.BluePipeline;
import io.jenkins.blueocean.rest.model.BluePipelineContainer;
import io.jenkins.blueocean.service.embedded.rest.ContainerFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class PipelineContainerImpl
extends BluePipelineContainer {
    @NonNull
    private final ItemGroup itemGroup;
    private final Link self;

    public PipelineContainerImpl(BlueOrganization organization, ItemGroup itemGroup, Reachable parent) {
        super(organization);
        this.itemGroup = itemGroup;
        this.self = parent.getLink().rel("pipelines");
    }

    public Link getLink() {
        return this.self;
    }

    public BluePipeline get(String name) {
        Item item = this.itemGroup.getItem(name);
        if (item == null) {
            throw new ServiceException.NotFoundException(String.format("Pipeline %s not found", name));
        }
        return BluePipelineFactory.getPipelineInstance((Item)item, (Reachable)this);
    }

    public Iterator<BluePipeline> iterator() {
        return this.getPipelines(this.itemGroup.getItems());
    }

    public Iterator<BluePipeline> getPipelines(Collection<? extends Item> items) {
        items = ContainerFilter.filter(items);
        ArrayList<BluePipeline> pipelines = new ArrayList<BluePipeline>();
        for (Item item : items) {
            BluePipeline pipeline = BluePipelineFactory.getPipelineInstance((Item)item, (Reachable)this);
            if (pipeline == null) continue;
            pipelines.add(pipeline);
        }
        return pipelines.iterator();
    }
}

