/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.service.embedded.rest;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.model.AbstractItem;
import hudson.model.Item;
import hudson.model.ItemGroup;
import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.factory.BluePipelineFactory;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.model.BlueActionProxy;
import io.jenkins.blueocean.rest.model.BlueFavorite;
import io.jenkins.blueocean.rest.model.BlueFavoriteAction;
import io.jenkins.blueocean.rest.model.BlueIcon;
import io.jenkins.blueocean.rest.model.BlueOrganization;
import io.jenkins.blueocean.rest.model.BluePipeline;
import io.jenkins.blueocean.rest.model.BluePipelineContainer;
import io.jenkins.blueocean.rest.model.BluePipelineFolder;
import io.jenkins.blueocean.rest.model.BluePipelineScm;
import io.jenkins.blueocean.rest.model.BlueTrendContainer;
import io.jenkins.blueocean.rest.model.Resource;
import io.jenkins.blueocean.service.embedded.rest.AbstractPipelineImpl;
import io.jenkins.blueocean.service.embedded.rest.PipelineContainerImpl;
import io.jenkins.blueocean.service.embedded.util.Disabler;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.kohsuke.stapler.json.JsonBody;

public class PipelineFolderImpl
extends BluePipelineFolder {
    protected final BlueOrganization organization;
    private final ItemGroup<?> folder;
    protected final Link parent;

    public PipelineFolderImpl(BlueOrganization organization, ItemGroup<?> folder, Link parent) {
        this.organization = organization;
        this.folder = folder;
        this.parent = parent;
    }

    public String getOrganizationName() {
        return this.organization.getName();
    }

    @NonNull
    public BlueOrganization getOrganization() {
        return this.organization;
    }

    public String getName() {
        if (this.folder instanceof AbstractItem) {
            return ((AbstractItem)this.folder).getName();
        }
        return this.folder.getDisplayName();
    }

    public String getDisplayName() {
        return this.folder.getDisplayName();
    }

    public String getFullName() {
        if (this.folder instanceof Item) {
            return AbstractPipelineImpl.getFullName(this.organization, (Item)this.folder);
        }
        return null;
    }

    public String getFullDisplayName() {
        if (this.folder instanceof Item) {
            return AbstractPipelineImpl.getFullDisplayName(this.organization, (Item)this.folder);
        }
        return this.folder.getDisplayName();
    }

    public Collection<BlueActionProxy> getActions() {
        return Collections.emptyList();
    }

    public List<Object> getParameters() {
        return null;
    }

    public BluePipelineContainer getPipelines() {
        return new PipelineContainerImpl(this.organization, this.folder, (Reachable)this);
    }

    public Integer getNumberOfFolders() {
        int count = 0;
        for (BluePipeline p : this.getPipelines()) {
            if (!(p instanceof BluePipelineFolder)) continue;
            ++count;
        }
        return count;
    }

    public Integer getNumberOfPipelines() {
        int count = 0;
        for (BluePipeline p : this.getPipelines()) {
            if (p instanceof BluePipelineFolder) continue;
            ++count;
        }
        return count;
    }

    public BlueFavorite favorite(@JsonBody BlueFavoriteAction favoriteAction) {
        throw new ServiceException.MethodNotAllowedException("Cannot favorite a folder");
    }

    public Map<String, Boolean> getPermissions() {
        if (this.folder instanceof AbstractItem) {
            AbstractItem item = (AbstractItem)this.folder;
            return AbstractPipelineImpl.getPermissions(item);
        }
        return null;
    }

    public BluePipelineScm getScm() {
        return null;
    }

    public Link getLink() {
        return this.organization.getLink().rel("pipelines").rel(AbstractPipelineImpl.getRecursivePathFromFullName((BluePipeline)this));
    }

    public BlueIcon getIcon() {
        return null;
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"}, justification="getPipelines() can definitely be null see MatrixProjectImpl so findbugs is wrong...")
    public Iterable<String> getPipelineFolderNames() {
        BluePipelineContainer bluePipelineContainer = this.getPipelines();
        if (bluePipelineContainer == null) {
            return Collections.emptyList();
        }
        return StreamSupport.stream(bluePipelineContainer.spliterator(), false).map(bluePipeline -> bluePipeline instanceof BluePipelineFolder ? bluePipeline.getName() : null).collect(Collectors.toList());
    }

    public BlueTrendContainer getTrends() {
        return null;
    }

    public Boolean getDisabled() {
        return Disabler.isDisabled(this.folder);
    }

    public void enable() throws IOException {
        if (this.getPermissions().getOrDefault("configure", Boolean.FALSE).booleanValue()) {
            Disabler.makeDisabled(this.folder, false);
        }
    }

    public void disable() throws IOException {
        if (this.getPermissions().getOrDefault("configure", Boolean.FALSE).booleanValue()) {
            Disabler.makeDisabled(this.folder, true);
        }
    }

    @Extension(ordinal=-10.0)
    public static class PipelineFactoryImpl
    extends BluePipelineFactory {
        public PipelineFolderImpl getPipeline(Item item, Reachable parent, BlueOrganization organization) {
            if (item instanceof ItemGroup) {
                return new PipelineFolderImpl(organization, (ItemGroup)item, parent.getLink());
            }
            return null;
        }

        public Resource resolve(Item context, Reachable parent, Item target, BlueOrganization organization) {
            PipelineFolderImpl folder = this.getPipeline(context, parent, organization);
            if (folder != null) {
                if (context == target) {
                    return folder;
                }
                Item nextChild = PipelineFactoryImpl.findNextStep(folder.folder, (Item)target);
                for (BluePipelineFactory f : PipelineFactoryImpl.all()) {
                    Resource answer = f.resolve(nextChild, (Reachable)folder, target, organization);
                    if (answer == null) continue;
                    return answer;
                }
            }
            return null;
        }
    }
}

