/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.rest.impl.pipeline.scm;

import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.model.Item;
import io.jenkins.blueocean.commons.ErrorMessage;
import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.rest.impl.pipeline.ScmContentProvider;
import io.jenkins.blueocean.rest.impl.pipeline.scm.ScmContentProviderParams;
import java.util.ArrayList;
import jenkins.branch.MultiBranchProject;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.StaplerRequest2;

public abstract class AbstractScmContentProvider
extends ScmContentProvider {
    @Override
    public Object getContent(@NonNull StaplerRequest2 request, @NonNull Item item) {
        String path = StringUtils.defaultIfEmpty((String)request.getParameter("path"), null);
        String type = StringUtils.defaultIfEmpty((String)request.getParameter("type"), null);
        String repo = StringUtils.defaultIfEmpty((String)request.getParameter("repo"), null);
        String branch = StringUtils.defaultIfEmpty((String)request.getParameter("branch"), null);
        ArrayList<ErrorMessage.Error> errors = new ArrayList<ErrorMessage.Error>();
        if (!(item instanceof MultiBranchProject) && repo == null) {
            errors.add(new ErrorMessage.Error("repo", ErrorMessage.Error.ErrorCodes.MISSING.toString(), String.format("repo and branch parameters are required because pipeline %s is not a multi-branch project ", item.getFullName())));
        }
        if (type != null && !type.equals("file")) {
            errors.add(new ErrorMessage.Error("file", ErrorMessage.Error.ErrorCodes.INVALID.toString(), String.format("type %s not supported. Only 'file' type supported.", type)));
        }
        if (path == null) {
            errors.add(new ErrorMessage.Error("path", ErrorMessage.Error.ErrorCodes.MISSING.toString(), "path is required query parameter"));
        }
        if (!errors.isEmpty()) {
            throw new ServiceException.BadRequestException(new ErrorMessage(Integer.valueOf(400), "Failed to load scm file").addAll(errors));
        }
        ScmContentProviderParams scmParamsFromItem = this.getScmParamsFromItem(item);
        if (repo == null && scmParamsFromItem.getRepo() == null) {
            throw new ServiceException.BadRequestException("github repo could not be determine from pipeline: " + item.getFullName());
        }
        if (repo != null && scmParamsFromItem.getRepo() != null && !repo.equals(scmParamsFromItem.getRepo())) {
            throw new ServiceException.BadRequestException(String.format("repo parameter %s doesn't match with repo in pipeline %s github configuration repo: %s ", repo, item.getFullName(), scmParamsFromItem.getRepo()));
        }
        if (repo == null) {
            repo = scmParamsFromItem.getRepo();
        }
        ScmGetRequest scmGetRequest = new ScmGetRequest.Builder(scmParamsFromItem.getApiUrl()).branch(branch).owner(scmParamsFromItem.getOwner()).repo(repo).branch(branch).path(path).credentials(scmParamsFromItem.getCredentials()).build();
        return this.getContent(scmGetRequest);
    }

    protected abstract Object getContent(ScmGetRequest var1);

    protected abstract ScmContentProviderParams getScmParamsFromItem(Item var1);

    public static class ScmGetRequest {
        private final String apiUrl;
        private final String owner;
        private final String repo;
        private final String branch;
        private final String path;
        private final String type;
        private final StandardUsernamePasswordCredentials credentials;

        private ScmGetRequest(@NonNull String apiUrl, @NonNull String owner, @NonNull String repo, @Nullable String branch, @NonNull String path, @Nullable String type, @NonNull StandardUsernamePasswordCredentials credentials) {
            this.apiUrl = apiUrl;
            this.owner = owner;
            this.repo = repo;
            this.branch = branch;
            this.path = path;
            this.type = type;
            this.credentials = credentials;
        }

        public String getApiUrl() {
            return this.apiUrl;
        }

        public String getOwner() {
            return this.owner;
        }

        public String getRepo() {
            return this.repo;
        }

        public String getBranch() {
            return this.branch;
        }

        public String getPath() {
            return this.path;
        }

        public String getType() {
            return this.type;
        }

        public StandardUsernamePasswordCredentials getCredentials() {
            return this.credentials;
        }

        public static class Builder {
            private String apiUrl;
            private String owner;
            private String repo;
            private String branch;
            private String path;
            private String type;
            private StandardUsernamePasswordCredentials credentials;

            public Builder(String apiUrl) {
                this.apiUrl = apiUrl;
            }

            Builder owner(String owner) {
                this.owner = owner;
                return this;
            }

            Builder repo(String repo) {
                this.repo = repo;
                return this;
            }

            Builder path(String path) {
                this.path = path;
                return this;
            }

            Builder branch(String branch) {
                this.branch = branch;
                return this;
            }

            Builder type(String type) {
                this.type = type;
                return this;
            }

            Builder credentials(StandardUsernamePasswordCredentials credentials) {
                this.credentials = credentials;
                return this;
            }

            public ScmGetRequest build() {
                return new ScmGetRequest(this.apiUrl, this.owner, this.repo, this.branch, this.path, this.type, this.credentials);
            }
        }
    }
}

