/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.job.views;

import hudson.Extension;
import hudson.model.Action;
import hudson.util.HttpResponses;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import jenkins.model.TransientActionFactory;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.workflow.graph.BlockEndNode;
import org.jenkinsci.plugins.workflow.graph.BlockStartNode;
import org.jenkinsci.plugins.workflow.graph.FlowGraphWalker;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.graph.StepNode;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.kohsuke.stapler.HttpResponse;

public final class GraphDumpAction
implements Action {
    public final WorkflowRun run;

    private GraphDumpAction(WorkflowRun run) {
        this.run = run;
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public String getUrlName() {
        return "graphDump";
    }

    public HttpResponse doIndex() throws IOException {
        JSONArray response = new JSONArray();
        FlowGraphWalker walker = new FlowGraphWalker(this.run.getExecution());
        for (FlowNode node : walker) {
            StepNode sn;
            Object descriptor;
            JSONObject outputNode = new JSONObject();
            outputNode.put("id", (Object)node.getId());
            outputNode.put("name", (Object)node.getDisplayName());
            outputNode.put("functionName", (Object)node.getDisplayFunctionName());
            outputNode.put("className", (Object)node.getClass().getName());
            outputNode.put("enclosingId", (Object)node.getEnclosingId());
            outputNode.put("isBegin", (Object)(node instanceof BlockStartNode));
            outputNode.put("isEnd", (Object)(node instanceof BlockEndNode));
            outputNode.put("isStepNode", (Object)(node instanceof StepNode));
            if (node instanceof StepNode && (descriptor = (sn = (StepNode)node).getDescriptor()) != null) {
                JSONObject outputDescriptor = new JSONObject();
                outputDescriptor.put("getDisplayName", (Object)descriptor.getDisplayName());
                outputDescriptor.put("getFunctionName", (Object)descriptor.getFunctionName());
                outputNode.put("stepDescriptor", (Object)outputDescriptor);
            }
            JSONArray parents = new JSONArray();
            descriptor = node.getParents().iterator();
            while (descriptor.hasNext()) {
                FlowNode parent = (FlowNode)descriptor.next();
                parents.add((Object)parent.getId());
            }
            outputNode.put("parents", (Object)parents);
            if (node instanceof BlockStartNode) {
                BlockStartNode startNode = (BlockStartNode)node;
                BlockEndNode endNode = startNode.getEndNode();
                outputNode.put("endNodeId", (Object)(endNode == null ? null : endNode.getId()));
            } else if (node instanceof BlockEndNode) {
                BlockEndNode endNode = (BlockEndNode)node;
                outputNode.put("startNodeId", (Object)endNode.getStartNode().getId());
            }
            JSONArray actions = new JSONArray();
            for (Action action : node.getAllActions()) {
                JSONObject outputAction = new JSONObject();
                outputAction.put("className", (Object)action.getClass().getName());
                outputAction.put("displayName", (Object)action.getDisplayName());
                actions.add((Object)outputAction);
            }
            outputNode.put("actions", (Object)actions);
            response.add((Object)outputNode);
        }
        return HttpResponses.okJSON((JSONArray)response);
    }

    @Extension
    public static final class Factory
    extends TransientActionFactory<WorkflowRun> {
        public Class<WorkflowRun> type() {
            return WorkflowRun.class;
        }

        public Collection<? extends Action> createFor(WorkflowRun run) {
            return Collections.singleton(new GraphDumpAction(run));
        }
    }
}

