/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.preload;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.User;
import hudson.plugins.favorite.user.FavoriteUserProperty;
import io.jenkins.blueocean.commons.PageStatePreloader;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import jenkins.scm.api.metadata.PrimaryInstanceMetadataAction;
import net.sf.json.JSONArray;

@Extension
public class FavoriteListStatePreloader
extends PageStatePreloader {
    @NonNull
    public String getStatePropertyPath() {
        return "favoritesList";
    }

    @CheckForNull
    public String getStateJson() {
        User jenkinsUser = User.current();
        if (jenkinsUser == null) {
            return null;
        }
        FavoriteUserProperty fup = (FavoriteUserProperty)jenkinsUser.getProperty(FavoriteUserProperty.class);
        if (fup == null) {
            return null;
        }
        Set favorites = fup.getAllFavorites();
        if (favorites == null) {
            return null;
        }
        Jenkins jenkins = Jenkins.get();
        List favoritPreloads = favorites.stream().map(name -> {
            Job job;
            Item item = jenkins.getItemByFullName(name);
            if (item instanceof Job && (job = (Job)item).getAction(PrimaryInstanceMetadataAction.class) != null) {
                return new FavoritPreload((String)name, true);
            }
            return new FavoritPreload((String)name, false);
        }).collect(Collectors.toList());
        return JSONArray.fromObject(favoritPreloads).toString();
    }

    public static class FavoritPreload {
        private final String name;
        private final boolean isPrimary;

        public FavoritPreload(String name, boolean isPrimary) {
            this.name = name;
            this.isPrimary = isPrimary;
        }

        public String getName() {
            return this.name;
        }

        public boolean isPrimary() {
            return this.isPrimary;
        }
    }
}

