/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.blueocean_git_pipeline;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jgit.lib.ProgressMonitor;

class CloneProgressMonitor
implements ProgressMonitor {
    private final String repositoryUrl;
    private final AtomicInteger cloneCount = new AtomicInteger(0);
    private final AtomicInteger latestProgress = new AtomicInteger(0);
    private boolean cancel = false;
    private static final Map<String, CloneProgressMonitor> currentStatus = new ConcurrentHashMap<String, CloneProgressMonitor>();

    public CloneProgressMonitor(String repositoryUrl) {
        this.repositoryUrl = repositoryUrl;
    }

    public void beginTask(String task, int i) {
        CloneProgressMonitor existing = currentStatus.computeIfAbsent(this.repositoryUrl, k -> this);
        existing.cloneCount.incrementAndGet();
        existing.latestProgress.set(i);
    }

    public void start(int i) {
        this.latestProgress.set(i);
    }

    public void update(int i) {
        this.latestProgress.set(i);
    }

    public void endTask() {
        this.latestProgress.set(100);
        if (0 == this.cloneCount.decrementAndGet()) {
            currentStatus.remove(this.repositoryUrl);
        }
    }

    public boolean isCancelled() {
        return this.cancel;
    }

    public void showDuration(boolean enabled) {
    }

    public int getPercentComplete() {
        return this.latestProgress.get();
    }

    public void cancel() {
        this.cancel = true;
    }

    public static CloneProgressMonitor get(String repositoryUrl) {
        return currentStatus.get(repositoryUrl);
    }
}

