'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _class, _temp;

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var JenkinsEncode = exports.JenkinsEncode = (_temp = _class = function () {
    function JenkinsEncode() {
        _classCallCheck(this, JenkinsEncode);
    }

    _createClass(JenkinsEncode, null, [{
        key: '_getUrlMap',
        value: function _getUrlMap() {
            if (this._uriMap == null) {
                var raw = "!  $ &'()*+,-. 0123456789   =  @ABCDEFGHIJKLMNOPQRSTUVWXYZ    _ abcdefghijklmnopqrstuvwxyz";
                this._uriMap = [];

                var i = 0;
                for (i = 0; i < 33; i++) {
                    this._uriMap[i] = true;
                }

                for (var j = 0; j < raw.length; i++, j++) {
                    this._uriMap[i] = raw.charAt(j) == ' ';
                }
            }
            return this._uriMap;
        }
    }, {
        key: 'encode',
        value: function encode(str) {
            var uriMap = this._getUrlMap();

            return str.split('').map(function (c) {
                var charCode = c.charCodeAt(0);
                if (charCode > 122 || uriMap[charCode]) {
                    return encodeURIComponent(c);
                }
                return c;
            }).join('');
        }
    }]);

    return JenkinsEncode;
}(), _class._uriMap = null, _temp);
//# sourceMappingURL=jenkins-encode.js.map
