'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.DeDupeCallTracker = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

exports.dedupe = dedupe;

var _bluebird = require('bluebird');

var _bluebird2 = _interopRequireDefault(_bluebird);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * DuplicateCallTracker maintains active calls against a particular key
 */
var DeDupeCallTracker = exports.DeDupeCallTracker = function () {
    function DeDupeCallTracker() {
        _classCallCheck(this, DeDupeCallTracker);

        /**
         * Onload callbacks cache. Used to ensure we don't
         * issue multiple in-parallel requests for the same
         * class metadata.
         */
        this.promises = {};
    }

    /**
     * Generalization of duplicate request consolidation:
     *
     * @key: key to use to track the duplicate requests
     * @promiseCreator: function that will return an initial promise, e.g. () => fetch(...)
     * @return a Promise
     */


    _createClass(DeDupeCallTracker, [{
        key: 'dedupe',
        value: function dedupe(key, promiseCreator) {
            var _this = this;

            // get active or create
            return this.promises[key] || (this.promises[key] = promiseCreator().then(function (data) {
                delete _this.promises[key];
                return data;
            }).catch(function (err) {
                delete _this.promises[key];
                return _bluebird2.default.reject(err);
            }));
        }
    }]);

    return DeDupeCallTracker;
}();

var deDupeCallTracker = new DeDupeCallTracker();

/**
 * Generalization of duplicate request consolidation:
 *
 * @key: key to use to track the duplicate requests
 * @promiseCreator: function that will return an initial promise, e.g. () => fetch(...)
 * @return a Promise
 */
function dedupe(key, promiseCreator) {
    return deDupeCallTracker.dedupe(key, promiseCreator);
}
//# sourceMappingURL=dedupe-calls.js.map
