'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
var jenkinsRootURL = '';
var blueOceanAppURL = '/';
var restBaseURL = '';
var crumbToken = '';
var crumbHeaderName = '';

var loaded = false;

function loadConfig() {
    try {
        var headElement = document.getElementsByTagName('head')[0];

        // typically '/jenkins/'
        jenkinsRootURL = headElement.getAttribute('data-rooturl');
        if (typeof jenkinsRootURL !== 'string') {
            jenkinsRootURL = '/';
        }

        // typically '/jenkins/blue'
        blueOceanAppURL = headElement.getAttribute('data-appurl');
        if (typeof blueOceanAppURL !== 'string') {
            blueOceanAppURL = '/';
        }

        // typically '/jenkins/blue/rest'
        restBaseURL = (blueOceanAppURL + '/rest').replace(/\/\/+/g, '/'); // eliminate any duplicated slashes

        // load crumb token used for POST requests
        crumbToken = headElement.getAttribute('data-crumbtoken');
        if (typeof crumbToken !== 'string') {
            crumbToken = '';
        }

        // load crumb header name used for POST requests
        crumbHeaderName = headElement.getAttribute('data-crumbtoken-field');
        if (typeof crumbHeaderName !== 'string') {
            crumbHeaderName = '';
        }

        loaded = true;
    } catch (error) {
        // eslint-disable-next-line no-console
        console.warn('error reading attributes from document; urls will be empty', error);

        loaded = false;
    }
}

var UrlConfig = exports.UrlConfig = {
    getJenkinsRootURL: function getJenkinsRootURL() {
        if (!loaded) {
            loadConfig();
        }
        return jenkinsRootURL;
    },
    getBlueOceanAppURL: function getBlueOceanAppURL() {
        if (!loaded) {
            loadConfig();
        }
        return blueOceanAppURL;
    },
    getCrumbHeaderName: function getCrumbHeaderName() {
        if (!loaded) {
            loadConfig();
        }
        return crumbHeaderName;
    },
    getCrumbToken: function getCrumbToken() {
        if (!loaded) {
            loadConfig();
        }
        return crumbToken;
    },
    getRestBaseURL: function getRestBaseURL() {
        if (!loaded) {
            loadConfig();
        }
        return restBaseURL;
    },

    // for testing purposes: allow url's to be reloaded
    enableReload: function enableReload() {
        loaded = false;
    }
};
//# sourceMappingURL=urlconfig.js.map
