'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.TestUtil = exports.User = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }(); /**
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Created by cmeyers on 7/8/16.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */

var _scopes = require('./scopes');

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var PipelinePermissions = function () {
    function PipelinePermissions() {
        var blueUser = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

        _classCallCheck(this, PipelinePermissions);

        if (blueUser.permission && blueUser.permission.pipeline) {
            this._permissions = blueUser.permission.pipeline;
        } else {
            this._permissions = {};
        }
    }

    _createClass(PipelinePermissions, [{
        key: 'create',
        value: function create() {
            return !!this._permissions.create;
        }
    }, {
        key: 'read',
        value: function read() {
            return !!this._permissions.read;
        }
    }, {
        key: 'start',
        value: function start() {
            return !!this._permissions.start;
        }
    }, {
        key: 'stop',
        value: function stop() {
            return !!this._permissions.stop;
        }
    }, {
        key: 'configure',
        value: function configure() {
            return !!this._permissions.configure;
        }
    }]);

    return PipelinePermissions;
}();

var CredentialPermissions = function () {
    function CredentialPermissions() {
        var blueUser = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

        _classCallCheck(this, CredentialPermissions);

        if (blueUser.permission && blueUser.permission.credential) {
            this._permissions = blueUser.permission.credential;
        } else {
            this._permissions = {};
        }
    }

    _createClass(CredentialPermissions, [{
        key: 'create',
        value: function create() {
            return !!this._permissions.create;
        }
    }, {
        key: 'view',
        value: function view() {
            return !!this._permissions.view;
        }
    }, {
        key: 'delete',
        value: function _delete() {
            return !!this._permissions.delete;
        }
    }, {
        key: 'update',
        value: function update() {
            return !!this._permissions.update;
        }
    }, {
        key: 'manageDomains',
        value: function manageDomains() {
            return !!this._permissions.manageDomains;
        }
    }]);

    return CredentialPermissions;
}();

var User = exports.User = function () {
    function User() {
        var blueUser = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

        _classCallCheck(this, User);

        this._blueUser = blueUser;
    }

    _createClass(User, [{
        key: 'isAnonymous',
        value: function isAnonymous() {
            return this.id === 'anonymous';
        }
    }, {
        key: '_class',
        get: function get() {
            return this._blueUser._class;
        }
    }, {
        key: '_links',
        get: function get() {
            return this._blueUser._links;
        }
    }, {
        key: 'email',
        get: function get() {
            return this._blueUser.email;
        }
    }, {
        key: 'fullName',
        get: function get() {
            return this._blueUser.fullName;
        }
    }, {
        key: 'id',
        get: function get() {
            return this._blueUser.id || 'anonymous';
        }
    }, {
        key: 'isAdministrator',
        get: function get() {
            var permission = this._blueUser.permission || {};
            return !!permission.administrator;
        }
    }, {
        key: 'permissions',
        get: function get() {
            return {
                pipeline: new PipelinePermissions(this._blueUser),
                credential: new CredentialPermissions(this._blueUser)
            };
        }
    }], [{
        key: 'current',
        value: function current() {
            return CURRENT; // eslint-disable-line no-use-before-define
        }
    }]);

    return User;
}();

var CURRENT = new User(_scopes.blueocean.user);

/* eslint-disable */
var TestUtil = exports.TestUtil = {
    setCurrent: function setCurrent(user) {
        CURRENT = new User(user);
    }
};
/* eslint-enable */
//# sourceMappingURL=User.js.map
